/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TraceLock
extends ReentrantLock {
    private static final long serialVersionUID = 1997992705529515418L;
    @Nullable
    private volatile Throwable here;

    TraceLock() {
    }

    @NotNull
    public static ReentrantLock create() {
        return Jvm.isDebug() ? new TraceLock() : new ReentrantLock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        super.lockInterruptibly();
        this.here = new StackTrace();
    }

    @Override
    public void lock() {
        super.lock();
        this.here = new StackTrace();
    }

    @Override
    public String toString() {
        @Nullable Throwable here = this.here;
        if (here == null) {
            return super.toString();
        }
        @NotNull StringBuilder sb = new StringBuilder(super.toString());
        for (StackTraceElement s : here.getStackTrace()) {
            sb.append("\n\tat ").append(s);
        }
        return sb.toString();
    }

    @Override
    public void unlock() {
        if (this.getHoldCount() == 1) {
            this.here = null;
        }
        super.unlock();
    }

    @Override
    public boolean tryLock() {
        boolean b = super.tryLock();
        if (b) {
            this.here = new StackTrace();
        }
        return b;
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        boolean b = super.tryLock(timeout, unit);
        if (b) {
            this.here = new StackTrace();
        }
        return b;
    }
}

