/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.openhft.chronicle.network.NetworkContext;
import org.jetbrains.annotations.NotNull;

public class ConnectionManager<T extends NetworkContext<T>> {
    private final Set<ConnectionListener<T>> connectionListeners = Collections.newSetFromMap(new IdentityHashMap());
    @NotNull
    private final IdentityHashMap<T, AtomicBoolean> isConnected = new IdentityHashMap();

    public synchronized void addListener(@NotNull ConnectionListener<T> connectionListener) {
        this.connectionListeners.add(connectionListener);
        this.isConnected.forEach((wireOutPublisher, connected) -> connectionListener.onConnectionChange(wireOutPublisher, connected.get()));
    }

    public synchronized void onConnectionChanged(boolean isConnected, @NotNull T nc) {
        @NotNull Function<NetworkContext, AtomicBoolean> f = v -> new AtomicBoolean();
        boolean wasConnected = this.isConnected.computeIfAbsent(nc, f).getAndSet(isConnected);
        if (wasConnected != isConnected) {
            this.connectionListeners.forEach(l -> {
                try {
                    l.onConnectionChange(nc, isConnected);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
    }

    @FunctionalInterface
    public static interface ConnectionListener<T extends NetworkContext<T>> {
        public void onConnectionChange(T var1, boolean var2);
    }
}

