/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster.handlers;

import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.ConnectionListener;
import net.openhft.chronicle.network.api.session.SubHandler;
import net.openhft.chronicle.network.api.session.WritableSubHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.network.cluster.HeartbeatEventHandler;
import net.openhft.chronicle.network.cluster.handlers.CspTcpHandler;
import net.openhft.chronicle.network.cluster.handlers.RejectedHandlerException;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UberHandler<T extends ClusteredNetworkContext<T>>
extends CspTcpHandler<T>
implements Demarshallable,
WriteMarshallable {
    private final int remoteIdentifier;
    private final int localIdentifier;
    @NotNull
    private final AtomicBoolean isClosing = new AtomicBoolean();
    @Nullable
    private ConnectionManager<T> connectionChangedNotifier;

    @UsedViaReflection
    private UberHandler(@NotNull WireIn wire) {
        this.remoteIdentifier = wire.read("remoteIdentifier").int32();
        this.localIdentifier = wire.read("localIdentifier").int32();
        @NotNull WireType wireType = (WireType)Objects.requireNonNull(wire.read("wireType").object(WireType.class));
        this.wireType(wireType);
    }

    private UberHandler(int localIdentifier, int remoteIdentifier, @NotNull WireType wireType) {
        this.localIdentifier = localIdentifier;
        this.remoteIdentifier = remoteIdentifier;
        assert (remoteIdentifier != localIdentifier) : "remoteIdentifier=" + remoteIdentifier + ", localIdentifier=" + localIdentifier;
        this.wireType(wireType);
    }

    private static String peekContents(@NotNull DocumentContext dc) {
        try {
            return dc.wire().readingPeekYaml();
        }
        catch (RuntimeException e) {
            return "Failed to peek at contents due to: " + e.getMessage();
        }
    }

    public int remoteIdentifier() {
        return this.remoteIdentifier;
    }

    public boolean isClosed() {
        return this.isClosing.get();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((CharSequence)"remoteIdentifier").int32(this.localIdentifier);
        wire.write((CharSequence)"localIdentifier").int32(this.remoteIdentifier);
        wire.write((CharSequence)"wireType").object((Object)this.wireType);
    }

    @Override
    protected void onInitialize() {
        ClusteredNetworkContext nc = (ClusteredNetworkContext)this.nc();
        nc.wireType(this.wireType());
        this.isAcceptor(nc.isAcceptor());
        assert (this.checkIdentifierEqualsHostId());
        assert (this.remoteIdentifier != this.localIdentifier) : "remoteIdentifier=" + this.remoteIdentifier + ", localIdentifier=" + this.localIdentifier;
        WireOutPublisher publisher = nc.wireOutPublisher();
        this.publisher(publisher);
        @NotNull EventLoop eventLoop = nc.eventLoop();
        if (!eventLoop.isClosed()) {
            eventLoop.start();
            if (((ClusteredNetworkContext)this.nc()).isAcceptor()) {
                this.publish(UberHandler.uberHandler(this.localIdentifier, this.remoteIdentifier, this.wireType));
            }
            if (!this.isClosed()) {
                this.notifyConnectionListeners();
            }
        }
    }

    private boolean checkIdentifierEqualsHostId() {
        return this.localIdentifier == ((ClusteredNetworkContext)this.nc()).getLocalHostIdentifier() || 0 == ((ClusteredNetworkContext)this.nc()).getLocalHostIdentifier();
    }

    private void notifyConnectionListeners() {
        this.connectionChangedNotifier = ((ClusterContext)((Object)((ClusteredNetworkContext)this.nc()).clusterContext())).connectionManager(this.remoteIdentifier);
        if (this.connectionChangedNotifier != null) {
            this.connectionChangedNotifier.onConnectionChanged(true, this.nc());
        }
    }

    public static WriteMarshallable uberHandler(int localIdentifier, int remoteIdentifier, WireType wireType) {
        return wire -> {
            try (DocumentContext ignored = wire.writingDocument(true);){
                wire.write(() -> "handler").typedMarshallable(new UberHandler(localIdentifier, remoteIdentifier, wireType));
            }
        };
    }

    @Override
    protected void performClose() {
        ClusteredNetworkContext nc = (ClusteredNetworkContext)this.nc();
        if (!this.isClosing.getAndSet(true) && this.connectionChangedNotifier != null) {
            this.connectionChangedNotifier.onConnectionChanged(false, nc);
        }
        try {
            ConnectionListener listener;
            if (nc != null && (listener = nc.acquireConnectionListener()) != null) {
                listener.onDisconnected(this.localIdentifier, this.remoteIdentifier(), nc.isAcceptor());
            }
        }
        catch (Exception e) {
            Jvm.error().on(this.getClass(), "close:", (Throwable)e);
            throw Jvm.rethrow((Throwable)e);
        }
        Closeable.closeQuietly((Object)this.writers);
        this.writers.clear();
        super.performClose();
    }

    @Override
    protected void onRead(@NotNull DocumentContext dc, @NotNull WireOut outWire) {
        try {
            if (this.isClosing.get()) {
                return;
            }
            SubHandler handler = this.handler();
            if (handler != null && handler.inProgress()) {
                try {
                    if (!handler.onTouch(outWire)) {
                        dc.rollbackOnClose();
                        return;
                    }
                }
                catch (Exception e) {
                    this.removeHandler(handler);
                }
                return;
            }
            this.onMessageReceivedOrWritten();
            Wire inWire = dc.wire();
            if (dc.isMetaData()) {
                if (!this.readMeta((WireIn)inWire)) {
                    return;
                }
                SubHandler handler2 = this.handler();
                handler2.remoteIdentifier(this.remoteIdentifier);
                handler2.localIdentifier(this.localIdentifier);
                try {
                    handler2.onInitialize(outWire);
                    if (handler2.inProgress()) {
                        dc.rollbackOnClose();
                        return;
                    }
                }
                catch (RejectedExecutionException e) {
                    Jvm.warn().on(this.getClass(), "EventGroup shutdown", (Throwable)e);
                    this.removeHandler(handler2);
                }
                catch (RejectedHandlerException ex) {
                    Jvm.debug().on(this.getClass(), "Removing rejected handler: " + handler2);
                    this.removeHandler(handler2);
                }
                return;
            }
            SubHandler handler3 = this.handler();
            if (handler3 != null && dc.isData() && !inWire.bytes().isEmpty()) {
                try {
                    handler3.onRead((WireIn)inWire, outWire);
                }
                catch (RejectedHandlerException ex) {
                    Jvm.debug().on(this.getClass(), "Removing rejected handler: " + handler3);
                    this.removeHandler(handler3);
                }
            } else {
                Jvm.warn().on(this.getClass(), "handler == null, check that the Csp/Cid has been sent, failed to fully process the following YAML\n");
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
    }

    @Override
    protected void onBytesWritten() {
        this.onMessageReceivedOrWritten();
    }

    @Override
    protected void onWrite(@NotNull WireOut outWire) {
        for (int i = 0; i < this.writers.size(); ++i) {
            try {
                if (this.isClosing.get()) {
                    return;
                }
                WritableSubHandler w = (WritableSubHandler)this.writers.get(i);
                if (w == null) continue;
                w.onWrite(outWire);
                continue;
            }
            catch (Exception e) {
                Jvm.error().on(this.getClass(), "onWrite:", (Throwable)e);
                throw Jvm.rethrow((Throwable)e);
            }
        }
    }

    private void onMessageReceivedOrWritten() {
        HeartbeatEventHandler heartbeatEventHandler = this.heartbeatEventHandler();
        if (heartbeatEventHandler != null) {
            heartbeatEventHandler.onMessageReceived();
        }
    }

    public String toString() {
        return "UberHandler{remoteIdentifier=" + this.remoteIdentifier + ", localIdentifier=" + this.localIdentifier + ", isClosing=" + this.isClosing + '}';
    }
}

