/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.logger.LoggerFactoryUtil;
import net.openhft.chronicle.network.TCPRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketAddressSupplier
implements Supplier<SocketAddress> {
    private static final Logger LOG = LoggerFactoryUtil.initialize((Logger)LoggerFactory.getLogger(SocketAddressSupplier.class));
    @NotNull
    private final String name;
    private final List<RemoteAddressSupplier> remoteAddresses = new ArrayList<RemoteAddressSupplier>();
    private final long failoverTimeout = Integer.getInteger("tcp.failover.time", 2000).intValue();
    @Nullable
    private RemoteAddressSupplier current;
    private int addressCount = 0;
    private String toString;

    public SocketAddressSupplier(@NotNull String[] connectURIs, @NotNull String name) {
        this.name = name;
        for (String connectURI : connectURIs) {
            this.remoteAddresses.add(new RemoteAddressSupplier(connectURI));
        }
        assert (!this.remoteAddresses.isEmpty());
    }

    @NotNull
    public static SocketAddressSupplier uri(String connectURI) {
        return new SocketAddressSupplier(new String[]{connectURI}, "");
    }

    @NotNull
    public List<RemoteAddressSupplier> all() {
        return this.remoteAddresses;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public void failoverToNextAddress() {
        if (LOG.isDebugEnabled()) {
            Jvm.debug().on(this.getClass(), "failing over to next address");
        }
        this.next();
    }

    public void resetToPrimary() {
        this.addressCount = 0;
        this.current = this.remoteAddresses.get(this.addressCount);
    }

    private void next() {
        this.addressCount = (this.addressCount + 1) % this.remoteAddresses.size();
        this.current = this.remoteAddresses.get(this.addressCount);
    }

    public int size() {
        return this.remoteAddresses.size();
    }

    public int index() {
        return this.addressCount;
    }

    public long timeoutMS() {
        return this.failoverTimeout;
    }

    @Override
    @Nullable
    public InetSocketAddress get() {
        @Nullable RemoteAddressSupplier current = this.current;
        if (current == null) {
            return null;
        }
        return current.get();
    }

    @Nullable
    public String getDescription() {
        @Nullable RemoteAddressSupplier current = this.current;
        if (current == null) {
            return null;
        }
        return current.toString();
    }

    @NotNull
    public String toString() {
        if (this.toString == null) {
            this.toString = this.log(this.current);
        }
        return this.toString;
    }

    public String remoteAddresses() {
        ArrayList result = new ArrayList();
        this.remoteAddresses.forEach(r -> result.add(this.log((RemoteAddressSupplier)r)));
        return ((Object)result).toString();
    }

    @NotNull
    public String log(RemoteAddressSupplier current) {
        if (current == null) {
            return "(none)";
        }
        InetSocketAddress socketAddress = current.get();
        if (socketAddress == null) {
            return "(none)";
        }
        String s = ((Object)socketAddress).toString();
        if (s.contains("0:0:0:0:0:0:0:0")) {
            s = "localhost";
        }
        return s + " - " + current;
    }

    private class RemoteAddressSupplier
    implements Supplier<SocketAddress> {
        private final InetSocketAddress remoteAddress;
        @NotNull
        private final String description;

        public RemoteAddressSupplier(String description) {
            this.description = description;
            this.remoteAddress = TCPRegistry.lookup(description);
        }

        @Override
        public InetSocketAddress get() {
            return this.remoteAddress;
        }

        @NotNull
        public String toString() {
            return this.description;
        }
    }
}

