/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.network.ssl.BufferHandler;
import net.openhft.chronicle.network.ssl.Handshaker;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SslEngineStateMachine {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslEngineStateMachine.class);
    private final BufferHandler bufferHandler;
    private final boolean isAcceptor;
    private SSLEngine engine;
    private ByteBuffer outboundApplicationData;
    private ByteBuffer outboundEncodedData;
    private ByteBuffer inboundEncodedData;
    private ByteBuffer inboundApplicationData;
    private ByteBuffer[] precomputedWrapArray;
    private ByteBuffer[] precomputedUnwrapArray;

    SslEngineStateMachine(BufferHandler bufferHandler, boolean isAcceptor) {
        this.bufferHandler = bufferHandler;
        this.isAcceptor = isAcceptor;
    }

    void initialise(SSLContext ctx, ChronicleSocketChannel channel) {
        try {
            channel.configureBlocking(false);
            this.engine = ctx.createSSLEngine();
            this.engine.setUseClientMode(!this.isAcceptor);
            if (this.isAcceptor) {
                this.engine.setNeedClientAuth(true);
            }
            this.outboundApplicationData = ByteBuffer.allocateDirect(this.engine.getSession().getApplicationBufferSize());
            this.outboundEncodedData = ByteBuffer.allocateDirect(this.engine.getSession().getPacketBufferSize());
            this.inboundApplicationData = ByteBuffer.allocateDirect(this.engine.getSession().getApplicationBufferSize());
            this.inboundEncodedData = ByteBuffer.allocateDirect(this.engine.getSession().getPacketBufferSize());
            this.precomputedWrapArray = new ByteBuffer[]{this.outboundApplicationData};
            this.precomputedUnwrapArray = new ByteBuffer[]{this.inboundApplicationData};
            new Handshaker().performHandshake(this.engine, channel);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to perform handshake at " + Instant.now(), e);
        }
    }

    public boolean action() {
        boolean busy = false;
        this.bufferHandler.handleDecryptedData(this.inboundApplicationData, this.outboundApplicationData);
        try {
            int read;
            if (this.outboundApplicationData.position() != 0) {
                this.outboundApplicationData.flip();
                if (this.engine.wrap(this.precomputedWrapArray, this.outboundEncodedData).getStatus() == SSLEngineResult.Status.CLOSED) {
                    LOGGER.warn("Socket closed");
                    return false;
                }
                busy = this.outboundApplicationData.hasRemaining();
                this.outboundApplicationData.compact();
            }
            if (this.outboundEncodedData.position() != 0) {
                this.outboundEncodedData.flip();
                this.bufferHandler.writeData(this.outboundEncodedData);
                busy |= this.outboundEncodedData.hasRemaining();
                this.outboundEncodedData.compact();
            }
            if ((read = this.bufferHandler.readData(this.inboundEncodedData)) == -1) {
                throw new IORuntimeException("Socket closed");
            }
            busy |= read != 0;
            if (this.inboundEncodedData.position() != 0) {
                this.inboundEncodedData.flip();
                this.engine.unwrap(this.inboundEncodedData, this.precomputedUnwrapArray);
                busy |= this.inboundEncodedData.hasRemaining();
                this.inboundEncodedData.compact();
            }
            if (this.inboundApplicationData.position() != 0) {
                this.inboundApplicationData.flip();
                this.bufferHandler.handleDecryptedData(this.inboundApplicationData, this.outboundApplicationData);
                busy |= this.inboundApplicationData.hasRemaining();
                this.inboundApplicationData.compact();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return busy;
    }

    void close() {
        this.engine.closeOutbound();
    }
}

