/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.ConnectionListener;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.network.api.session.SubHandler;
import net.openhft.chronicle.network.api.session.WritableSubHandler;
import net.openhft.chronicle.network.cluster.HeartbeatEventHandler;
import net.openhft.chronicle.network.cluster.handlers.Registerable;
import net.openhft.chronicle.network.cluster.handlers.RejectedHandlerException;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CspTcpHandler<T extends NetworkContext<T>>
extends WireTcpHandler<T> {
    protected final List<WritableSubHandler<T>> writers = new ArrayList<WritableSubHandler<T>>();
    @NotNull
    private final Map<Long, SubHandler<T>> cidToHandle = new HashMap<Long, SubHandler<T>>();
    private final Map<Object, SubHandler<T>> registry = new HashMap<Object, SubHandler<T>>();
    @Nullable
    private SubHandler<T> handler;
    @Nullable
    private HeartbeatEventHandler heartbeatEventHandler;
    private long lastCid;

    @Nullable
    protected SubHandler<T> handler() {
        return this.handler;
    }

    @Override
    public void close() {
        Closeable.closeQuietly(this.cidToHandle.values());
        super.close();
    }

    protected void removeHandler(SubHandler<T> handler) {
        this.cidToHandle.remove(handler.cid());
        if (this.handler == handler) {
            this.handler = null;
            this.lastCid = 0L;
        }
        Closeable.closeQuietly(handler);
    }

    protected boolean readMeta(@NotNull WireIn wireIn) {
        StringBuilder event = Wires.acquireStringBuilder();
        @NotNull ValueIn valueIn = wireIn.readEventName(event);
        if (CoreFields.csp.contentEquals(event)) {
            @Nullable String csp = valueIn.text();
            event.setLength(0);
            valueIn = wireIn.readEventName(event);
            if (!CoreFields.cid.contentEquals(event)) {
                throw new IllegalStateException("expecting 'cid' but eventName=" + event);
            }
            long cid = valueIn.int64();
            event.setLength(0);
            valueIn = wireIn.readEventName(event);
            if (CoreFields.handler.contentEquals(event)) {
                if (this.cidToHandle.containsKey(cid)) {
                    String registeredCsp = this.cidToHandle.get(cid).csp();
                    if (!registeredCsp.equals(csp)) {
                        Jvm.warn().on(this.getClass(), "cid: " + cid + " already has handler registered with different csp, registered csp:" + registeredCsp + ", received csp: " + csp);
                    }
                    return false;
                }
                try {
                    this.handler = (SubHandler)valueIn.typedMarshallable();
                    this.handler.nc(this.nc());
                }
                catch (RejectedHandlerException ex) {
                    Jvm.warn().on(this.getClass(), "Handler for csp=" + csp + ", cid=" + cid + " was rejected: " + ex.getMessage(), (Throwable)ex);
                    this.handler = null;
                    this.lastCid = cid;
                    return false;
                }
                this.handler.closeable(this);
                try {
                    if (this.handler instanceof Registerable) {
                        Registerable registerable = (Registerable)((Object)this.handler);
                        this.registry.put(registerable.registryKey(), this.handler);
                        registerable.registry(this.registry);
                    }
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), (Throwable)e);
                }
                if (this.handler instanceof ConnectionListener) {
                    this.nc().addConnectionListener((ConnectionListener)((Object)this.handler));
                }
                if (this.handler() instanceof HeartbeatEventHandler) {
                    assert (this.heartbeatEventHandler == null) : "its assumed that you will only have a single heartbeatReceiver per connection";
                    this.heartbeatEventHandler = (HeartbeatEventHandler)((Object)this.handler());
                }
                this.handler.cid(cid);
                this.handler.csp(csp);
                this.lastCid = cid;
                this.cidToHandle.put(cid, this.handler);
                if (this.handler instanceof WritableSubHandler) {
                    this.writers.add((WritableSubHandler)this.handler);
                }
            } else {
                throw new IllegalStateException("expecting 'cid' but eventName=" + event);
            }
            return true;
        }
        if (CoreFields.cid.contentEquals(event)) {
            long cid = valueIn.int64();
            if (cid == this.lastCid) {
                return false;
            }
            this.lastCid = cid;
            this.handler = this.cidToHandle.get(cid);
            if (this.handler == null) {
                throw new IllegalStateException("handler not found : for CID=" + cid + ", known cids=" + this.cidToHandle.keySet());
            }
        } else {
            throw new IllegalStateException("expecting either csp or cid, event=" + event);
        }
        return false;
    }

    @Nullable
    protected HeartbeatEventHandler heartbeatEventHandler() {
        return this.heartbeatEventHandler;
    }
}

