/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.tcp.ISocketChannel;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public final class ReadWithFlowControl
implements TcpEventHandler.SocketReader {
    private int len = 0;
    private boolean hasReadLen = false;
    private int position = 0;
    private int limit = 4;
    private int rawLen;

    @Override
    public int read(@NotNull ISocketChannel socketChannel, @NotNull Bytes<ByteBuffer> bytes) throws IOException {
        ByteBuffer bb = (ByteBuffer)Objects.requireNonNull(bytes.underlyingObject());
        bb.limit(this.limit);
        bb.position(this.position);
        if (this.hasReadLen) {
            bytes.writeInt(0L, this.rawLen);
        } else {
            socketChannel.read(bb);
            if (bb.position() < bb.limit()) {
                return 0;
            }
            this.rawLen = bytes.readInt((long)this.len);
            this.len = Wires.lengthOf((int)this.rawLen);
            bytes.ensureCapacity((long)(this.len + 4));
            bb = (ByteBuffer)Objects.requireNonNull(bytes.underlyingObject());
            this.limit(this.len + 8);
            this.position(4);
            this.limit(this.len + 4);
            bb.limit(this.limit);
            this.hasReadLen = true;
        }
        socketChannel.read(bb);
        if (bb.position() == this.len + 4) {
            this.position(0);
            this.limit(4);
            int result = this.len;
            bytes.readPositionRemaining(0L, (long)this.len);
            this.hasReadLen = false;
            this.len = 0;
            return result;
        }
        if (bb.position() == this.len + 8) {
            this.position(4);
            int result = this.len;
            this.rawLen = bytes.readInt((long)this.len);
            this.len = Wires.lengthOf((int)this.rawLen);
            this.limit(this.len + 4);
            bytes.ensureCapacity((long)(this.len + 4));
            bb = (ByteBuffer)Objects.requireNonNull(bytes.underlyingObject());
            bb.position(this.len + 4);
            bytes.readPositionRemaining(0L, (long)result);
            this.hasReadLen = true;
            return result;
        }
        if (bb.position() > this.len + 4) {
            throw new IllegalStateException("an error has occurred, position=" + bb.position());
        }
        return 0;
    }

    private void limit(int limit) {
        this.limit = limit;
    }

    private void position(int position) {
        this.position = position;
    }
}

