/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import java.nio.ByteBuffer;
import java.time.Instant;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.NetworkContextManager;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.ssl.BytesBufferHandler;
import net.openhft.chronicle.network.ssl.SslEngineStateMachine;
import net.openhft.chronicle.network.ssl.SslNetworkContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslDelegatingTcpHandler<N extends SslNetworkContext<N>>
implements TcpHandler<N>,
NetworkContextManager<N> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslDelegatingTcpHandler.class);
    private final TcpHandler<N> delegate;
    private final BytesBufferHandler<N> bufferHandler = new BytesBufferHandler();
    private SslEngineStateMachine stateMachine;
    private boolean handshakeComplete;

    public SslDelegatingTcpHandler(TcpHandler<N> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out, N nc) {
        this.throwExceptionIfClosed();
        if (!this.handshakeComplete) {
            try {
                this.doHandshake(nc);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to complete SSL handshake at " + Instant.now(), t);
                throw new IllegalStateException("Unable to perform handshake", t);
            }
            this.handshakeComplete = true;
        }
        this.bufferHandler.set(this.delegate, (Bytes<ByteBuffer>)in, (Bytes<ByteBuffer>)out, nc);
        this.stateMachine.action();
    }

    @Override
    public void sendHeartBeat(Bytes out, SessionDetailsProvider sessionDetails) {
        this.throwExceptionIfClosed();
        this.delegate.sendHeartBeat(out, sessionDetails);
    }

    @Override
    public void onEndOfConnection(boolean heartbeatTimeOut) {
        this.delegate.onEndOfConnection(heartbeatTimeOut);
    }

    public void close() {
        if (this.stateMachine != null) {
            this.stateMachine.close();
        }
        this.delegate.close();
    }

    @Override
    public void onReadTime(long readTimeNS, ByteBuffer inBB, int position, int limit) {
        this.throwExceptionIfClosed();
        this.delegate.onReadTime(readTimeNS, inBB, position, limit);
    }

    @Override
    public void onWriteTime(long writeTimeNS, ByteBuffer byteBuffer, int position, int limit) {
        this.throwExceptionIfClosed();
        this.delegate.onWriteTime(writeTimeNS, byteBuffer, position, limit);
    }

    @Override
    public void onReadComplete() {
        this.throwExceptionIfClosed();
        this.delegate.onReadComplete();
    }

    @Override
    public boolean hasClientClosed() {
        return this.delegate.hasClientClosed();
    }

    public void notifyClosing() {
        this.delegate.notifyClosing();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public N nc() {
        return (N)(this.delegate instanceof NetworkContextManager ? (SslNetworkContext)((NetworkContextManager)((Object)this.delegate)).nc() : null);
    }

    @Override
    public void nc(N nc) {
        this.throwExceptionIfClosed();
        if (this.delegate instanceof NetworkContextManager) {
            ((NetworkContextManager)((Object)this.delegate)).nc(nc);
        }
    }

    private void doHandshake(N nc) {
        this.stateMachine = new SslEngineStateMachine(this.bufferHandler, nc.isAcceptor());
        this.stateMachine.initialise(nc.sslContext(), nc.socketChannel().socketChannel());
    }
}

