/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.tcp.ISocketChannel;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import org.jetbrains.annotations.NotNull;

public class RemoteConnector<T extends NetworkContext<T>>
extends AbstractCloseable {
    @NotNull
    private final ThrowingFunction<T, TcpEventHandler<T>, IOException> tcpHandlerSupplier;
    private final int tcpBufferSize;
    @NotNull
    private final List<Closeable> closeables = Collections.synchronizedList(new ArrayList());

    public RemoteConnector(@NotNull ThrowingFunction<T, TcpEventHandler<T>, IOException> tcpEventHandlerFactory) {
        this.tcpBufferSize = Integer.getInteger("tcp.client.buffer.size", TcpChannelHub.TCP_BUFFER);
        this.tcpHandlerSupplier = tcpEventHandlerFactory;
    }

    private static void closeSocket(SocketChannel socketChannel) {
        net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)socketChannel);
    }

    protected boolean threadSafetyCheck() {
        return true;
    }

    public void connect(@NotNull String remoteHostPort, @NotNull EventLoop eventLoop, @NotNull T nc, long retryInterval) {
        this.throwExceptionIfClosed();
        InetSocketAddress address = TCPRegistry.lookup(remoteHostPort);
        @NotNull RCEventHandler handler = new RCEventHandler(this, remoteHostPort, nc, eventLoop, address, retryInterval);
        eventLoop.addHandler((EventHandler)handler);
    }

    protected void performClose() {
        net.openhft.chronicle.core.io.Closeable.closeQuietly(this.closeables);
    }

    SocketChannel openSocketChannel(InetSocketAddress socketAddress) throws IOException {
        SocketChannel result = SocketChannel.open(socketAddress);
        result.configureBlocking(false);
        Socket socket = result.socket();
        if (!TcpEventHandler.DISABLE_TCP_NODELAY) {
            socket.setTcpNoDelay(true);
        }
        socket.setReceiveBufferSize(this.tcpBufferSize);
        socket.setSendBufferSize(this.tcpBufferSize);
        socket.setSoTimeout(0);
        socket.setSoLinger(false, 0);
        return result;
    }

    private class RCEventHandler
    extends AbstractCloseable
    implements EventHandler,
    net.openhft.chronicle.core.io.Closeable {
        private final InetSocketAddress address;
        private final AtomicLong nextPeriod = new AtomicLong();
        private final String remoteHostPort;
        private final T nc;
        private final EventLoop eventLoop;
        private final long retryInterval;
        final /* synthetic */ RemoteConnector this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        RCEventHandler(String nc, T eventLoop, EventLoop address, InetSocketAddress retryInterval, long l2) {
            void remoteHostPort;
            this.this$0 = (RemoteConnector)l;
            this.remoteHostPort = remoteHostPort;
            this.nc = nc;
            this.eventLoop = eventLoop;
            this.address = address;
            this.retryInterval = (long)retryInterval;
        }

        @NotNull
        public HandlerPriority priority() {
            return HandlerPriority.BLOCKING;
        }

        public boolean action() throws InvalidEventHandlerException {
            TcpEventHandler eventHandler;
            SocketChannel sc;
            this.throwExceptionIfClosed();
            if (this.isClosed() || this.eventLoop.isClosed()) {
                throw new InvalidEventHandlerException();
            }
            long time = System.currentTimeMillis();
            if (time <= this.nextPeriod.get()) {
                long sleepMillis;
                if (this.priority() == HandlerPriority.BLOCKING && (sleepMillis = this.nextPeriod.get() - time) > 10L) {
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(sleepMillis - 10L));
                }
                return false;
            }
            this.nextPeriod.set(time + this.retryInterval);
            try {
                sc = this.this$0.openSocketChannel(this.address);
                if (sc == null) {
                    return false;
                }
                ISocketChannel isc = ISocketChannel.wrap((SocketChannel)sc);
                this.nc.socketChannel(isc);
                this.nc.isAcceptor(false);
                NetworkStatsListener.notifyHostPort(isc, this.nc.networkStatsListener());
                if (!this.nc.socketChannel().isOpen()) {
                    throw new InvalidEventHandlerException();
                }
                eventHandler = (TcpEventHandler)this.this$0.tcpHandlerSupplier.apply(this.nc);
            }
            catch (AlreadyConnectedException e) {
                Jvm.debug().on(((Object)((Object)this)).getClass(), (Throwable)e);
                throw new InvalidEventHandlerException();
            }
            catch (IOException | IORuntimeException e) {
                this.nextPeriod.set(System.currentTimeMillis() + this.retryInterval);
                return false;
            }
            if (this.isClosed() || this.eventLoop.isClosed() || Thread.currentThread().isInterrupted()) {
                net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)eventHandler);
            } else {
                this.eventLoop.addHandler((EventHandler)eventHandler);
                this.this$0.closeables.add(() -> RemoteConnector.closeSocket(sc));
            }
            throw new InvalidEventHandlerException();
        }

        @NotNull
        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "{remoteHostPort=" + this.remoteHostPort + ", closed=" + this.isClosed() + "}";
        }

        protected void performClose() {
        }

        public void notifyClosing() {
            this.close();
        }
    }
}

