/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ConnectionChangedNotifier;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.network.cluster.ConnectionStrategy;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.cluster.TerminationEventHandler;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Cluster<E extends HostDetails, C extends ClusterContext>
implements Marshallable,
Closeable {
    @NotNull
    public final Map<String, E> hostDetails = new ConcurrentSkipListMap<String, E>();
    private final String clusterName;
    @Nullable
    private C context;

    public Cluster(String clusterName) {
        this.clusterName = clusterName;
    }

    public String clusterName() {
        return this.clusterName;
    }

    @Nullable
    public C clusterContext() {
        return this.context;
    }

    public void clusterContext(@NotNull C clusterContext) {
        this.context = clusterContext;
        ((ClusterContext)clusterContext).clusterName(this.clusterName);
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        this.hostDetails.clear();
        if (wire.isEmpty()) {
            return;
        }
        while (!wire.isEmpty()) {
            StringBuilder sb = Wires.acquireStringBuilder();
            ValueIn valueIn = wire.readEventName(sb);
            if ("context".contentEquals(sb)) {
                this.context = (ClusterContext)valueIn.object(ClusterContext.class);
                assert (this.context != null);
                ((ClusterContext)this.context).clusterName(this.clusterName);
                continue;
            }
            valueIn.marshallable(details -> {
                E hd = this.newHostDetails();
                ((HostDetails)hd).readMarshallable(details);
                this.hostDetails.put(sb.toString(), hd);
            });
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((CharSequence)"context").typedMarshallable(this.context);
        for (Map.Entry<String, E> entry2 : this.hostDetails.entrySet()) {
            wire.writeEventName(entry2::getKey).marshallable((WriteMarshallable)entry2.getValue());
        }
    }

    @Nullable
    public E findHostDetails(int id) {
        for (HostDetails hd : this.hostDetails.values()) {
            if (hd.hostId() != id) continue;
            return (E)hd;
        }
        return null;
    }

    @Nullable
    public ConnectionStrategy findConnectionStrategy(int remoteIdentifier) {
        E hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return ((HostDetails)hostDetails).connectionStrategy();
    }

    @Nullable
    public ConnectionManager findConnectionManager(int remoteIdentifier) {
        E hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return ((HostDetails)hostDetails).connectionManager();
    }

    @Nullable
    public TerminationEventHandler findTerminationEventHandler(int remoteIdentifier) {
        E hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return ((HostDetails)hostDetails).terminationEventHandler();
    }

    @Nullable
    public ConnectionChangedNotifier findClusterNotifier(int remoteIdentifier) {
        E hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return ((HostDetails)hostDetails).clusterNotifier();
    }

    @NotNull
    protected abstract E newHostDetails();

    @NotNull
    public Collection<E> hostDetails() {
        return this.hostDetails.values();
    }

    public void close() {
        Closeable.closeQuietly(this.hostDetails());
    }

    public void install() {
        byte local;
        Set hostIds = this.hostDetails.values().stream().map(HostDetails::hostId).collect(Collectors.toSet());
        if (!hostIds.contains(local = ((ClusterContext)this.context).localIdentifier())) {
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "cluster='" + ((ClusterContext)this.context).clusterName() + "' ignored as localIdentifier=" + ((ClusterContext)this.context).localIdentifier() + " is in this cluster");
            }
            return;
        }
        if (this.context != null) {
            this.hostDetails.values().forEach(arg_0 -> this.context.accept(arg_0));
        }
    }
}

