/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster.handlers;

import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.api.session.SubHandler;
import net.openhft.chronicle.network.cluster.Cluster;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionChangedNotifier;
import net.openhft.chronicle.network.cluster.ConnectionStrategy;
import net.openhft.chronicle.network.cluster.HeartbeatEventHandler;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.cluster.TerminatorHandler;
import net.openhft.chronicle.network.cluster.handlers.CspTcpHandler;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UberHandler<T extends ClusteredNetworkContext>
extends CspTcpHandler<T>
implements Demarshallable,
WriteMarshallable {
    private final int remoteIdentifier;
    private final int localIdentifier;
    @NotNull
    private AtomicBoolean isClosing = new AtomicBoolean();
    @Nullable
    private ConnectionChangedNotifier connectionChangedNotifier;
    @NotNull
    private String clusterName;

    @UsedViaReflection
    private UberHandler(@NotNull WireIn wire) {
        this.remoteIdentifier = wire.read(() -> "remoteIdentifier").int32();
        this.localIdentifier = wire.read(() -> "localIdentifier").int32();
        WireType wireType = (WireType)wire.read(() -> "wireType").object(WireType.class);
        this.clusterName = wire.read(() -> "clusterName").text();
        this.wireType(wireType);
    }

    private UberHandler(int localIdentifier, int remoteIdentifier, @NotNull WireType wireType, @NotNull String clusterName) {
        this.localIdentifier = localIdentifier;
        this.remoteIdentifier = remoteIdentifier;
        assert (remoteIdentifier != localIdentifier) : "remoteIdentifier=" + remoteIdentifier + ", localIdentifier=" + localIdentifier;
        this.clusterName = clusterName;
        this.wireType(wireType);
    }

    private static WriteMarshallable uberHandler(WriteMarshallable m) {
        return wire -> {
            try (DocumentContext dc = wire.writingDocument(true);){
                wire.write(() -> "handler").typedMarshallable(m);
            }
        };
    }

    public int remoteIdentifier() {
        return this.remoteIdentifier;
    }

    public boolean isClosed() {
        return this.isClosing.get();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write(() -> "remoteIdentifier").int32(this.localIdentifier);
        wire.write(() -> "localIdentifier").int32(this.remoteIdentifier);
        WireType value = this.wireType();
        wire.write(() -> "wireType").object((Object)value);
        wire.write(() -> "clusterName").text(this.clusterName);
    }

    @Override
    protected void onInitialize() {
        ClusteredNetworkContext nc = (ClusteredNetworkContext)this.nc();
        nc.wireType(this.wireType());
        this.isAcceptor(nc.isAcceptor());
        assert (this.checkIdentifierEqualsHostId());
        assert (this.remoteIdentifier != this.localIdentifier) : "remoteIdentifier=" + this.remoteIdentifier + ", localIdentifier=" + this.localIdentifier;
        WireOutPublisher publisher = nc.wireOutPublisher();
        this.publisher(publisher);
        if (!nc.isValidCluster(this.clusterName)) {
            Jvm.warn().on(this.getClass(), "cluster=" + this.clusterName, (Throwable)new RuntimeException("cluster  not found, cluster=" + this.clusterName));
            return;
        }
        EventLoop eventLoop = nc.eventLoop();
        if (!eventLoop.isClosed()) {
            eventLoop.start();
            Cluster engineCluster = nc.getCluster(this.clusterName);
            if (((ClusteredNetworkContext)this.nc()).isAcceptor()) {
                this.publish(this.uberHandler());
            }
            nc.terminationEventHandler(engineCluster.findTerminationEventHandler(this.remoteIdentifier));
            if (!this.checkConnectionStrategy(engineCluster)) {
                this.publish(TerminatorHandler.terminationHandler(this.localIdentifier, this.remoteIdentifier, nc.newCid()));
                this.closeSoon();
                return;
            }
            if (!this.isClosing.get()) {
                this.notifyConnectionListeners(engineCluster);
            }
        }
    }

    private boolean checkIdentifierEqualsHostId() {
        return this.localIdentifier == ((ClusteredNetworkContext)this.nc()).getLocalHostIdentifier() || 0 == ((ClusteredNetworkContext)this.nc()).getLocalHostIdentifier();
    }

    private void notifyConnectionListeners(@NotNull Cluster cluster) {
        this.connectionChangedNotifier = cluster.findClusterNotifier(this.remoteIdentifier);
        if (this.connectionChangedNotifier != null) {
            this.connectionChangedNotifier.onConnectionChanged(true, (NetworkContext)this.nc());
        }
    }

    private boolean checkConnectionStrategy(@NotNull Cluster cluster) {
        ConnectionStrategy strategy = cluster.findConnectionStrategy(this.remoteIdentifier);
        return strategy == null || strategy.notifyConnected(this, this.localIdentifier, this.remoteIdentifier);
    }

    private WriteMarshallable uberHandler() {
        UberHandler<T> handler = new UberHandler<T>(this.localIdentifier, this.remoteIdentifier, this.wireType(), this.clusterName);
        return UberHandler.uberHandler(handler);
    }

    private void closeSoon() {
        this.isClosing.set(true);
        ScheduledExecutorService closer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("closer", Boolean.valueOf(true)));
        closer.schedule(() -> {
            closer.shutdown();
            this.close();
        }, 2L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (!this.isClosing.getAndSet(true) && this.connectionChangedNotifier != null) {
            this.connectionChangedNotifier.onConnectionChanged(false, (NetworkContext)this.nc());
        }
        ((ClusteredNetworkContext)this.nc()).acquireConnectionListener().onDisconnected(this.localIdentifier, this.remoteIdentifier(), ((ClusteredNetworkContext)this.nc()).isAcceptor());
        super.close();
    }

    @Override
    protected void onRead(@NotNull DocumentContext dc, @NotNull WireOut outWire) {
        try {
            if (this.isClosing.get()) {
                return;
            }
            this.onMessageReceivedOrWritten();
            Wire inWire = dc.wire();
            if (dc.isMetaData()) {
                if (!this.readMeta((WireIn)inWire)) {
                    return;
                }
                SubHandler handler = this.handler();
                handler.remoteIdentifier(this.remoteIdentifier);
                handler.localIdentifier(this.localIdentifier);
                try {
                    handler.onInitialize(outWire);
                }
                catch (RejectedExecutionException e) {
                    throw new IllegalStateException("EventGroup shutdown", e);
                }
                return;
            }
            SubHandler handler = this.handler();
            if (handler == null) {
                throw new IllegalStateException("handler == null, check that the Csp/Cid has been sent, failed to fully process the following YAML\n");
            }
            if (dc.isData() && !inWire.bytes().isEmpty()) {
                handler.onRead((WireIn)inWire, outWire);
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), "failed to parse:" + UberHandler.peekContents(dc), e);
        }
    }

    @Override
    protected void onBytesWritten() {
        this.onMessageReceivedOrWritten();
    }

    @Override
    protected void onWrite(@NotNull WireOut outWire) {
        SubHandler handler = this.handler();
        if (handler != null) {
            handler.onWrite(outWire);
        }
        for (WriteMarshallable w : this.writers) {
            if (this.isClosing.get() || w == null) {
                return;
            }
            w.writeMarshallable(outWire);
        }
    }

    private void onMessageReceivedOrWritten() {
        HeartbeatEventHandler heartbeatEventHandler = this.heartbeatEventHandler();
        if (heartbeatEventHandler != null) {
            heartbeatEventHandler.onMessageReceived();
        }
    }

    private static String peekContents(@NotNull DocumentContext dc) {
        try {
            return dc.wire().readingPeekYaml();
        }
        catch (RuntimeException e) {
            return "Failed to peek at contents due to: " + e.getMessage();
        }
    }

    public static class Factory
    implements BiFunction<ClusterContext, HostDetails, WriteMarshallable>,
    Demarshallable {
        @UsedViaReflection
        private Factory(@NotNull WireIn wireIn) {
        }

        public Factory() {
        }

        @Override
        @NotNull
        public WriteMarshallable apply(@NotNull ClusterContext clusterContext, @NotNull HostDetails hostdetails) {
            byte localIdentifier = clusterContext.localIdentifier();
            int remoteIdentifier = hostdetails.hostId();
            WireType wireType = clusterContext.wireType();
            String name = clusterContext.clusterName();
            return UberHandler.uberHandler(new UberHandler(localIdentifier, remoteIdentifier, wireType, name));
        }
    }
}

