/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.HeartbeatListener;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.cluster.TerminationEventHandler;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaNetworkContext<T extends VanillaNetworkContext>
implements NetworkContext<T>,
Closeable {
    private final AtomicLong cid = new AtomicLong();
    private SocketChannel socketChannel;
    private boolean isAcceptor = true;
    private HeartbeatListener heartbeatListener;
    private SessionDetailsProvider sessionDetails;
    private boolean connectionClosed;
    @Nullable
    private TerminationEventHandler terminationEventHandler;
    private long heartbeatTimeoutMs;
    private WireOutPublisher wireOutPublisher;
    private WireType wireType = WireType.TEXT;
    private Runnable socketReconnector;
    private NetworkStatsListener<? extends NetworkContext> networkStatsListener;
    private ServerThreadingStrategy serverThreadingStrategy = ServerThreadingStrategy.SINGLE_THREADED;
    private volatile boolean isClosed;

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    @NotNull
    public T socketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        return (T)this;
    }

    @Override
    public void onHandlerChanged(TcpHandler handler) {
    }

    @Override
    @NotNull
    public T isAcceptor(boolean isAcceptor) {
        this.isAcceptor = isAcceptor;
        return (T)this;
    }

    @Override
    public boolean isAcceptor() {
        return this.isAcceptor;
    }

    @Override
    public synchronized WireOutPublisher wireOutPublisher() {
        return this.wireOutPublisher;
    }

    @Override
    public void wireOutPublisher(WireOutPublisher wireOutPublisher) {
        this.wireOutPublisher = wireOutPublisher;
    }

    @Override
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    @NotNull
    public T wireType(WireType wireType) {
        this.wireType = wireType;
        return (T)this;
    }

    @Override
    public SessionDetailsProvider sessionDetails() {
        return this.sessionDetails;
    }

    @Override
    @NotNull
    public T sessionDetails(SessionDetailsProvider sessionDetails) {
        this.sessionDetails = sessionDetails;
        return (T)this;
    }

    @Override
    @Nullable
    public TerminationEventHandler terminationEventHandler() {
        return this.terminationEventHandler;
    }

    @Override
    public void terminationEventHandler(@Nullable TerminationEventHandler terminationEventHandler) {
        this.terminationEventHandler = terminationEventHandler;
    }

    @Override
    public void heartbeatTimeoutMs(long heartbeatTimeoutMs) {
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
    }

    @Override
    public long heartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    @Override
    public HeartbeatListener heartbeatListener() {
        return this.heartbeatListener;
    }

    @Override
    public void heartbeatListener(@NotNull HeartbeatListener heartbeatListener) {
        this.heartbeatListener = heartbeatListener;
    }

    @Override
    public long newCid() {
        long time = System.currentTimeMillis();
        while (true) {
            long value;
            if (time <= (value = this.cid.get())) {
                ++time;
                continue;
            }
            if (this.cid.compareAndSet(value, time)) break;
        }
        return time;
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        Closeable.closeQuietly(this.networkStatsListener);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Runnable socketReconnector() {
        return this.socketReconnector;
    }

    @Override
    @NotNull
    public T socketReconnector(Runnable socketReconnector) {
        this.socketReconnector = socketReconnector;
        return (T)this;
    }

    @Override
    public void networkStatsListener(NetworkStatsListener networkStatsListener) {
        this.networkStatsListener = networkStatsListener;
    }

    @Override
    public NetworkStatsListener<? extends NetworkContext> networkStatsListener() {
        return this.networkStatsListener;
    }

    @Override
    public ServerThreadingStrategy serverThreadingStrategy() {
        return this.serverThreadingStrategy;
    }

    @Override
    public void serverThreadingStrategy(ServerThreadingStrategy serverThreadingStrategy) {
        this.serverThreadingStrategy = serverThreadingStrategy;
    }
}

