/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.HeartbeatListener;
import net.openhft.chronicle.network.MarshallableFunction;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkLog;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TcpEventHandlerManager;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.WanSimulator;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpEventHandler
implements EventHandler,
Closeable,
TcpEventHandlerManager {
    public static final int TCP_BUFFER = TcpChannelHub.TCP_BUFFER;
    private static final Logger LOG = LoggerFactory.getLogger(TcpEventHandler.class);
    @NotNull
    private final SocketChannel sc;
    @NotNull
    private final NetworkContext nc;
    @NotNull
    private final SessionDetailsProvider sessionDetails;
    @NotNull
    private final WriteEventHandler writeEventHandler;
    @NotNull
    private final NetworkLog readLog;
    @NotNull
    private final NetworkLog writeLog;
    @NotNull
    private final Bytes<ByteBuffer> inBBB;
    @NotNull
    private final Bytes<ByteBuffer> outBBB;
    private int oneInTen;
    private volatile boolean isCleaned;
    @Nullable
    private volatile TcpHandler tcpHandler;
    private long lastTickReadTime = Time.tickTime();
    private volatile boolean closed;

    public TcpEventHandler(@NotNull NetworkContext nc) {
        this.writeEventHandler = new WriteEventHandler();
        this.sc = nc.socketChannel();
        this.nc = nc;
        try {
            this.sc.configureBlocking(false);
            this.sc.socket().setTcpNoDelay(true);
            if (TCP_BUFFER >= 65536) {
                this.sc.socket().setReceiveBufferSize(TCP_BUFFER);
                this.sc.socket().setSendBufferSize(TCP_BUFFER);
            }
        }
        catch (IOException e) {
            Jvm.warn().on(this.getClass(), (Throwable)e);
        }
        this.sessionDetails = new VanillaSessionDetails();
        try {
            this.sessionDetails.clientAddress((InetSocketAddress)this.sc.getRemoteAddress());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        this.inBBB = Bytes.elasticByteBuffer((int)(TCP_BUFFER + OS.pageSize()));
        this.outBBB = Bytes.elasticByteBuffer((int)TCP_BUFFER);
        ((ByteBuffer)this.outBBB.underlyingObject()).limit(0);
        this.readLog = new NetworkLog(this.sc, "read");
        this.writeLog = new NetworkLog(this.sc, "write");
    }

    public boolean isClosed() {
        return this.closed;
    }

    @NotNull
    public HandlerPriority priority() {
        ServerThreadingStrategy sts = this.nc.serverThreadingStrategy();
        switch (sts) {
            case SINGLE_THREADED: {
                return HandlerPriority.MEDIUM;
            }
            case CONCURRENT: {
                return HandlerPriority.CONCURRENT;
            }
            case MULTI_THREADED_BUSY_WAITING: {
                return HandlerPriority.BLOCKING;
            }
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void tcpHandler(TcpHandler tcpHandler) {
        this.nc.onHandlerChanged(tcpHandler);
        this.tcpHandler = tcpHandler;
    }

    public synchronized boolean action() throws InvalidEventHandlerException {
        HeartbeatListener heartbeatListener = this.nc.heartbeatListener();
        if (this.tcpHandler == null) {
            return false;
        }
        if (!this.sc.isOpen()) {
            this.tcpHandler.onEndOfConnection(false);
            Closeable.closeQuietly((Object)this.nc);
            throw new InvalidEventHandlerException("socket is closed");
        }
        if (this.closed) {
            Closeable.closeQuietly((Object)this.nc);
            throw new InvalidEventHandlerException();
        }
        boolean busy = false;
        if (this.oneInTen++ >= 8) {
            this.oneInTen = 0;
            try {
                busy |= this.writeEventHandler.action();
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), (Throwable)e);
            }
        }
        try {
            int read;
            ByteBuffer inBB = (ByteBuffer)this.inBBB.underlyingObject();
            int start = inBB.position();
            int n = read = inBB.remaining() > 0 ? this.sc.read(inBB) : Integer.MAX_VALUE;
            if (read > 0) {
                WanSimulator.dataRead(read);
                this.tcpHandler.onReadTime(System.nanoTime());
                this.lastTickReadTime = Time.tickTime();
                this.readLog.log(inBB, start, inBB.position());
                if (this.invokeHandler()) {
                    ++this.oneInTen;
                }
                return true;
            }
            if (read < 0) {
                this.close();
                throw new InvalidEventHandlerException("socket closed " + this.sc);
            }
            this.readLog.idle();
            if (this.nc.heartbeatTimeoutMs() == 0L) {
                return busy;
            }
            long tickTime = Time.tickTime();
            if (tickTime > this.lastTickReadTime + this.nc.heartbeatTimeoutMs()) {
                if (heartbeatListener != null) {
                    this.nc.heartbeatListener().onMissedHeartbeat();
                }
                this.closeSC();
                throw new InvalidEventHandlerException("heatbeat timeout");
            }
        }
        catch (ClosedChannelException e) {
            this.closeSC();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        catch (IOException e) {
            this.closeSC();
            this.handleIOE(e, this.tcpHandler.hasClientClosed(), this.nc.heartbeatListener());
            throw new InvalidEventHandlerException();
        }
        catch (InvalidEventHandlerException e) {
            this.closeSC();
            throw e;
        }
        catch (Exception e) {
            this.closeSC();
            Jvm.warn().on(this.getClass(), "", (Throwable)e);
            throw new InvalidEventHandlerException((Throwable)e);
        }
        return busy;
    }

    private synchronized void clean() {
        if (this.isCleaned) {
            return;
        }
        this.isCleaned = true;
        long usedDirectMemory = Jvm.usedDirectMemory();
        IOTools.clean((ByteBuffer)((ByteBuffer)this.inBBB.underlyingObject()));
        IOTools.clean((ByteBuffer)((ByteBuffer)this.outBBB.underlyingObject()));
        if (usedDirectMemory == Jvm.usedDirectMemory()) {
            Jvm.warn().on(this.getClass(), "nothing cleaned");
        }
    }

    boolean invokeHandler() throws IOException {
        long lastInBBBReadPosition;
        boolean busy = false;
        int position = ((ByteBuffer)this.inBBB.underlyingObject()).position();
        this.inBBB.readLimit((long)position);
        this.outBBB.writePosition((long)((ByteBuffer)this.outBBB.underlyingObject()).limit());
        do {
            lastInBBBReadPosition = this.inBBB.readPosition();
            this.tcpHandler.process(this.inBBB, this.outBBB, this.nc);
            if (this.outBBB.writePosition() <= (long)((ByteBuffer)this.outBBB.underlyingObject()).limit() && this.outBBB.writePosition() < 4L) continue;
            ((ByteBuffer)this.outBBB.underlyingObject()).limit(Maths.toInt32((long)this.outBBB.writePosition()));
            busy |= this.tryWrite();
            break;
        } while (lastInBBBReadPosition != this.inBBB.readPosition());
        if (this.inBBB.readRemaining() == 0L) {
            this.inBBB.clear();
            ByteBuffer inBB = (ByteBuffer)this.inBBB.underlyingObject();
            inBB.clear();
        } else if (this.inBBB.readPosition() > 0L) {
            ByteBuffer inBB = (ByteBuffer)this.inBBB.underlyingObject();
            inBB.position((int)this.inBBB.readPosition());
            inBB.limit((int)this.inBBB.readLimit());
            inBB.compact();
            this.inBBB.readPosition(0L);
            this.inBBB.readLimit((long)inBB.remaining());
            busy = true;
        } else if (this.inBBB.readPosition() > 0L) {
            System.out.println("pos " + this.inBBB.readPosition());
        }
        return busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIOE(@NotNull IOException e, boolean clientIntentionallyClosed, @Nullable HeartbeatListener heartbeatListener) {
        try {
            if (clientIntentionallyClosed) {
                return;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("Connection reset by peer")) {
                LOG.trace("", (Object)e.getMessage());
            } else if (e.getMessage() != null && e.getMessage().startsWith("An existing connection was forcibly closed")) {
                Jvm.debug().on(this.getClass(), e.getMessage());
            } else if (!(e instanceof ClosedByInterruptException)) {
                Jvm.warn().on(this.getClass(), "", (Throwable)e);
            }
            if (heartbeatListener != null) {
                heartbeatListener.onMissedHeartbeat();
            }
        }
        finally {
            this.closeSC();
        }
    }

    public void close() {
        this.closed = true;
        this.closeSC();
        this.clean();
    }

    private void closeSC() {
        Closeable.closeQuietly((Object)this.nc.networkStatsListener());
        Closeable.closeQuietly((Object)this.tcpHandler);
        Closeable.closeQuietly((Object)this.sc);
        Closeable.closeQuietly((Object)this.nc);
    }

    private boolean tryWrite() throws IOException {
        if (((ByteBuffer)this.outBBB.underlyingObject()).remaining() <= 0) {
            return false;
        }
        int start = ((ByteBuffer)this.outBBB.underlyingObject()).position();
        long writeTickTime = Time.tickTime();
        long writeTime = System.nanoTime();
        assert (!this.sc.isBlocking());
        int wrote = this.sc.write((ByteBuffer)this.outBBB.underlyingObject());
        this.tcpHandler.onWriteTime(writeTime);
        this.writeLog.log((ByteBuffer)this.outBBB.underlyingObject(), start, ((ByteBuffer)this.outBBB.underlyingObject()).position());
        if (wrote < 0) {
            this.closeSC();
        } else if (wrote > 0) {
            this.lastTickReadTime = writeTickTime;
            ((ByteBuffer)this.outBBB.underlyingObject()).compact().flip();
            this.outBBB.writePosition((long)((ByteBuffer)this.outBBB.underlyingObject()).limit());
            return true;
        }
        return false;
    }

    private class WriteEventHandler
    implements EventHandler {
        private WriteEventHandler() {
        }

        public boolean action() throws InvalidEventHandlerException {
            boolean busy;
            block6: {
                if (!TcpEventHandler.this.sc.isOpen()) {
                    throw new InvalidEventHandlerException("socket is closed");
                }
                busy = false;
                try {
                    int remaining = ((ByteBuffer)TcpEventHandler.this.outBBB.underlyingObject()).remaining();
                    boolean bl = busy = remaining > 0;
                    if (busy) {
                        TcpEventHandler.this.tryWrite();
                    }
                    if (((ByteBuffer)TcpEventHandler.this.outBBB.underlyingObject()).remaining() == remaining && !(busy |= TcpEventHandler.this.invokeHandler())) {
                        busy = TcpEventHandler.this.tryWrite();
                    }
                }
                catch (ClosedChannelException cce) {
                    TcpEventHandler.this.closeSC();
                }
                catch (IOException e) {
                    if (TcpEventHandler.this.closed) break block6;
                    TcpEventHandler.this.handleIOE(e, TcpEventHandler.this.tcpHandler.hasClientClosed(), TcpEventHandler.this.nc.heartbeatListener());
                }
            }
            return busy;
        }
    }

    public static class Factory
    implements MarshallableFunction<NetworkContext, TcpEventHandler> {
        @Override
        @NotNull
        public TcpEventHandler apply(@NotNull NetworkContext nc) {
            return new TcpEventHandler(nc);
        }
    }
}

