/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteConnector
implements Closeable {
    private static final int BUFFER_SIZE = 0x800000;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteConnector.class);
    @NotNull
    private final ThrowingFunction<NetworkContext, TcpEventHandler, IOException> tcpHandlerSupplier;
    private final Integer tcpBufferSize;
    private volatile boolean closed;
    private volatile List<Closeable> closeables = new ArrayList<Closeable>();

    public RemoteConnector(@NotNull ThrowingFunction<NetworkContext, TcpEventHandler, IOException> tcpEventHandlerFactory) {
        this.tcpBufferSize = Integer.getInteger("tcp.client.buffer.size", 0x800000);
        this.tcpHandlerSupplier = tcpEventHandlerFactory;
    }

    private static void closeSocket(SocketChannel socketChannel) {
        Closeable.closeQuietly((Object)socketChannel);
    }

    public void connect(String remoteHostPort, EventLoop eventLoop, @NotNull NetworkContext nc, long retryInterval) {
        InetSocketAddress address = TCPRegistry.lookup(remoteHostPort);
        RCEventHandler handler = new RCEventHandler(remoteHostPort, nc, eventLoop, address, retryInterval);
        eventLoop.addHandler((EventHandler)handler);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        List<Closeable> closeables = this.closeables;
        this.closeables = null;
        closeables.forEach(Closeable::closeQuietly);
    }

    private SocketChannel openSocketChannel(InetSocketAddress socketAddress) throws IOException {
        SocketChannel result = SocketChannel.open(socketAddress);
        result.configureBlocking(false);
        Socket socket = result.socket();
        socket.setTcpNoDelay(true);
        socket.setReceiveBufferSize(this.tcpBufferSize);
        socket.setSendBufferSize(this.tcpBufferSize);
        socket.setSoTimeout(0);
        socket.setSoLinger(false, 0);
        return result;
    }

    private class RCEventHandler
    implements EventHandler,
    Closeable {
        private final InetSocketAddress address;
        private final AtomicLong nextPeriod = new AtomicLong();
        private final String remoteHostPort;
        private final NetworkContext nc;
        private final EventLoop eventLoop;
        private final long retryInterval;
        private volatile boolean closed;

        RCEventHandler(String remoteHostPort, NetworkContext nc, EventLoop eventLoop, InetSocketAddress address, long retryInterval) {
            this.remoteHostPort = remoteHostPort;
            this.nc = nc;
            this.eventLoop = eventLoop;
            this.address = address;
            this.retryInterval = retryInterval;
        }

        public boolean action() throws InvalidEventHandlerException, InterruptedException {
            TcpEventHandler eventHandler;
            SocketChannel sc;
            if (this.closed) {
                throw new InvalidEventHandlerException();
            }
            long time = System.currentTimeMillis();
            if (time <= this.nextPeriod.get()) {
                return false;
            }
            this.nextPeriod.set(time + this.retryInterval);
            try {
                sc = RemoteConnector.this.openSocketChannel(this.address);
                if (sc == null) {
                    return false;
                }
                this.nc.socketChannel(sc);
                this.nc.isAcceptor(false);
                eventHandler = (TcpEventHandler)RemoteConnector.this.tcpHandlerSupplier.apply((Object)this.nc);
            }
            catch (AlreadyConnectedException e) {
                Jvm.debug().on(this.getClass(), (Throwable)e);
                throw new InvalidEventHandlerException();
            }
            catch (IOException e) {
                this.nextPeriod.set(System.currentTimeMillis() + this.retryInterval);
                return false;
            }
            this.eventLoop.addHandler((EventHandler)eventHandler);
            List closeables = RemoteConnector.this.closeables;
            if (closeables == null) {
                Closeable.closeQuietly((Object)eventHandler);
            } else {
                closeables.add(() -> RemoteConnector.closeSocket(sc));
            }
            throw new InvalidEventHandlerException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "remoteHostPort=" + this.remoteHostPort + ", closed=" + this.closed + "}";
        }

        public void close() {
            this.closed = true;
        }

        public void notifyClosing() {
            this.closed = true;
        }
    }
}

