/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import net.openhft.chronicle.core.Jvm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServerThreadingStrategy {
    SINGLE_THREADED("uses a single threaded prioritised event loop, where the reads take priority over the asynchronous writes"),
    MULTI_THREADED_BUSY_WAITING("each client connection is devoted to its own busy waiting thread, This is ideal when you have a small number of client connections on a server with a large number of free cores");

    private static final Logger LOG;
    private static ServerThreadingStrategy value;
    private final String description;

    private ServerThreadingStrategy(String description) {
        this.description = description;
    }

    static ServerThreadingStrategy serverThreadingStrategy() {
        return value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        LOG = LoggerFactory.getLogger(ServerThreadingStrategy.class);
        value = SINGLE_THREADED;
        String serverThreadingStrategy = System.getProperty("ServerThreadingStrategy");
        if (serverThreadingStrategy != null) {
            try {
                value = Enum.valueOf(ServerThreadingStrategy.class, serverThreadingStrategy);
            }
            catch (Exception e) {
                Jvm.warn().on(ServerThreadingStrategy.class, "unable to apply -DServerThreadingStrategy=" + serverThreadingStrategy + ", so defaulting to " + (Object)((Object)value), (Throwable)e);
            }
        }
    }
}

