/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.connection.WireOutConsumer;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaWireOutPublisher
implements WireOutPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaWireOutPublisher.class);
    private final Bytes<ByteBuffer> bytes;
    private Wire wrapperWire;
    private volatile boolean closed = false;
    private Wire wire;
    private List<WireOutConsumer> consumers = new CopyOnWriteArrayList<WireOutConsumer>();
    private int consumerIndex;

    public VanillaWireOutPublisher(WireType wireType) {
        this.bytes = Bytes.elasticByteBuffer((int)0x400000);
        this.wrapperWire = (Wire)WireType.BINARY.apply(this.bytes);
        this.wire = (Wire)wireType.apply(this.bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void applyAction(@NotNull Bytes bytes) {
        if (this.bytes.readRemaining() <= 0L) return;
        Object object = this.lock();
        synchronized (object) {
            while (this.bytes.readRemaining() > 0L && bytes.writeRemaining() > (long)TcpEventHandler.TCP_BUFFER) {
                long readPosition = this.bytes.readPosition();
                ReadDocumentContext dc = (ReadDocumentContext)this.wrapperWire.readingDocument();
                Throwable throwable = null;
                try {
                    if (!dc.isPresent() || bytes.writeRemaining() < this.bytes.readRemaining()) {
                        dc.closeReadPosition(readPosition);
                        return;
                    }
                    if (YamlLogging.showServerWrites()) {
                        LOG.info("Server sends:" + Wires.fromSizePrefixedBlobs(this.bytes));
                    }
                    bytes.write(this.bytes);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
            this.bytes.compact();
            return;
        }
    }

    @Override
    public void applyAction(@NotNull WireOut outWire) {
        this.applyAction(outWire.bytes());
        for (int y = 1; y < 1000; ++y) {
            long pos = outWire.bytes().writePosition();
            for (int i = 0; i < this.consumers.size(); ++i) {
                if (outWire.bytes().writePosition() > (long)TcpEventHandler.TCP_BUFFER) {
                    return;
                }
                if (this.isClosed()) {
                    return;
                }
                WireOutConsumer c = this.next();
                try {
                    c.accept(outWire);
                    continue;
                }
                catch (InvalidEventHandlerException e) {
                    this.consumers.remove(c);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                    throw Jvm.rethrow((Throwable)e);
                }
            }
            if (pos != outWire.bytes().writePosition()) continue;
            return;
        }
        LOG.error("", (Throwable)new IllegalStateException("loop when too long"));
    }

    @Override
    public void addWireConsumer(WireOutConsumer wireOutConsumer) {
        this.consumers.add(wireOutConsumer);
    }

    @Override
    public boolean removeBytesConsumer(WireOutConsumer wireOutConsumer) {
        return this.consumers.remove(wireOutConsumer);
    }

    private WireOutConsumer next() {
        if (this.consumerIndex >= this.consumers.size()) {
            this.consumerIndex = 0;
        }
        return this.consumers.get(this.consumerIndex++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, WriteMarshallable event) {
        if (this.closed) {
            LOG.debug("message ignored as closed");
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.wrapperWire.writeDocument(false, d -> {
                assert (this.wire.startUse());
                try {
                    long start = this.wire.bytes().writePosition();
                    event.writeMarshallable((WireOut)this.wire);
                    if (YamlLogging.showServerWrites()) {
                        LOG.info("Server is about to send:" + Wires.fromSizePrefixedBlobs((Bytes)this.wire.bytes(), (long)start, (long)(this.wire.bytes().writePosition() - start)));
                    }
                }
                finally {
                    assert (this.wire.endUse());
                }
            });
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private Object lock() {
        return this.bytes;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.clear();
    }

    @Override
    public boolean canTakeMoreData() {
        Object object = this.lock();
        synchronized (object) {
            boolean bl;
            assert (this.wrapperWire.startUse());
            try {
                boolean bl2 = bl = this.wrapperWire.bytes().writePosition() < 0x200000L;
            }
            catch (Throwable throwable) {
                assert (this.wrapperWire.endUse());
                throw throwable;
            }
            assert (this.wrapperWire.endUse());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wireType(@NotNull WireType wireType) {
        if (WireType.valueOf((Wire)this.wire) == wireType) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.wire = (Wire)wireType.apply(this.bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock();
        synchronized (object) {
            this.wrapperWire.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock();
        synchronized (object) {
            return this.bytes.isEmpty();
        }
    }

    public String toString() {
        return "VanillaWireOutPublisher{, closed=" + this.closed + ", " + this.wire.getClass().getSimpleName() + "=" + this.bytes + '}';
    }
}

