/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.annotation.Nullable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkContextManager;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WireTcpHandler<T extends NetworkContext>
implements TcpHandler,
NetworkContextManager<T> {
    private static final int SIZE_OF_SIZE = 4;
    private static final Logger LOG = LoggerFactory.getLogger(WireTcpHandler.class);
    @NotNull
    protected Wire outWire;
    @NotNull
    private Wire inWire;
    private boolean recreateWire;
    @Nullable
    private WireType wireType;
    private WireOutPublisher publisher;
    private T nc;
    private volatile boolean closed;
    private boolean isAcceptor;

    private static void logYaml(WireOut outWire) {
        if (YamlLogging.showServerWrites()) {
            try {
                LOG.info("\nServer Sends:\n" + Wires.fromSizePrefixedBlobs((Bytes)outWire.bytes()));
            }
            catch (Exception e) {
                LOG.info("\nServer Sends ( corrupted ) :\n" + outWire.bytes().toDebugString());
            }
        }
    }

    public boolean isAcceptor() {
        return this.isAcceptor;
    }

    public void wireType(@NotNull WireType wireType) {
        this.wireType = wireType;
        if (this.publisher != null) {
            this.publisher.wireType(wireType);
        }
    }

    public WireOutPublisher publisher() {
        return this.publisher;
    }

    public void publisher(WireOutPublisher publisher) {
        this.publisher = publisher;
        if (this.wireType() != null) {
            publisher.wireType(this.wireType());
        }
    }

    public void isAcceptor(boolean isAcceptor) {
        this.isAcceptor = isAcceptor;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out) {
        if (this.closed) {
            return;
        }
        WireType wireType = this.wireType();
        this.checkWires(in, out, wireType == null ? WireType.TEXT : wireType);
        if (this.publisher != null && out.writePosition() < (long)TcpEventHandler.TCP_BUFFER) {
            this.publisher.applyAction((WireOut)this.outWire);
        }
        if (in.readRemaining() >= 4L) {
            this.onRead0();
        }
        if (out.writePosition() < (long)TcpEventHandler.TCP_BUFFER) {
            this.onWrite((WireOut)this.outWire);
        }
    }

    @Override
    public void onEndOfConnection(boolean heartbeatTimeOut) {
        if (this.publisher != null) {
            this.publisher.close();
        }
    }

    protected void onWrite(@NotNull WireOut out) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRead0() {
        assert (this.inWire.startUse());
        try {
            while (!this.inWire.bytes().isEmpty()) {
                long start = this.inWire.bytes().readPosition();
                DocumentContext dc = this.inWire.readingDocument();
                Throwable throwable = null;
                try {
                    if (!dc.isPresent()) {
                        return;
                    }
                    try {
                        this.logYaml(start);
                        this.onRead(dc, (WireOut)this.outWire);
                    }
                    catch (Exception e) {
                        LOG.error("inWire=" + this.inWire.getClass(), (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
            return;
        }
        finally {
            assert (this.inWire.endUse());
        }
    }

    private void logYaml(long start) {
        if (YamlLogging.showServerReads() && !this.inWire.bytes().isEmpty()) {
            String s = Wires.fromSizePrefixedBlobs((Bytes)this.inWire.bytes(), (long)start, (long)this.inWire.bytes().readLimit());
            LOG.info("handler=" + this.getClass().getSimpleName() + ", read:\n" + s);
        }
    }

    protected void checkWires(Bytes in, Bytes out, @NotNull WireType wireType) {
        boolean replace;
        if (this.recreateWire) {
            this.recreateWire = false;
            this.inWire = (Wire)wireType.apply((Object)in);
            this.outWire = (Wire)wireType.apply((Object)out);
            return;
        }
        if (this.inWire == null) {
            this.inWire = (Wire)wireType.apply((Object)in);
            this.recreateWire = false;
        }
        assert (this.inWire.startUse());
        if (this.inWire.bytes() != in) {
            this.inWire = (Wire)wireType.apply((Object)in);
            this.recreateWire = false;
        }
        assert (this.inWire.endUse());
        boolean bl = replace = this.outWire == null;
        if (!replace) {
            assert (this.outWire.startUse());
            boolean bl2 = replace = this.outWire.bytes() != out;
            assert (this.outWire.endUse());
        }
        if (replace) {
            this.outWire = (Wire)wireType.apply((Object)out);
            this.recreateWire = false;
        }
    }

    public WireType wireType() {
        return this.wireType;
    }

    protected abstract void onRead(@NotNull DocumentContext var1, @NotNull WireOut var2);

    protected void writeData(@NotNull Bytes inBytes, @NotNull WriteMarshallable c) {
        this.outWire.writeDocument(false, out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable((WireOut)this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                if (LOG.isInfoEnabled()) {
                    LOG.info("While reading " + inBytes.toDebugString(), (Object)(" processing wire " + c), (Object)t);
                }
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName(() -> "exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        });
        WireTcpHandler.logYaml((WireOut)this.outWire);
    }

    protected void writeData(boolean isNotComplete, @NotNull Bytes inBytes, @NotNull WriteMarshallable c) {
        WriteMarshallable marshallable = out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable((WireOut)this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                if (LOG.isInfoEnabled()) {
                    LOG.info("While reading " + inBytes.toDebugString(), (Object)(" processing wire " + c), (Object)t);
                }
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName(() -> "exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        };
        if (isNotComplete) {
            this.outWire.writeNotCompleteDocument(false, marshallable);
        } else {
            this.outWire.writeDocument(false, marshallable);
        }
        WireTcpHandler.logYaml((WireOut)this.outWire);
    }

    @Override
    public final void nc(T nc) {
        this.nc = nc;
        this.onInitialize();
    }

    @Override
    public T nc() {
        return this.nc;
    }

    protected abstract void onInitialize();

    @Override
    public void close() {
        this.closed = true;
        this.nc.connectionClosed(true);
    }

    protected void publish(WriteMarshallable w) {
        this.publisher.put("", w);
    }
}

