/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import net.openhft.chronicle.core.annotation.Nullable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ConnectionChangedNotifier;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.network.cluster.ConnectionStrategy;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.cluster.TerminationEventHandler;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public abstract class Cluster<E extends HostDetails, C extends ClusterContext>
implements Marshallable,
Closeable {
    private final Map<String, E> hostDetails = new ConcurrentSkipListMap<String, E>();
    private final String clusterName;
    private C clusterContext;

    public Cluster(String clusterName) {
        this.clusterName = clusterName;
    }

    protected C clusterContext() {
        return this.clusterContext;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        this.hostDetails.clear();
        StringBuilder hostDescription = new StringBuilder();
        if (!wire.hasMore()) {
            return;
        }
        ValueIn valueIn = wire.readEventName(hostDescription);
        if ("context".contentEquals(hostDescription)) {
            this.clusterContext = (ClusterContext)valueIn.typedMarshallable();
            ((ClusterContext)this.clusterContext).clusterName(this.clusterName);
            if (!wire.hasMore()) {
                return;
            }
            valueIn = wire.readEventName(hostDescription);
        }
        while (true) {
            valueIn.marshallable(details -> {
                E hd = this.newHostDetails();
                ((HostDetails)hd).readMarshallable(details);
                this.hostDetails.put(hostDescription.toString(), hd);
            });
            if (!wire.hasMore()) break;
            valueIn = wire.readEventName(hostDescription);
        }
    }

    @Nullable
    private HostDetails findHostDetails(int remoteIdentifier) {
        for (HostDetails hd : this.hostDetails.values()) {
            if (hd.hostId() != remoteIdentifier) continue;
            return hd;
        }
        return null;
    }

    public <H extends HostDetails, C extends ClusterContext> ConnectionStrategy findConnectionStrategy(int remoteIdentifier) {
        HostDetails hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return hostDetails.connectionStrategy();
    }

    public ConnectionManager findConnectionManager(int remoteIdentifier) {
        HostDetails hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return hostDetails.connectionManager();
    }

    public TerminationEventHandler findTerminationEventHandler(int remoteIdentifier) {
        HostDetails hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return hostDetails.terminationEventHandler();
    }

    public ConnectionChangedNotifier findClusterNotifier(int remoteIdentifier) {
        HostDetails hostDetails = this.findHostDetails(remoteIdentifier);
        if (hostDetails == null) {
            return null;
        }
        return hostDetails.clusterNotifier();
    }

    protected abstract E newHostDetails();

    public void writeMarshallable(@NotNull WireOut wire) {
        for (Map.Entry<String, E> entry2 : this.hostDetails.entrySet()) {
            wire.writeEventName(entry2::getKey).marshallable((WriteMarshallable)entry2.getValue());
        }
    }

    @NotNull
    public Collection<E> hostDetails() {
        return this.hostDetails.values();
    }

    public void close() {
        this.hostDetails().forEach(Closeable::closeQuietly);
    }

    public void install() {
        if (this.clusterContext != null && this.hostDetails != null && this.hostDetails.values() != null) {
            this.hostDetails.values().forEach(arg_0 -> this.clusterContext.accept(arg_0));
        }
    }
}

