/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.HeartbeatListener;
import net.openhft.chronicle.network.MarshallableFunction;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkLog;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TcpEventHandlerManager;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.WanSimulator;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpEventHandler
implements EventHandler,
Closeable,
TcpEventHandlerManager {
    private static final int CAPACITY = Integer.getInteger("TcpEventHandler.capacity", 0x200000);
    static final int TCP_BUFFER = Integer.getInteger("TcpEventHandler.tcpBufferSize", Math.max(65536, CAPACITY / 8));
    private static final Logger LOG = LoggerFactory.getLogger(TcpEventHandler.class);
    @NotNull
    private final SocketChannel sc;
    private final NetworkContext nc;
    private final SessionDetailsProvider sessionDetails;
    @NotNull
    private final WriteEventHandler writeEventHandler;
    @NotNull
    private final NetworkLog readLog;
    @NotNull
    private final NetworkLog writeLog;
    @NotNull
    private final ByteBuffer inBB = ByteBuffer.allocateDirect(CAPACITY);
    @NotNull
    private final Bytes inBBB;
    @NotNull
    private final ByteBuffer outBB = ByteBuffer.allocateDirect(CAPACITY);
    @NotNull
    private final Bytes outBBB;
    private int oneInTen;
    private volatile boolean isCleaned;
    @Nullable
    private volatile TcpHandler tcpHandler;
    private long lastTickReadTime = Time.tickTime();
    private volatile boolean closed;

    public TcpEventHandler(@NotNull NetworkContext nc) {
        boolean unchecked = nc.isUnchecked();
        this.writeEventHandler = new WriteEventHandler();
        this.sc = nc.socketChannel();
        this.nc = nc;
        try {
            this.sc.configureBlocking(false);
            this.sc.socket().setTcpNoDelay(true);
            this.sc.socket().setReceiveBufferSize(TCP_BUFFER);
            this.sc.socket().setSendBufferSize(TCP_BUFFER);
        }
        catch (IOException e) {
            LOG.info("", (Throwable)e);
        }
        this.sessionDetails = new VanillaSessionDetails();
        try {
            this.sessionDetails.clientAddress((InetSocketAddress)this.sc.getRemoteAddress());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        this.inBBB = Bytes.wrapForRead((ByteBuffer)this.inBB.slice()).unchecked(unchecked);
        this.outBBB = Bytes.wrapForWrite((ByteBuffer)this.outBB.slice()).unchecked(unchecked);
        this.outBB.limit(0);
        this.readLog = new NetworkLog(this.sc, "read");
        this.writeLog = new NetworkLog(this.sc, "write");
    }

    @NotNull
    public HandlerPriority priority() {
        switch (ServerThreadingStrategy.serverThreadingStrategy()) {
            case SINGLE_THREADED: {
                return HandlerPriority.HIGH;
            }
            case MULTI_THREADED_BUSY_WAITING: {
                return HandlerPriority.BLOCKING;
            }
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void tcpHandler(TcpHandler tcpHandler) {
        this.tcpHandler = tcpHandler;
    }

    public synchronized boolean action() throws InvalidEventHandlerException {
        HeartbeatListener heartbeatListener = this.nc.heartbeatListener();
        if (this.tcpHandler == null) {
            return false;
        }
        if (!this.sc.isOpen()) {
            this.tcpHandler.onEndOfConnection(false);
            throw new InvalidEventHandlerException();
        }
        if (this.closed) {
            throw new InvalidEventHandlerException();
        }
        boolean busy = false;
        if (this.oneInTen++ >= 8) {
            this.oneInTen = 0;
            try {
                busy |= this.writeEventHandler.action();
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        try {
            int read;
            int start = this.inBB.position();
            int n = read = this.inBB.remaining() > 0 ? this.sc.read(this.inBB) : Integer.MAX_VALUE;
            if (read > 0) {
                WanSimulator.dataRead(read);
                this.tcpHandler.onReadTime(System.nanoTime());
                this.lastTickReadTime = Time.tickTime();
                this.readLog.log(this.inBB, start, this.inBB.position());
                return busy |= this.invokeHandler();
            }
            if (read < 0) {
                this.closeSC();
                throw new InvalidEventHandlerException();
            }
            this.readLog.idle();
            if (this.nc.heartbeatTimeoutMs() == 0L) {
                return busy;
            }
            long tickTime = Time.tickTime();
            if (tickTime > this.lastTickReadTime + this.nc.heartbeatTimeoutMs()) {
                if (heartbeatListener != null) {
                    this.nc.heartbeatListener().onMissedHeartbeat();
                }
                this.closeSC();
                throw new InvalidEventHandlerException();
            }
        }
        catch (ClosedChannelException e) {
            this.closeSC();
            throw new InvalidEventHandlerException();
        }
        catch (IOException e) {
            this.handleIOE(e, this.tcpHandler.hasClientClosed(), this.nc.heartbeatListener());
            throw new InvalidEventHandlerException();
        }
        catch (InvalidEventHandlerException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
        return busy;
    }

    private synchronized void clean() {
        if (this.isCleaned) {
            return;
        }
        this.isCleaned = true;
        long usedDirectMemory = Jvm.usedDirectMemory();
        IOTools.clean((ByteBuffer)this.inBB);
        IOTools.clean((ByteBuffer)this.outBB);
        if (usedDirectMemory == Jvm.usedDirectMemory()) {
            LOG.error("nothing cleaned");
        }
    }

    boolean invokeHandler() throws IOException {
        long lastInBBBReadPosition;
        boolean busy = false;
        this.inBBB.readLimit((long)this.inBB.position());
        this.outBBB.writePosition((long)this.outBB.limit());
        do {
            lastInBBBReadPosition = this.inBBB.readPosition();
            this.tcpHandler.process(this.inBBB, this.outBBB);
            if (this.outBBB.writePosition() <= (long)this.outBB.limit() && this.outBBB.writePosition() < 4L) continue;
            this.outBB.limit(Maths.toInt32((long)this.outBBB.writePosition()));
            busy |= this.tryWrite();
            break;
        } while (lastInBBBReadPosition != this.inBBB.readPosition());
        if (this.inBBB.readPosition() > 0L) {
            this.inBB.position((int)this.inBBB.readPosition());
            this.inBB.limit((int)this.inBBB.readLimit());
            this.inBB.compact();
            this.inBBB.readPosition(0L);
            busy = true;
        }
        return busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIOE(@NotNull IOException e, boolean clientIntentionallyClosed, @Nullable HeartbeatListener heartbeatListener) {
        try {
            if (clientIntentionallyClosed) {
                return;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("Connection reset by peer")) {
                LOG.trace("", (Object)e.getMessage());
            } else if (e.getMessage() != null && e.getMessage().startsWith("An existing connection was forcibly closed")) {
                LOG.warn(e.getMessage());
            } else if (!(e instanceof ClosedByInterruptException)) {
                LOG.error("", (Throwable)e);
            }
            if (heartbeatListener != null) {
                heartbeatListener.onMissedHeartbeat();
            }
        }
        finally {
            this.closeSC();
        }
    }

    public void close() {
        this.closed = true;
        this.closeSC();
        this.clean();
    }

    private void closeSC() {
        try {
            this.tcpHandler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean tryWrite() throws IOException {
        if (this.outBB.remaining() <= 0) {
            return false;
        }
        int start = this.outBB.position();
        long writeTickTime = Time.tickTime();
        long writeTime = System.nanoTime();
        assert (!this.sc.isBlocking());
        int wrote = this.sc.write(this.outBB);
        this.tcpHandler.onWriteTime(writeTime);
        this.writeLog.log(this.outBB, start, this.outBB.position());
        if (wrote < 0) {
            this.closeSC();
        } else if (wrote > 0) {
            this.lastTickReadTime = writeTickTime;
            this.outBB.compact().flip();
            this.outBBB.writeLimit((long)this.outBB.capacity());
            this.outBBB.writePosition((long)this.outBB.limit());
            return true;
        }
        return false;
    }

    private class WriteEventHandler
    implements EventHandler {
        private WriteEventHandler() {
        }

        public boolean action() throws InvalidEventHandlerException {
            boolean busy;
            block6: {
                if (!TcpEventHandler.this.sc.isOpen()) {
                    throw new InvalidEventHandlerException();
                }
                busy = false;
                try {
                    int remaining = TcpEventHandler.this.outBB.remaining();
                    boolean bl = busy = remaining > 0;
                    if (busy) {
                        TcpEventHandler.this.tryWrite();
                    }
                    if (TcpEventHandler.this.outBB.remaining() == remaining && !(busy |= TcpEventHandler.this.invokeHandler())) {
                        busy = TcpEventHandler.this.tryWrite();
                    }
                }
                catch (ClosedChannelException cce) {
                    TcpEventHandler.this.closeSC();
                }
                catch (IOException e) {
                    if (TcpEventHandler.this.closed) break block6;
                    TcpEventHandler.this.handleIOE(e, TcpEventHandler.this.tcpHandler.hasClientClosed(), TcpEventHandler.this.nc.heartbeatListener());
                }
            }
            return busy;
        }
    }

    public static class Factory
    implements MarshallableFunction<NetworkContext, TcpEventHandler> {
        private Factory(WireIn wireIn) {
            System.out.println(wireIn);
        }

        public Factory() {
        }

        @Override
        public TcpEventHandler apply(NetworkContext nc) {
            return new TcpEventHandler(nc);
        }
    }
}

