/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.cluster.ClusterNotifier;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.network.cluster.ConnectionStrategy;
import net.openhft.chronicle.network.cluster.HostConnector;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.cluster.handlers.UberHandler;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireParser;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public abstract class ClusterContext
implements Demarshallable,
WriteMarshallable,
Consumer<HostDetails> {
    private ConnectionStrategy connectionStrategy;
    private WireType wireType;
    private UberHandler.Factory handlerFactory;
    private Function<WireType, WireOutPublisher> wireOutPublisherFactory;
    private Function<ClusterContext, NetworkContext> networkContextFactory;
    private Supplier<ConnectionManager> connectionEventHandler;
    private long heartbeatTimeoutMs = 40000L;
    private long heartbeatIntervalMs = 20000L;
    private Marshallable config;
    private String clusterName;
    private EventLoop eventLoop;
    private Function<ClusterContext, WriteMarshallable> heartbeatFactory;
    private byte localIdentifier;
    private Function<ClusterContext, NetworkStatsListener> networkStatsListenerFactory;
    private ServerThreadingStrategy serverThreadingStrategy;

    @UsedViaReflection
    protected ClusterContext(@NotNull WireIn wire) throws IORuntimeException {
        this.defaults();
        while (wire.bytes().readRemaining() > 0L) {
            this.wireParser().parseOne(wire);
        }
    }

    protected ClusterContext() {
        this.defaults();
    }

    public Function<ClusterContext, NetworkStatsListener> networkStatsListenerFactory() {
        return this.networkStatsListenerFactory;
    }

    @NotNull
    public ClusterContext networkStatsListenerFactory(Function<ClusterContext, NetworkStatsListener> networkStatsListenerFactory) {
        this.networkStatsListenerFactory = networkStatsListenerFactory;
        return this;
    }

    public long heartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    @NotNull
    public abstract ThrowingFunction<NetworkContext, TcpEventHandler, IOException> tcpEventHandlerFactory();

    @NotNull
    protected WireParser wireParser() {
        VanillaWireParser parser = new VanillaWireParser((s, v) -> {}, WireParser.SKIP_READABLE_BYTES);
        parser.register(() -> "wireType", (s, v) -> v.text((Object)this, (o, x) -> this.wireType(WireType.valueOf((String)x))));
        parser.register(() -> "handlerFactory", (s, v) -> this.handlerFactory((UberHandler.Factory)v.typedMarshallable()));
        parser.register(() -> "heartbeatTimeoutMs", (s, v) -> this.heartbeatTimeoutMs(v.int64()));
        parser.register(() -> "heartbeatIntervalMs", (s, v) -> this.heartbeatIntervalMs(v.int64()));
        parser.register(() -> "wireOutPublisherFactory", (s, v) -> this.wireOutPublisherFactory((Function)v.typedMarshallable()));
        parser.register(() -> "networkContextFactory", (s, v) -> this.networkContextFactory((Function)v.typedMarshallable()));
        parser.register(() -> "connectionStrategy", (s, v) -> this.connectionStrategy((ConnectionStrategy)v.typedMarshallable()));
        parser.register(() -> "connectionEventHandler", (s, v) -> this.connectionEventHandler((Supplier)v.typedMarshallable()));
        parser.register(() -> "heartbeatFactory", (s, v) -> this.heartbeatFactory((Function)v.typedMarshallable()));
        parser.register(() -> "networkStatsListenerFactory", (s, v) -> this.networkStatsListenerFactory((Function)v.typedMarshallable()));
        parser.register(() -> "serverThreadingStrategy", (s, v) -> this.serverThreadingStrategy((ServerThreadingStrategy)v.asEnum(ServerThreadingStrategy.class)));
        parser.register(() -> "config", (s, v) -> this.config((Marshallable)v.typedMarshallable()));
        return parser;
    }

    public ClusterContext config(Marshallable config) {
        this.config = config;
        return this;
    }

    public void serverThreadingStrategy(ServerThreadingStrategy serverThreadingStrategy) {
        this.serverThreadingStrategy = serverThreadingStrategy;
    }

    public ServerThreadingStrategy serverThreadingStrategy() {
        return this.serverThreadingStrategy;
    }

    private UberHandler.Factory handlerFactory() {
        return this.handlerFactory;
    }

    public void handlerFactory(UberHandler.Factory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public void clusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @NotNull
    public ClusterContext eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    public void defaults() {
    }

    @NotNull
    public ClusterContext localIdentifier(byte localIdentifier) {
        this.localIdentifier = localIdentifier;
        return this;
    }

    @NotNull
    public ClusterContext wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    @NotNull
    public ClusterContext heartbeatFactory(Function<ClusterContext, WriteMarshallable> heartbeatFactor) {
        this.heartbeatFactory = heartbeatFactor;
        return this;
    }

    @NotNull
    public ClusterContext heartbeatIntervalMs(long heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        return this;
    }

    @NotNull
    public ClusterContext heartbeatTimeoutMs(long heartbeatTimeoutMs) {
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
        return this;
    }

    @NotNull
    public ClusterContext wireOutPublisherFactory(Function<WireType, WireOutPublisher> wireOutPublisherFactory) {
        this.wireOutPublisherFactory = wireOutPublisherFactory;
        return this;
    }

    @NotNull
    public ClusterContext networkContextFactory(Function<ClusterContext, NetworkContext> networkContextFactory) {
        this.networkContextFactory = networkContextFactory;
        return this;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public Function<WireType, WireOutPublisher> wireOutPublisherFactory() {
        return this.wireOutPublisherFactory;
    }

    public long heartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public byte localIdentifier() {
        return this.localIdentifier;
    }

    public Function<ClusterContext, NetworkContext> networkContextFactory() {
        return this.networkContextFactory;
    }

    @NotNull
    public ClusterContext connectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
        return this;
    }

    private ConnectionStrategy connectionStrategy() {
        return this.connectionStrategy;
    }

    private Supplier<ConnectionManager> connectionEventHandler() {
        return this.connectionEventHandler;
    }

    @NotNull
    public ClusterContext connectionEventHandler(Supplier<ConnectionManager> connectionEventHandler) {
        this.connectionEventHandler = connectionEventHandler;
        return this;
    }

    private Function<ClusterContext, WriteMarshallable> heartbeatFactory() {
        return this.heartbeatFactory;
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void accept(@NotNull HostDetails hd) {
        if (this.localIdentifier == hd.hostId()) {
            return;
        }
        ConnectionStrategy connectionStrategy = this.connectionStrategy();
        hd.connectionStrategy(connectionStrategy);
        ConnectionManager connectionManager = this.connectionEventHandler().get();
        hd.connectionManager(connectionManager);
        HostConnector hostConnector = new HostConnector(this, new RemoteConnector(this.tcpEventHandlerFactory()), hd);
        hd.hostConnector(hostConnector);
        ClusterNotifier clusterNotifier = new ClusterNotifier(connectionManager, hostConnector, this.bootstraps(hd));
        hd.clusterNotifier(clusterNotifier);
        hd.terminationEventHandler(clusterNotifier);
        clusterNotifier.connect();
    }

    @NotNull
    private List<WriteMarshallable> bootstraps(HostDetails hd) {
        UberHandler.Factory handler = this.handlerFactory();
        Function<ClusterContext, WriteMarshallable> heartbeat = this.heartbeatFactory();
        ArrayList<WriteMarshallable> result = new ArrayList<WriteMarshallable>();
        result.add(handler.apply(this, hd));
        result.add(heartbeat.apply(this));
        return result;
    }

    public Marshallable config() {
        return this.config;
    }
}

