/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class HostConnector
implements Closeable {
    private final WireType wireType;
    private final Function<WireType, WireOutPublisher> wireOutPublisherFactory;
    private final List<WriteMarshallable> bootstraps = new LinkedList<WriteMarshallable>();
    private final RemoteConnector remoteConnector;
    private final String connectUri;
    private final Function<ClusterContext, NetworkContext> networkContextFactory;
    @NotNull
    private final ClusterContext clusterContext;
    private final Function<ClusterContext, NetworkStatsListener> networkStatsListenerFactory;
    private NetworkContext nc;
    @NotNull
    private volatile AtomicReference<WireOutPublisher> wireOutPublisher = new AtomicReference();
    @NotNull
    private EventLoop eventLoop;

    HostConnector(@NotNull ClusterContext clusterContext, RemoteConnector remoteConnector, @NotNull HostDetails hostdetails) {
        this.clusterContext = clusterContext;
        this.remoteConnector = remoteConnector;
        this.networkStatsListenerFactory = clusterContext.networkStatsListenerFactory();
        this.networkContextFactory = clusterContext.networkContextFactory();
        this.connectUri = hostdetails.connectUri();
        this.wireType = clusterContext.wireType();
        this.wireOutPublisherFactory = clusterContext.wireOutPublisherFactory();
        this.eventLoop = clusterContext.eventLoop();
    }

    public synchronized void close() {
        WireOutPublisher wp = this.wireOutPublisher.getAndSet(null);
        SocketChannel socketChannel = this.nc.socketChannel();
        if (socketChannel != null) {
            Closeable.closeQuietly((Object)socketChannel);
            Closeable.closeQuietly((Object)socketChannel.socket());
        }
        if (wp != null) {
            wp.close();
        }
    }

    public synchronized void bootstrap(WriteMarshallable subscription) {
        this.bootstraps.add(subscription);
        WireOutPublisher wp = this.wireOutPublisher.get();
        if (wp != null) {
            wp.publish(subscription);
            wp.wireType(this.wireType);
        }
    }

    public synchronized void connect() {
        WireOutPublisher wireOutPublisher = this.wireOutPublisherFactory.apply(this.clusterContext.wireType());
        if (!this.wireOutPublisher.compareAndSet(null, wireOutPublisher)) {
            wireOutPublisher.close();
            return;
        }
        this.nc = this.networkContextFactory.apply(this.clusterContext);
        this.nc.wireOutPublisher(wireOutPublisher);
        this.nc.isAcceptor(false);
        this.nc.heartbeatTimeoutMs(this.clusterContext.heartbeatTimeoutMs() * 2L);
        this.nc.socketReconnector(this::reconnect);
        this.nc.serverThreadingStrategy(this.clusterContext.serverThreadingStrategy());
        if (this.networkStatsListenerFactory != null) {
            NetworkStatsListener networkStatsListener = this.networkStatsListenerFactory.apply(this.clusterContext);
            this.nc.networkStatsListener(networkStatsListener);
            networkStatsListener.networkContext(this.nc);
        }
        for (WriteMarshallable bootstrap : this.bootstraps) {
            wireOutPublisher.publish(bootstrap);
            wireOutPublisher.wireType(this.wireType);
        }
        this.nc.wireType(this.wireType);
        this.remoteConnector.connect(this.connectUri, this.eventLoop, this.nc, 1000L);
    }

    synchronized void reconnect() {
        this.close();
        if (!this.nc.isAcceptor()) {
            this.connect();
        }
    }
}

