/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.annotation.Nullable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkContextManager;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WireTcpHandler<T extends NetworkContext>
implements TcpHandler,
NetworkContextManager<T> {
    private static final int SIZE_OF_SIZE = 4;
    private static final Logger LOG = LoggerFactory.getLogger(WireTcpHandler.class);
    protected Wire outWire;
    private Wire inWire;
    private boolean recreateWire;
    @Nullable
    private WireType wireType;
    private WireOutPublisher publisher;
    private T nc;
    private volatile boolean closed;
    private boolean isAcceptor;

    public boolean isAcceptor() {
        return this.isAcceptor;
    }

    public void wireType(@NotNull WireType wireType) {
        this.wireType = wireType;
        if (this.publisher != null) {
            this.publisher.wireType(wireType);
        }
    }

    public WireOutPublisher publisher() {
        return this.publisher;
    }

    public void publisher(WireOutPublisher publisher) {
        this.publisher = publisher;
        if (this.wireType() != null) {
            publisher.wireType(this.wireType());
        }
    }

    public void isAcceptor(boolean isAcceptor) {
        this.isAcceptor = isAcceptor;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out) {
        if (this.closed) {
            return;
        }
        WireType wireType = this.wireType();
        this.checkWires(in, out, wireType == null ? WireType.TEXT : wireType);
        if (this.publisher != null && out.writePosition() < (long)TcpEventHandler.TCP_BUFFER) {
            this.publisher.applyAction(out);
        }
        if (in.readRemaining() >= 4L && out.writePosition() < (long)TcpEventHandler.TCP_BUFFER) {
            this.read(in, out);
        }
    }

    @Override
    public T nc() {
        return this.nc;
    }

    @Override
    public void sendHeartBeat(Bytes out, SessionDetailsProvider sessionDetails) {
        WireType wireType = this.wireType;
        if (out.writePosition() == 0L && wireType != null) {
            WireOut outWire = (WireOut)wireType.apply((Object)out);
            outWire.writeDocument(true, w -> w.write(() -> "tid").int64(0L));
            outWire.writeDocument(false, w -> w.writeEventName(() -> "heartbeat").int64(Time.currentTimeMillis()));
        }
    }

    @Override
    public void onEndOfConnection(boolean heartbeatTimeOut) {
        this.publisher.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(@NotNull Bytes in, @NotNull Bytes out) {
        long header = in.readInt(in.readPosition());
        long length = Wires.lengthOf((long)header);
        assert (length >= 0L && length < 0x800000L) : "length=" + length + ",in=" + in + ", hex=" + in.toHexString();
        if (length == 0L && Wires.isData((long)header)) {
            in.readSkip(4L);
            return false;
        }
        if (in.readRemaining() < length + 4L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("required length=%d but only got %d bytes, this is short by %d bytes", length, in.readRemaining(), length - in.readRemaining()));
            }
            return false;
        }
        long limit = in.readLimit();
        long end = in.readPosition() + length + 4L;
        assert (end <= limit);
        long outPos = out.writePosition();
        try {
            in.readLimit(end);
            long position = this.inWire.bytes().readPosition();
            assert (this.inWire.bytes().readRemaining() >= length);
            long wireLimit = this.inWire.bytes().readLimit();
            try {
                this.process((WireIn)this.inWire, (WireOut)this.outWire);
            }
            finally {
                try {
                    this.inWire.bytes().readLimit(wireLimit);
                    this.inWire.bytes().readPosition(position + length);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unexpected error position: " + position + ", length: " + length + " limit(): " + this.inWire.bytes().readLimit(), e);
                }
            }
            long written = out.writePosition() - outPos;
            if (written > 0L) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            LOG.error("", e);
        }
        finally {
            in.readLimit(limit);
            try {
                in.readPosition(end);
            }
            catch (Exception e) {
                throw new IllegalStateException("position: " + end + ", limit:" + limit + ", readLimit: " + in.readLimit() + " " + in.toDebugString(), e);
            }
        }
        return true;
    }

    protected void checkWires(Bytes in, Bytes out, @NotNull WireType wireType) {
        if (this.recreateWire) {
            this.recreateWire = false;
            this.inWire = (Wire)wireType.apply((Object)in);
            this.outWire = (Wire)wireType.apply((Object)out);
            return;
        }
        if (this.inWire == null) {
            this.inWire = (Wire)wireType.apply((Object)in);
            this.recreateWire = false;
        }
        if (this.inWire.bytes() != in) {
            this.inWire = (Wire)wireType.apply((Object)in);
            this.recreateWire = false;
        }
        if (this.outWire == null || this.outWire.bytes() != out) {
            this.outWire = (Wire)wireType.apply((Object)out);
            this.recreateWire = false;
        }
    }

    public WireType wireType() {
        return this.wireType;
    }

    protected abstract void process(@NotNull WireIn var1, @NotNull WireOut var2);

    protected void writeData(@NotNull Bytes inBytes, @NotNull WriteMarshallable c) {
        this.outWire.writeDocument(false, out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable((WireOut)this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                if (LOG.isInfoEnabled()) {
                    LOG.info("While reading " + inBytes.toDebugString(), (Object)(" processing wire " + c), (Object)t);
                }
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName(() -> "exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        });
        WireTcpHandler.logYaml((WireOut)this.outWire);
    }

    protected void writeData(boolean isNotReady, @NotNull Bytes inBytes, @NotNull WriteMarshallable c) {
        WriteMarshallable marshallable = out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable((WireOut)this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                if (LOG.isInfoEnabled()) {
                    LOG.info("While reading " + inBytes.toDebugString(), (Object)(" processing wire " + c), (Object)t);
                }
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName(() -> "exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        };
        if (isNotReady) {
            this.outWire.writeNotReadyDocument(false, marshallable);
        } else {
            this.outWire.writeDocument(false, marshallable);
        }
        WireTcpHandler.logYaml((WireOut)this.outWire);
    }

    public static void logYaml(WireOut outWire) {
        if (YamlLogging.showServerWrites) {
            try {
                LOG.info("\nServer Sends:\n" + Wires.fromSizePrefixedBlobs((Bytes)outWire.bytes()));
            }
            catch (Exception e) {
                LOG.info("\nServer Sends ( corrupted ) :\n" + outWire.bytes().toDebugString());
            }
        }
    }

    @Override
    public void nc(T nc) {
        this.nc = nc;
    }

    @Override
    public void close() {
        this.closed = true;
        this.nc.connectionClosed(true);
        Closeable.closeQuietly((Object)this.nc.closeTask());
    }
}

