/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkLog;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TcpEventHandlerManager;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.WanSimulator;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpEventHandler
implements EventHandler,
Closeable,
TcpEventHandlerManager {
    public static final int TCP_BUFFER = Integer.getInteger("TcpEventHandler.tcpBufferSize", 0x800000);
    private static final Logger LOG = LoggerFactory.getLogger(TcpEventHandler.class);
    private static final int CAPACITY = Integer.getInteger("TcpEventHandler.capacity", TCP_BUFFER);
    @NotNull
    private final SocketChannel sc;
    private final NetworkContext nc;
    @Nullable
    private TcpHandler tcpHandler;
    private final SessionDetailsProvider sessionDetails;
    @NotNull
    private final WriteEventHandler writeEventHandler;
    @NotNull
    private final NetworkLog readLog;
    @NotNull
    private final NetworkLog writeLog;
    int oneInTen;
    @NotNull
    private final ByteBuffer inBB = ByteBuffer.allocateDirect(CAPACITY);
    @NotNull
    private final Bytes inBBB;
    @NotNull
    private final ByteBuffer outBB = ByteBuffer.allocateDirect(CAPACITY);
    @NotNull
    private final Bytes outBBB;
    private long lastTickReadTime = Time.tickTime();
    private long lastHeartBeatTick = this.lastTickReadTime + 1000L;
    volatile boolean isCleaned;

    public TcpEventHandler(@NotNull NetworkContext nc) throws IOException {
        boolean unchecked = nc.isUnchecked();
        this.writeEventHandler = new WriteEventHandler();
        this.sc = nc.socketChannel();
        this.nc = nc;
        this.sc.configureBlocking(false);
        this.sc.socket().setTcpNoDelay(true);
        this.sc.socket().setReceiveBufferSize(TCP_BUFFER);
        this.sc.socket().setSendBufferSize(TCP_BUFFER);
        this.sessionDetails = new VanillaSessionDetails();
        this.sessionDetails.clientAddress((InetSocketAddress)this.sc.getRemoteAddress());
        this.inBBB = Bytes.wrapForRead((ByteBuffer)this.inBB.slice()).unchecked(unchecked);
        this.outBBB = Bytes.wrapForWrite((ByteBuffer)this.outBB.slice()).unchecked(unchecked);
        this.outBB.limit(0);
        this.readLog = new NetworkLog(this.sc, "read");
        this.writeLog = new NetworkLog(this.sc, "write");
    }

    @NotNull
    public HandlerPriority priority() {
        switch (ServerThreadingStrategy.serverThreadingStrategy()) {
            case SINGLE_THREADED: {
                return HandlerPriority.HIGH;
            }
            case MULTI_THREADED_BUSY_WAITING: {
                return HandlerPriority.BLOCKING;
            }
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void tcpHandler(TcpHandler tcpHandler) {
        this.tcpHandler = tcpHandler;
    }

    public synchronized boolean action() throws InvalidEventHandlerException {
        if (this.tcpHandler == null) {
            return false;
        }
        if (!this.sc.isOpen()) {
            this.tcpHandler.onEndOfConnection(false);
            throw new InvalidEventHandlerException();
        }
        if (this.oneInTen++ == 10) {
            this.oneInTen = 0;
            try {
                this.writeEventHandler.action();
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        try {
            int read;
            int start = this.inBB.position();
            int n = read = this.inBB.remaining() > 0 ? this.sc.read(this.inBB) : Integer.MAX_VALUE;
            if (read > 0) {
                WanSimulator.dataRead(read);
                this.tcpHandler.onReadTime(System.nanoTime());
                this.lastTickReadTime = Time.tickTime();
                this.readLog.log(this.inBB, start, this.inBB.position());
                return this.invokeHandler();
            }
            if (read < 0) {
                this.closeSC();
                throw new InvalidEventHandlerException();
            }
            this.readLog.idle();
            if (this.nc.heartbeatIntervalTicks() == 0L) {
                return false;
            }
            long tickTime = Time.tickTime();
            if (tickTime > this.lastTickReadTime + this.nc.heartBeatTimeoutTicks()) {
                this.closeSC();
                throw new InvalidEventHandlerException();
            }
            if (tickTime > this.lastHeartBeatTick + this.nc.heartbeatIntervalTicks()) {
                this.lastHeartBeatTick = tickTime;
                this.sendHeartBeat();
            }
        }
        catch (ClosedChannelException e) {
            this.closeSC();
        }
        catch (IOException e) {
            this.handleIOE(e, this.tcpHandler.hasClientClosed());
        }
        return false;
    }

    public synchronized void clean() {
        if (this.isCleaned) {
            return;
        }
        this.isCleaned = false;
        long usedDirectMemory = Jvm.usedDirectMemory();
        IOTools.clean((ByteBuffer)this.inBB);
        IOTools.clean((ByteBuffer)this.outBB);
        if (usedDirectMemory == Jvm.usedDirectMemory()) {
            LOG.error("nothing cleaned");
        }
    }

    private void sendHeartBeat() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendHeartbeat - " + this.sc.getRemoteAddress());
        }
        assert (this.outBB != null);
        assert (this.outBBB != null);
        this.outBBB.writePosition((long)this.outBB.limit());
        this.tcpHandler.sendHeartBeat(this.outBBB, this.sessionDetails);
        if (this.outBBB.writePosition() > (long)this.outBB.limit() || this.outBBB.writePosition() >= 4L) {
            this.outBB.limit(Maths.toInt32((long)this.outBBB.writePosition()));
            this.tryWrite();
        } else {
            this.writeLog.idle();
        }
    }

    private boolean invokeHandler() throws IOException {
        long lastInBBBReadPosition;
        boolean busy = false;
        this.inBBB.readLimit((long)this.inBB.position());
        this.outBBB.writePosition((long)this.outBB.limit());
        do {
            lastInBBBReadPosition = this.inBBB.readPosition();
            this.tcpHandler.process(this.inBBB, this.outBBB);
            if (this.outBBB.writePosition() <= (long)this.outBB.limit() && this.outBBB.writePosition() < 4L) continue;
            this.outBB.limit(Maths.toInt32((long)this.outBBB.writePosition()));
            busy |= this.tryWrite();
            break;
        } while (lastInBBBReadPosition != this.inBBB.readPosition());
        if (this.inBBB.readPosition() > 0L) {
            this.inBB.position((int)this.inBBB.readPosition());
            this.inBB.limit((int)this.inBBB.readLimit());
            this.inBB.compact();
            this.inBBB.readPosition(0L);
            busy = true;
        }
        return busy;
    }

    private void handleIOE(@NotNull IOException e, boolean clientIntentionallyClosed) {
        try {
            if (clientIntentionallyClosed) {
                return;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("An existing connection was forcibly closed")) {
                LOG.warn(e.getMessage());
            } else if (!(e instanceof ClosedByInterruptException)) {
                LOG.error("", (Throwable)e);
            }
        }
        finally {
            this.closeSC();
        }
    }

    public void close() {
        this.closeSC();
        this.clean();
    }

    private void closeSC() {
        try {
            this.tcpHandler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean tryWrite() throws IOException {
        if (this.outBB.remaining() <= 0) {
            return false;
        }
        int start = this.outBB.position();
        long writeTickTime = Time.tickTime();
        long writeTime = System.nanoTime();
        int wrote = this.sc.write(this.outBB);
        this.tcpHandler.onWriteTime(writeTime);
        this.writeLog.log(this.outBB, start, this.outBB.position());
        if (wrote < 0) {
            this.closeSC();
        } else if (wrote > 0) {
            this.lastTickReadTime = writeTickTime;
            this.outBB.compact().flip();
            this.outBBB.writeLimit((long)this.outBB.capacity());
            this.outBBB.writePosition((long)this.outBB.limit());
            return true;
        }
        return false;
    }

    private class WriteEventHandler
    implements EventHandler {
        private WriteEventHandler() {
        }

        public boolean action() throws InvalidEventHandlerException {
            if (!TcpEventHandler.this.sc.isOpen()) {
                throw new InvalidEventHandlerException();
            }
            boolean busy = false;
            try {
                int remaining = TcpEventHandler.this.outBB.remaining();
                boolean bl = busy = remaining > 0;
                if (busy) {
                    TcpEventHandler.this.tryWrite();
                }
                if (TcpEventHandler.this.outBB.remaining() == remaining) {
                    TcpEventHandler.this.invokeHandler();
                    if (!busy) {
                        busy = TcpEventHandler.this.tryWrite();
                    }
                }
            }
            catch (ClosedChannelException cce) {
                TcpEventHandler.this.closeSC();
            }
            catch (IOException e) {
                TcpEventHandler.this.handleIOE(e, TcpEventHandler.this.tcpHandler.hasClientClosed());
            }
            return busy;
        }
    }
}

