/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.nio.BufferOverflowException;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.VanillaWireOutPublisher;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WireTcpHandler
implements TcpHandler {
    private static final int SIZE_OF_SIZE = 4;
    private static final Logger LOG = LoggerFactory.getLogger(WireTcpHandler.class);
    protected final WireOutPublisher publisher = new VanillaWireOutPublisher(() -> this.wireType);
    protected Wire outWire;
    private Wire inWire;
    private boolean recreateWire;
    boolean firstTime = true;
    WireType wireType;

    public WireTcpHandler(@NotNull Function<Bytes, Wire> bytesToWire) {
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out, @NotNull SessionDetailsProvider sessionDetails) {
        if (this.firstTime) {
            boolean success = this.readHeader(in, out, sessionDetails);
            if (!success) {
                Thread.yield();
                return;
            }
            this.firstTime = false;
        }
        this.checkWires(in, out, this.wireType);
        this.publisher.applyAction((WireOut)this.outWire, () -> {
            if (in.readRemaining() >= 4L && out.writePosition() < (long)TcpEventHandler.TCP_BUFFER) {
                this.read(in, out, sessionDetails);
            }
        });
    }

    public boolean readHeader(@NotNull Bytes in, Bytes out, @NotNull SessionDetailsProvider sessionDetails) {
        if (in.readRemaining() < 5L) {
            return false;
        }
        int required = Wires.lengthOf((long)in.readInt(in.readPosition()));
        if (in.readRemaining() < (long)(required + 4)) {
            return false;
        }
        byte b = in.readByte(4L);
        WireType headerWireType = (b & 0x80) == 0 ? WireType.TEXT : WireType.BINARY;
        Wire inWire = (Wire)headerWireType.apply((Object)in);
        Wire outWire = (Wire)headerWireType.apply((Object)out);
        this.process((WireIn)inWire, (WireOut)outWire, sessionDetails);
        this.wireType = sessionDetails.wireType() == null ? headerWireType : sessionDetails.wireType();
        return true;
    }

    @Override
    public void sendHeartBeat(Bytes out, SessionDetailsProvider sessionDetails) {
        if (out.writePosition() == 0L) {
            WireOut outWire = (WireOut)this.wireType.apply((Object)out);
            outWire.writeDocument(true, w -> w.write(() -> "tid").int64(0L));
            outWire.writeDocument(false, w -> w.writeEventName(() -> "heartbeat").int64(Time.currentTimeMillis()));
        }
    }

    @Override
    public void onEndOfConnection(boolean heartbeatTimeOut) {
        this.publisher.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(@NotNull Bytes in, @NotNull Bytes out, @NotNull SessionDetailsProvider sessionDetails) {
        long header = in.readInt(in.readPosition());
        long length = Wires.lengthOf((long)header);
        assert (length >= 0L && length < 0x800000L) : "length=" + length + ",in=" + in + ", hex=" + in.toHexString();
        if (length == 0L && Wires.isData((long)header)) {
            in.readSkip(4L);
            return false;
        }
        if (in.readRemaining() < length + 4L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("required length=%d but only got %d bytes, this is short by %d bytes", length, in.readRemaining(), length - in.readRemaining()));
            }
            return false;
        }
        long limit = in.readLimit();
        long end = in.readPosition() + length + 4L;
        assert (end <= limit);
        long outPos = out.writePosition();
        try {
            in.readLimit(end);
            long position = this.inWire.bytes().readPosition();
            try {
                this.process((WireIn)this.inWire, (WireOut)this.outWire, sessionDetails);
            }
            finally {
                try {
                    this.inWire.bytes().readPosition(position + length);
                }
                catch (BufferOverflowException e) {
                    throw new IllegalStateException("Unexpected error position: " + position + ", length: " + length + " limit(): " + this.inWire.bytes().readLimit(), e);
                }
            }
            long written = out.writePosition() - outPos;
            if (written > 0L) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            LOG.error("", e);
        }
        finally {
            in.readLimit(limit);
            try {
                in.readPosition(end);
            }
            catch (Exception e) {
                throw new IllegalStateException("position: " + end + ", limit:" + limit + ", readLimit: " + in.readLimit() + " " + in.toDebugString(), e);
            }
        }
        return true;
    }

    private void checkWires(Bytes in, Bytes out, @NotNull WireType wireType) {
        if (this.recreateWire) {
            this.recreateWire = false;
            this.inWire = (Wire)wireType.apply((Object)in);
            this.outWire = (Wire)wireType.apply((Object)out);
            return;
        }
        if (this.inWire == null) {
            this.inWire = (Wire)wireType.apply((Object)in);
            this.recreateWire = false;
        }
        if (this.inWire.bytes() != in) {
            this.inWire = (Wire)wireType.apply((Object)in);
            this.recreateWire = false;
        }
        if (this.outWire == null || this.outWire.bytes() != out) {
            this.outWire = (Wire)wireType.apply((Object)out);
            this.recreateWire = false;
        }
    }

    protected abstract void process(@NotNull WireIn var1, @NotNull WireOut var2, @NotNull SessionDetailsProvider var3);
}

