/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.ConnectionDetails;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.threads.LongPauser;
import net.openhft.chronicle.threads.Pauser;
import org.jetbrains.annotations.NotNull;

public class ConnectorEventHandler
implements EventHandler,
Closeable {
    @NotNull
    private final Function<ConnectionDetails, TcpHandler> tcpHandlerSupplier;
    @NotNull
    private final Supplier<SessionDetailsProvider> sessionDetailsSupplier;
    private final long heartbeatIntervalTicks;
    private final long heartbeatTimeOutTicks;
    private final Map<String, SocketChannel> descriptionToChannel = new ConcurrentHashMap<String, SocketChannel>();
    private final Pauser pauser = new LongPauser(0, 0, 5L, 5L, TimeUnit.SECONDS);
    private EventLoop eventLoop;
    private Map<String, ConnectionDetails> nameToConnectionDetails;
    private boolean unchecked;

    public ConnectorEventHandler(@NotNull Map<String, ConnectionDetails> nameToConnectionDetails, @NotNull Function<ConnectionDetails, TcpHandler> tcpHandlerSupplier, @NotNull Supplier<SessionDetailsProvider> sessionDetailsSupplier, long heartbeatIntervalTicks, long heartbeatTimeOutTicks) throws IOException {
        this.nameToConnectionDetails = nameToConnectionDetails;
        this.tcpHandlerSupplier = tcpHandlerSupplier;
        this.sessionDetailsSupplier = sessionDetailsSupplier;
        this.heartbeatIntervalTicks = heartbeatIntervalTicks;
        this.heartbeatTimeOutTicks = heartbeatTimeOutTicks;
    }

    public boolean action() throws InvalidEventHandlerException, InterruptedException {
        this.nameToConnectionDetails.entrySet().forEach(entry -> {
            try {
                SocketChannel socketChannel = this.descriptionToChannel.get(entry.getKey());
                if (socketChannel == null) {
                    if (((ConnectionDetails)entry.getValue()).isDisable()) {
                        return;
                    }
                    socketChannel = TCPRegistry.createSocketChannel(((ConnectionDetails)entry.getValue()).getHostNameDescription());
                    this.descriptionToChannel.put((String)entry.getKey(), socketChannel);
                    ((ConnectionDetails)entry.getValue()).setConnected(true);
                    SessionDetailsProvider sessionDetails = this.sessionDetailsSupplier.get();
                    sessionDetails.clientAddress((InetSocketAddress)socketChannel.getRemoteAddress());
                    this.eventLoop.addHandler((EventHandler)new TcpEventHandler(socketChannel, this.tcpHandlerSupplier.apply((ConnectionDetails)entry.getValue()), sessionDetails, this.unchecked, this.heartbeatIntervalTicks, this.heartbeatTimeOutTicks));
                } else if (socketChannel.isOpen()) {
                    if (((ConnectionDetails)entry.getValue()).isDisable()) {
                        socketChannel.close();
                        ((ConnectionDetails)entry.getValue()).setConnected(false);
                        this.descriptionToChannel.remove(entry.getKey());
                    }
                } else {
                    ((ConnectionDetails)entry.getValue()).setConnected(false);
                    this.descriptionToChannel.remove(entry.getKey());
                }
            }
            catch (ConnectException e) {
                System.out.println((String)entry.getKey() + e.getMessage());
            }
            catch (IOException e) {
                System.out.println((String)entry.getKey() + e.getMessage());
                e.printStackTrace();
            }
        });
        this.pauser.pause();
        return false;
    }

    public void updateConnectionDetails(ConnectionDetails connectionDetails) {
        this.nameToConnectionDetails.put(connectionDetails.getID(), connectionDetails);
        this.forceRescan();
    }

    public void forceRescan() {
        this.pauser.unpause();
    }

    public void unchecked(boolean unchecked) {
        this.unchecked = unchecked;
    }

    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.BLOCKING;
    }

    @Override
    public void close() throws IOException {
    }
}

