/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaWireOutPublisher
implements WireOutPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaWireOutPublisher.class);
    private volatile boolean closed = false;
    private final Wire wire;

    public VanillaWireOutPublisher(@NotNull Function<Bytes, Wire> wireType) {
        this.wire = wireType.apply(Bytes.elasticByteBuffer());
    }

    @Override
    public synchronized void applyAction(@NotNull WireOut out, @NotNull Runnable read) {
        read.run();
        long sourceBytesRemaining = this.wire.bytes().readRemaining();
        if (sourceBytesRemaining == 0L) {
            return;
        }
        if (out.bytes().writeRemaining() < sourceBytesRemaining) {
            return;
        }
        long targetBytesRemaining = out.bytes().writeRemaining();
        out.bytes().write((BytesStore)this.wire.bytes());
        long bytesWritten = targetBytesRemaining - out.bytes().writeRemaining();
        assert (bytesWritten == sourceBytesRemaining) : "bytesWritten=" + bytesWritten + ", " + "sourceBytesRemaining=" + sourceBytesRemaining;
        this.wire.bytes().clear();
        if (YamlLogging.showServerWrites) {
            try {
                LOG.info("\nServer Publishes (from async publisher ) :\n" + Wires.fromSizePrefixedBlobs((Bytes)out.bytes()));
            }
            catch (Exception e) {
                LOG.info("\nServer Publishes ( from async publisher - corrupted ) :\n" + out.bytes().toDebugString());
                LOG.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, WriteMarshallable event) {
        assert (Thread.holdsLock(this));
        VanillaWireOutPublisher vanillaWireOutPublisher = this;
        synchronized (vanillaWireOutPublisher) {
            event.writeMarshallable((WireOut)this.wire);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        assert (Thread.holdsLock(this));
        VanillaWireOutPublisher vanillaWireOutPublisher = this;
        synchronized (vanillaWireOutPublisher) {
            return this.wire.bytes().writePosition() == 0L;
        }
    }

    public synchronized void close() {
        this.closed = true;
        this.wire.clear();
    }
}

