/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.CloseablesManager;
import net.openhft.chronicle.network.connection.RemoteCallTimeoutException;
import net.openhft.chronicle.network.event.EventGroup;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientWiredStatelessTcpConnectionHub {
    private static final Logger LOG = LoggerFactory.getLogger(ClientWiredStatelessTcpConnectionHub.class);
    public static final int SIZE_OF_SIZE = 4;
    protected final String name;
    protected final InetSocketAddress remoteAddress;
    public final long timeoutMs;
    protected final int tcpBufferSize;
    private final ReentrantLock inBytesLock = new ReentrantLock(true);
    private final ReentrantLock outBytesLock = new ReentrantLock();
    @NotNull
    private final AtomicLong transactionID = new AtomicLong(0L);
    @Nullable
    protected CloseablesManager closeables;
    final Wire outWire;
    final Wire inWire;
    private long largestChunkSoFar = 0L;
    public int localIdentifier;
    private SocketChannel clientChannel;
    private volatile long parkedTransactionId;
    private volatile long parkedTransactionTimeStamp;
    private long limitOfLast = 0L;
    private long startTime;
    private boolean doHandShaking;

    public ClientWiredStatelessTcpConnectionHub(byte localIdentifier, boolean doHandShaking, @NotNull InetSocketAddress remoteAddress, int tcpBufferSize, long timeout, @NotNull Function<Bytes, Wire> byteToWire) {
        this.localIdentifier = localIdentifier;
        this.doHandShaking = doHandShaking;
        this.tcpBufferSize = tcpBufferSize;
        this.remoteAddress = remoteAddress;
        this.outWire = byteToWire.apply(Bytes.elasticByteBuffer());
        this.inWire = byteToWire.apply(Bytes.elasticByteBuffer());
        this.name = " connected to " + remoteAddress.toString();
        this.timeoutMs = timeout;
        this.attemptConnect(remoteAddress);
    }

    private synchronized void attemptConnect(InetSocketAddress remoteAddress) {
        this.closeExisting();
        try {
            SocketChannel socketChannel = ClientWiredStatelessTcpConnectionHub.openSocketChannel(this.closeables);
            if (socketChannel.connect(remoteAddress)) {
                this.clientChannel = socketChannel;
                this.clientChannel.configureBlocking(false);
                this.clientChannel.socket().setTcpNoDelay(true);
                this.clientChannel.socket().setReceiveBufferSize(this.tcpBufferSize);
                this.clientChannel.socket().setSendBufferSize(this.tcpBufferSize);
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            if (this.closeables != null) {
                this.closeables.closeQuietly();
            }
            this.clientChannel = null;
        }
    }

    public ReentrantLock inBytesLock() {
        return this.inBytesLock;
    }

    public ReentrantLock outBytesLock() {
        return this.outBytesLock;
    }

    private void checkTimeout(long timeoutTime) {
        if (timeoutTime < System.currentTimeMillis() && !Jvm.isDebug()) {
            throw new RemoteCallTimeoutException("timeout=" + timeoutTime + "ms");
        }
    }

    protected synchronized void lazyConnect(long timeoutMs, InetSocketAddress remoteAddress) {
        SocketChannel result;
        if (this.clientChannel != null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("attempting to connect to " + remoteAddress + " ,name=" + this.name);
        }
        long timeoutAt = System.currentTimeMillis() + timeoutMs;
        while (true) {
            this.checkTimeout(timeoutAt);
            this.closeExisting();
            try {
                result = ClientWiredStatelessTcpConnectionHub.openSocketChannel(this.closeables);
                if (!result.connect(remoteAddress)) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                result.socket().setTcpNoDelay(true);
                result.socket().setReceiveBufferSize(this.tcpBufferSize);
                result.socket().setSendBufferSize(this.tcpBufferSize);
                if (!this.doHandShaking) continue;
            }
            catch (IOException e) {
                if (this.closeables == null) continue;
                this.closeables.closeQuietly();
                continue;
            }
            catch (Exception e) {
                if (this.closeables != null) {
                    this.closeables.closeQuietly();
                }
                throw e;
            }
            break;
        }
        this.clientChannel = result;
    }

    static SocketChannel openSocketChannel(CloseablesManager closeables) throws IOException {
        SocketChannel result = null;
        try {
            result = SocketChannel.open();
            result.socket().setTcpNoDelay(true);
        }
        finally {
            if (result != null) {
                try {
                    closeables.add((Closeable)result);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        return result;
    }

    protected void closeExisting() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = new CloseablesManager();
    }

    public synchronized void close() {
        if (this.closeables != null) {
            this.closeables.closeQuietly();
        }
        this.closeables = null;
        this.clientChannel = null;
    }

    public long nextUniqueTransaction(long time) {
        long old;
        long id = time;
        do {
            if ((old = this.transactionID.get()) < id) continue;
            id = old + 1L;
        } while (!this.transactionID.compareAndSet(old, id));
        return id;
    }

    public void writeSocket(@NotNull Wire wire) {
        assert (this.outBytesLock().isHeldByCurrentThread());
        assert (!this.inBytesLock().isHeldByCurrentThread());
        long timeoutTime = this.startTime + this.timeoutMs;
        try {
            while (true) {
                if (this.clientChannel == null) {
                    this.lazyConnect(this.timeoutMs, this.remoteAddress);
                }
                try {
                    this.writeSocket(wire, timeoutTime);
                }
                catch (ClosedChannelException e) {
                    this.checkTimeout(timeoutTime);
                    this.lazyConnect(this.timeoutMs, this.remoteAddress);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException((Exception)e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public Wire proxyReply(long timeoutTime, long tid) {
        assert (this.inBytesLock().isHeldByCurrentThread());
        try {
            return this.proxyReplyThrowable(timeoutTime, tid);
        }
        catch (IOException e) {
            this.close();
            throw new IORuntimeException((Exception)e);
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
        catch (AssertionError e) {
            LOG.error("name=" + this.name, (Throwable)((Object)e));
            throw e;
        }
    }

    private Wire proxyReplyThrowable(long timeoutTime, long tid) throws IOException {
        while (true) {
            assert (this.inBytesLock().isHeldByCurrentThread());
            Bytes bytes = this.inWire.bytes();
            this.inWireClear();
            this.readSocket(4, timeoutTime);
            int header = bytes.readVolatileInt(bytes.position());
            long messageSize = Wires.lengthOf((long)header);
            assert (messageSize > 0L) : "Invalid message size " + messageSize;
            assert (messageSize < 0x40000000L) : "Invalid message size " + messageSize;
            if (!Wires.isData((long)header)) {
                this.readSocket((int)messageSize, timeoutTime);
                this.inWire.readDocument(w -> {
                    this.parkedTransactionId = CoreFields.tid((WireIn)w);
                    if (this.parkedTransactionId != tid) {
                        this.parkedTransactionTimeStamp = System.currentTimeMillis();
                        this.pause();
                    }
                }, null);
                continue;
            }
            if (this.parkedTransactionId == tid) {
                this.readSocket((int)messageSize, timeoutTime);
                this.logToStandardOutMessageReceived(this.inWire);
                return this.inWire;
            }
            if (System.currentTimeMillis() - timeoutTime > this.parkedTransactionTimeStamp) break;
        }
        throw new IllegalStateException("Skipped Message with transaction-id=" + this.parkedTransactionTimeStamp + ", this can occur when you have another thread which has called the " + "stateless client and terminated abruptly before the message has been " + "returned from the server and hence consumed by the other thread.");
    }

    private void inWireClear() {
        this.inWireByteBuffer().clear();
        Bytes bytes = this.inWire.bytes();
        bytes.clear();
    }

    private void pause() {
        assert (!this.outBytesLock().isHeldByCurrentThread());
        assert (this.inBytesLock().isHeldByCurrentThread());
        this.inBytesLock().unlock();
        this.inBytesLock().lock();
    }

    private void readSocket(int requiredNumberOfBytes, long timeoutTime) throws IOException {
        assert (this.inBytesLock().isHeldByCurrentThread());
        ByteBuffer buffer = this.inWireByteBuffer();
        int position = buffer.position();
        try {
            buffer.limit(position + requiredNumberOfBytes);
        }
        catch (IllegalArgumentException e) {
            buffer = this.inWireByteBuffer(position + requiredNumberOfBytes);
            buffer.limit(position + requiredNumberOfBytes);
            buffer.position(position);
        }
        long start = buffer.position();
        while ((long)buffer.position() - start < (long)requiredNumberOfBytes) {
            assert (this.clientChannel != null);
            if (this.clientChannel.read(buffer) == -1) {
                throw new IORuntimeException("Disconnection to server");
            }
            this.checkTimeout(timeoutTime);
        }
        Bytes bytes = this.inWire.bytes();
        bytes.limit((long)(position + requiredNumberOfBytes));
    }

    private ByteBuffer inWireByteBuffer() {
        return (ByteBuffer)this.inWire.bytes().underlyingObject();
    }

    private ByteBuffer inWireByteBuffer(long requiredCapacity) {
        Bytes bytes = this.inWire.bytes();
        bytes.ensureCapacity(requiredCapacity);
        return (ByteBuffer)bytes.underlyingObject();
    }

    private void writeSocket(Wire outWire, long timeoutTime) throws IOException {
        assert (this.outBytesLock().isHeldByCurrentThread());
        assert (!this.inBytesLock().isHeldByCurrentThread());
        Bytes bytes = outWire.bytes();
        long outBytesPosition = bytes.position();
        if (this.outBytesLock().hasQueuedThreads() && outBytesPosition + this.largestChunkSoFar <= (long)this.tcpBufferSize) {
            return;
        }
        ByteBuffer outBuffer = (ByteBuffer)bytes.underlyingObject();
        outBuffer.limit((int)bytes.position());
        outBuffer.position(0);
        if (EventGroup.IS_DEBUG) {
            this.logToStandardOutMessageSent(outWire, outBuffer);
        }
        this.upateLargestChunkSoFarSize(outBuffer);
        while (outBuffer.remaining() > 0) {
            int len = this.clientChannel.write(outBuffer);
            if (len == -1) {
                throw new IORuntimeException("Disconnection to server");
            }
            if (outBuffer.remaining() == 0) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Buffer is full");
            }
            if (outBuffer.remaining() > 0 && this.outBytesLock().hasQueuedThreads() && (long)outBuffer.remaining() + this.largestChunkSoFar <= (long)this.tcpBufferSize) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("continuing -  without all the data being written to the buffer as it will be written by the next thread");
                }
                outBuffer.compact();
                bytes.limit((long)outBuffer.limit());
                bytes.position((long)outBuffer.position());
                return;
            }
            this.checkTimeout(timeoutTime);
        }
        outBuffer.clear();
        bytes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToStandardOutMessageSent(Wire wire, ByteBuffer outBuffer) {
        if (!YamlLogging.clientWrites || !Jvm.isDebug()) {
            return;
        }
        Bytes bytes = wire.bytes();
        long position = bytes.position();
        long limit = bytes.limit();
        try {
            bytes.limit((long)outBuffer.limit());
            bytes.position((long)outBuffer.position());
            if (YamlLogging.clientWrites) {
                try {
                    System.out.println((!YamlLogging.title.isEmpty() ? "### " + YamlLogging.title + "\n" : "") + "" + YamlLogging.writeMessage + (YamlLogging.writeMessage.isEmpty() ? "" : "\n\n") + "sends:\n\n" + "```yaml\n" + (wire instanceof TextWire ? Wires.fromSizePrefixedBlobs((Bytes)bytes) : BytesUtil.toHexString((Bytes)bytes, (long)bytes.position(), (long)bytes.remaining())) + "```");
                    YamlLogging.title = "";
                    YamlLogging.writeMessage = "";
                }
                catch (Exception e) {
                    System.out.println(Bytes.toDebugString((Bytes)bytes));
                }
            }
        }
        finally {
            bytes.limit(limit);
            bytes.position(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToStandardOutMessageReceived(Wire wire) {
        Bytes bytes = wire.bytes();
        if (!YamlLogging.clientReads || !Jvm.isDebug()) {
            return;
        }
        long position = bytes.position();
        long limit = bytes.limit();
        try {
            try {
                System.out.println("\nreceives:\n\n```yaml\n" + (wire instanceof TextWire ? Wires.fromSizePrefixedBlobs((Bytes)bytes) : BytesUtil.toHexString((Bytes)bytes, (long)bytes.position(), (long)bytes.remaining())) + "```\n\n");
                YamlLogging.title = "";
                YamlLogging.writeMessage = "";
            }
            catch (Exception e) {
                System.out.println(Bytes.toDebugString((Bytes)bytes));
            }
        }
        finally {
            bytes.limit(limit);
            bytes.position(position);
        }
    }

    private void upateLargestChunkSoFarSize(ByteBuffer outBuffer) {
        int sizeOfThisChunk = (int)((long)outBuffer.limit() - this.limitOfLast);
        if (this.largestChunkSoFar < (long)sizeOfThisChunk) {
            this.largestChunkSoFar = sizeOfThisChunk;
        }
        this.limitOfLast = outBuffer.limit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long proxySend(@NotNull WireKey eventName, long startTime, @NotNull Wire wire, @NotNull String csp, long cid) {
        assert (this.outBytesLock().isHeldByCurrentThread());
        assert (!this.inBytesLock().isHeldByCurrentThread());
        this.outBytesLock().lock();
        try {
            long tid = this.writeMetaData(startTime, wire, csp, cid);
            wire.writeDocument(false, wireOut -> {
                wireOut.writeEventName(eventName);
                wireOut.writeValue().marshallable(w -> {});
            });
            this.writeSocket(wire);
            long l = tid;
            return l;
        }
        finally {
            this.outBytesLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String proxyReturnString(@NotNull WireKey eventId, Wire outWire, String csp, long cid) {
        long tid;
        long startTime = System.currentTimeMillis();
        this.outBytesLock().lock();
        try {
            tid = this.proxySend(eventId, startTime, outWire, csp, cid);
        }
        finally {
            this.outBytesLock().unlock();
        }
        long timeoutTime = startTime + this.timeoutMs;
        this.inBytesLock().lock();
        try {
            Wire wire = this.proxyReply(timeoutTime, tid);
            int datalen = wire.bytes().readVolatileInt();
            assert (Wires.isData((long)datalen));
            String string = wire.read((WireKey)CoreFields.reply).text();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.inBytesLock().unlock();
        }
    }

    public Wire outWire() {
        assert (this.outBytesLock().isHeldByCurrentThread());
        return this.outWire;
    }

    public long writeMetaData(long startTime, Wire wire, String csp, long cid) {
        assert (this.outBytesLock().isHeldByCurrentThread());
        this.startTime(startTime);
        long tid = this.nextUniqueTransaction(startTime);
        wire.writeDocument(true, wireOut -> {
            if (cid == 0L) {
                wireOut.writeEventName((WireKey)CoreFields.csp).text((CharSequence)csp);
            } else {
                wireOut.writeEventName((WireKey)CoreFields.cid).int64(cid);
            }
            wireOut.writeEventName((WireKey)CoreFields.tid).int64(tid);
        });
        return tid;
    }

    public void writeAsyncHeader(Wire wire, String csp, long cid) {
        assert (this.outBytesLock().isHeldByCurrentThread());
        wire.writeDocument(true, wireOut -> {
            if (cid == 0L) {
                wireOut.writeEventName((WireKey)CoreFields.csp).text((CharSequence)csp);
            } else {
                wireOut.writeEventName((WireKey)CoreFields.cid).int64(cid);
            }
        });
    }

    public void startTime(long startTime) {
        this.startTime = startTime;
    }
}

