/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.StreamCorruptedException;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.TcpHandler;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WireTcpHandler
implements TcpHandler {
    public static final int SIZE_OF_SIZE = 4;
    private final Function<Bytes, Wire> bytesToWire;
    protected Wire inWire;
    protected Wire outWire;
    private static final Logger LOG = LoggerFactory.getLogger(WireTcpHandler.class);
    private boolean recreateWire;

    public WireTcpHandler(@NotNull Function<Bytes, Wire> bytesToWire) {
        this.bytesToWire = bytesToWire;
    }

    @Override
    public void process(Bytes in, Bytes out) {
        this.checkWires(in, out);
        if (in.remaining() < 4L) {
            long outPos = out.position();
            this.publish(this.outWire);
            long written = out.position() - outPos;
            if (written == 0L) {
                out.position(outPos);
                return;
            }
            assert (written <= 1L);
            return;
        }
        do {
            if (this.read(in, out)) continue;
            return;
        } while (in.remaining() > 4L && out.remaining() > out.capacity() / 4L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(Bytes in, Bytes out) {
        long length = Wires.lengthOf((long)in.readInt(in.position()));
        assert (length >= 0L && length < 0x400000L) : "in=" + in + ", hex=" + in.toHexString();
        if (length == 0L) {
            in.skip(4L);
            return false;
        }
        if (in.remaining() < length) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("required length=" + length + " but only got " + in.remaining() + " bytes, " + "this is " + "short by " + (length - in.remaining()) + " bytes");
            }
            return false;
        }
        long limit = in.limit();
        long end = in.position() + length + 4L;
        long outPos = out.position();
        try {
            in.limit(end);
            long position = this.inWire.bytes().position();
            try {
                this.process(this.inWire, this.outWire);
            }
            finally {
                this.inWire.bytes().position(position + length);
            }
            long written = out.position() - outPos;
            if (written > 0L) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
        finally {
            in.limit(limit);
            in.position(end);
        }
        return true;
    }

    private void checkWires(Bytes in, Bytes out) {
        if (this.recreateWire) {
            this.recreateWire = false;
            this.inWire = this.bytesToWire.apply(in);
            this.outWire = this.bytesToWire.apply(out);
            return;
        }
        if (this.inWire == null || this.inWire.bytes() != in) {
            this.inWire = this.bytesToWire.apply(in);
            this.recreateWire = false;
        }
        if (this.outWire == null || this.outWire.bytes() != out) {
            this.outWire = this.bytesToWire.apply(out);
            this.recreateWire = false;
        }
    }

    protected abstract void process(Wire var1, Wire var2) throws StreamCorruptedException;

    protected void publish(Wire out) {
    }
}

