/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Supplier;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptorEventHandler
implements EventHandler,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AcceptorEventHandler.class);
    @NotNull
    private final Supplier<TcpHandler> tcpHandlerSupplier;
    @NotNull
    private final Supplier<SessionDetailsProvider> sessionDetailsSupplier;
    private final ServerSocketChannel ssc;
    private final long heartbeatIntervalTicks;
    private final long heartbeatTimeOutTicks;
    private EventLoop eventLoop;
    private boolean unchecked = false;
    private volatile boolean closed;

    public AcceptorEventHandler(@NotNull String description, @NotNull Supplier<TcpHandler> tcpHandlerSupplier, @NotNull Supplier<SessionDetailsProvider> sessionDetailsSupplier, long heartbeatIntervalTicks, long heartbeatTimeOutTicks) throws IOException {
        this.tcpHandlerSupplier = tcpHandlerSupplier;
        this.ssc = TCPRegistry.acquireServerSocketChannel(description);
        this.sessionDetailsSupplier = sessionDetailsSupplier;
        this.heartbeatIntervalTicks = heartbeatIntervalTicks;
        this.heartbeatTimeOutTicks = heartbeatTimeOutTicks;
    }

    public void unchecked(boolean unchecked) {
        this.unchecked = unchecked;
    }

    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public boolean action() throws InvalidEventHandlerException {
        block6: {
            if (!this.ssc.isOpen()) {
                throw new InvalidEventHandlerException();
            }
            try {
                SocketChannel sc = this.ssc.accept();
                if (sc != null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Accepted " + sc);
                    }
                    SessionDetailsProvider sessionDetails = this.sessionDetailsSupplier.get();
                    sessionDetails.setClientAddress((InetSocketAddress)sc.getRemoteAddress());
                    this.eventLoop.addHandler((EventHandler)new TcpEventHandler(sc, this.tcpHandlerSupplier.get(), sessionDetails, this.unchecked, this.heartbeatIntervalTicks, this.heartbeatTimeOutTicks));
                }
            }
            catch (AsynchronousCloseException e) {
                this.closeSocket();
            }
            catch (Exception e) {
                if (this.closed) break block6;
                LOG.error("", (Throwable)e);
                this.closeSocket();
            }
        }
        return false;
    }

    private void closeSocket() {
        try {
            this.ssc.socket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.ssc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.BLOCKING;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.closeSocket();
    }
}

