/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaWireOutPublisher
implements WireOutPublisher {
    private static final int WARN_QUEUE_LENGTH = 50;
    private static final Logger LOG = LoggerFactory.getLogger(VanillaWireOutPublisher.class);
    private final Queue<WriteMarshallable> publisher = new LinkedTransferQueue<WriteMarshallable>();
    private volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyAction(@NotNull WireOut out, @NotNull Runnable runnable) {
        WriteMarshallable wireConsumer;
        if (this.publisher.isEmpty()) {
            VanillaWireOutPublisher vanillaWireOutPublisher = this;
            synchronized (vanillaWireOutPublisher) {
                runnable.run();
            }
        }
        while (out.bytes().writePosition() < out.bytes().realCapacity() / 4L && (wireConsumer = this.publisher.poll()) != null) {
            wireConsumer.writeMarshallable(out);
            if (!YamlLogging.showServerWrites) continue;
            try {
                LOG.info("\nServer Publishes (from async publisher ) :\n" + Wires.fromSizePrefixedBlobs((Bytes)out.bytes()));
            }
            catch (Exception e) {
                LOG.info("\nServer Publishes ( from async publisher - corrupted ) :\n" + out.bytes().toDebugString());
                LOG.error("", (Throwable)e);
            }
        }
    }

    @Override
    public void put(Object key, WriteMarshallable event) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        int size = this.publisher.size();
        if (size > 50) {
            LOG.debug("publish length: " + size);
        }
        this.publisher.add(event);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }
}

