/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Supplier;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.TcpHandler;
import net.openhft.chronicle.network.event.EventHandler;
import net.openhft.chronicle.network.event.EventLoop;
import net.openhft.chronicle.network.event.HandlerPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptorEventHandler
implements EventHandler,
Closeable {
    private final Supplier<TcpHandler> tcpHandlerSupplier;
    private EventLoop eventLoop;
    private final ServerSocketChannel ssc;
    private static final Logger LOG = LoggerFactory.getLogger(AcceptorEventHandler.class);

    public AcceptorEventHandler(int port, Supplier<TcpHandler> tcpHandlerSupplier) throws IOException {
        this.tcpHandlerSupplier = tcpHandlerSupplier;
        this.ssc = ServerSocketChannel.open();
        this.ssc.socket().setReuseAddress(true);
        this.ssc.bind(new InetSocketAddress(port));
    }

    public int getLocalPort() throws IOException {
        return this.ssc.socket().getLocalPort();
    }

    @Override
    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    @Override
    public boolean runOnce() {
        try {
            SocketChannel sc = this.ssc.accept();
            if (sc != null) {
                this.eventLoop.addHandler(new TcpEventHandler(sc, this.tcpHandlerSupplier.get()));
            }
        }
        catch (AsynchronousCloseException e) {
            this.closeSocket();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            this.closeSocket();
        }
        return false;
    }

    private void closeSocket() {
        try {
            this.ssc.socket().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.ssc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public HandlerPriority priority() {
        return HandlerPriority.BLOCKING;
    }

    @Override
    public boolean isDead() {
        return !this.ssc.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.closeSocket();
    }
}

