/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.StreamCorruptedException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.TcpHandler;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.Wire;

public abstract class WireTcpHandler
implements TcpHandler {
    protected Wire inWire;
    protected Wire outWire;
    private boolean recreateWire;

    @Override
    public void process(Bytes in, Bytes out) {
        this.checkWires(in, out);
        if (in.remaining() < 2L) {
            long outPos = out.position();
            out.skip(2L);
            this.publish(this.outWire);
            long written = out.position() - outPos - 2L;
            if (written == 0L) {
                out.position(outPos);
                return;
            }
            assert (written < 65536L);
            out.writeUnsignedShort(outPos, (int)written);
            return;
        }
        do {
            if (this.processMessage(in, out)) continue;
            return;
        } while (in.remaining() > 2L && out.remaining() > out.capacity() / 2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processMessage(Bytes in, Bytes out) {
        int length = in.readUnsignedShort(in.position());
        assert (length >= 0);
        if (length == 0) {
            in.skip(2L);
            return false;
        }
        if (in.remaining() < (long)(length + 2)) {
            return false;
        }
        in.skip(2L);
        long limit = in.limit();
        long end = in.position() + (long)length;
        long outPos = out.position();
        try {
            out.skip(2L);
            in.limit(end);
            long position = this.inWire.bytes().position();
            try {
                this.process(this.inWire, this.outWire);
            }
            finally {
                this.inWire.bytes().position(position + (long)length);
            }
            long written = out.position() - outPos - 2L;
            if (written == 0L) {
                out.position(outPos);
                boolean bl = false;
                return bl;
            }
            out.writeUnsignedShort(outPos, (int)written);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            in.limit(limit);
            in.position(end);
        }
        return true;
    }

    protected void recreateWire(boolean recreateWire) {
        this.recreateWire = recreateWire;
    }

    private void checkWires(Bytes in, Bytes out) {
        if (this.recreateWire) {
            this.recreateWire = false;
            this.inWire = this.createWriteFor(in);
            this.outWire = this.createWriteFor(out);
            return;
        }
        if (this.inWire == null || this.inWire.bytes() != in) {
            this.inWire = this.createWriteFor(in);
            this.recreateWire = false;
        }
        if (this.outWire == null || this.outWire.bytes() != out) {
            this.outWire = this.createWriteFor(out);
            this.recreateWire = false;
        }
    }

    protected Wire createWriteFor(Bytes bytes) {
        return new TextWire(bytes);
    }

    protected abstract void process(Wire var1, Wire var2) throws StreamCorruptedException;

    protected void publish(Wire out) {
    }
}

