/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.engine.client.ClientWiredStatelessTcpConnectionHub;
import net.openhft.chronicle.wire.CoreFields;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.util.ExceptionMarshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstactStatelessClient<E extends ParameterizeWireKey> {
    protected final ClientWiredStatelessTcpConnectionHub hub;
    private final long cid;
    protected final String channelName;
    protected String csp;
    private final ExceptionMarshaller exceptionMarshaller = new ExceptionMarshaller();
    StringBuilder eventName = new StringBuilder();

    public AbstactStatelessClient(@NotNull String channelName, @NotNull ClientWiredStatelessTcpConnectionHub hub, @NotNull String type, long cid) {
        this.cid = cid;
        this.csp = "//" + channelName + "#" + type;
        this.hub = hub;
        this.channelName = channelName;
    }

    protected long proxyReturnLong(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, f -> f.int64());
    }

    protected int proxyReturnInt(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, f -> f.int32());
    }

    protected int proxyReturnUint16(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumer(eventId, f -> f.uint16());
    }

    public <T> T proxyReturnWireConsumer(@NotNull WireKey eventId, @NotNull Function<ValueIn, T> consumer) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, null);
        return this.readWire(tid, startTime, (WireKey)CoreFields.reply, consumer);
    }

    public <T> T proxyReturnWireConsumerInOut(@NotNull WireKey eventId, CoreFields reply, @Nullable Consumer<ValueOut> consumerOut, @NotNull Function<ValueIn, T> consumerIn) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, consumerOut);
        return this.readWire(tid, startTime, (WireKey)reply, consumerIn);
    }

    protected void proxyReturnVoid(@NotNull WireKey eventId, @Nullable Consumer<ValueOut> consumer) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, consumer);
        this.readWire(tid, startTime, (WireKey)CoreFields.reply, v -> v.marshallable(wireIn -> {}));
    }

    protected long proxyBytesReturnLong(@NotNull WireKey eventId, @Nullable Bytes bytes, WireKey reply) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEventBytes(startTime, eventId, bytes);
        return this.readLong(tid, startTime, reply);
    }

    protected void proxyReturnVoid(@NotNull WireKey eventId) {
        this.proxyReturnVoid(eventId, null);
    }

    protected Marshallable proxyReturnMarshallable(@NotNull WireKey eventId) {
        return this.proxyReturnWireConsumerInOut(eventId, CoreFields.reply, null, ValueIn::typedMarshallable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sendEvent(long startTime, @NotNull WireKey eventId, @Nullable Consumer<ValueOut> consumer) {
        long tid;
        this.hub.outBytesLock().lock();
        try {
            tid = this.writeHeader(startTime);
            this.hub.outWire().writeDocument(false, wireOut -> {
                ValueOut valueOut = wireOut.writeEventName(eventId);
                if (consumer == null) {
                    valueOut.marshallable(WireOut.EMPTY);
                } else {
                    consumer.accept(valueOut);
                }
            });
            this.hub.writeSocket(this.hub.outWire());
        }
        finally {
            this.hub.outBytesLock().unlock();
        }
        return tid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sendEventBytes(long startTime, @NotNull WireKey eventId, @Nullable Bytes c) {
        long tid;
        this.hub.outBytesLock().lock();
        try {
            tid = this.writeHeader(startTime);
            this.hub.outWire().writeDocument(false, wireOut -> {
                wireOut.writeEventName(eventId);
                wireOut.bytes().write(c);
            });
            this.hub.writeSocket(this.hub.outWire());
        }
        finally {
            this.hub.outBytesLock().unlock();
        }
        return tid;
    }

    protected long writeHeader(long startTime) {
        return this.hub.writeHeader(startTime, this.hub.outWire(), this.csp, this.cid);
    }

    protected void checkIsData(Wire wireIn) {
        int datalen = wireIn.bytes().readVolatileInt();
        if (!Wires.isData((long)datalen)) {
            throw new IllegalStateException("expecting a data blob, from ->" + Bytes.toDebugString((Bytes)wireIn.bytes(), (long)0L, (long)wireIn.bytes().limit()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readBoolean(long tid, long startTime) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        this.hub.inBytesLock().lock();
        try {
            Wire wireIn = this.hub.proxyReply(timeoutTime, tid);
            this.checkIsData(wireIn);
            boolean bl = this.readReply((WireIn)wireIn, (WireKey)CoreFields.reply, v -> v.bool());
            return bl;
        }
        finally {
            this.hub.inBytesLock().unlock();
        }
    }

    <R> R readReply(WireIn wireIn, WireKey replyId, Function<ValueIn, R> function) {
        ValueIn event = wireIn.read(this.eventName);
        if (replyId.contentEquals((CharSequence)this.eventName)) {
            return function.apply(event);
        }
        if (CoreFields.exception.contentEquals((CharSequence)this.eventName)) {
            this.exceptionMarshaller.readMarshallable(wireIn);
        }
        throw new UnsupportedOperationException("unknown event=" + this.eventName);
    }

    protected boolean proxyReturnBooleanWithArgs(@NotNull E eventId, Object ... args) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, (WireKey)eventId, AbstactStatelessClient.toParameters(eventId, args));
        return this.readBoolean(tid, startTime);
    }

    protected boolean proxyReturnBooleanWithSequence(@NotNull E eventId, @NotNull Collection sequence) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, (WireKey)eventId, out -> sequence.forEach(arg_0 -> ((ValueOut)out).object(arg_0)));
        return this.readBoolean(tid, startTime);
    }

    protected boolean proxyReturnBoolean(@NotNull WireKey eventId) {
        long startTime = System.currentTimeMillis();
        long tid = this.sendEvent(startTime, eventId, null);
        return this.readBoolean(tid, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readVoid(long tid, long startTime) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        this.hub.inBytesLock().lock();
        try {
            Wire wire = this.hub.proxyReply(timeoutTime, tid);
            this.checkIsData(wire);
            this.readReply((WireIn)wire, (WireKey)CoreFields.reply, valueIn -> null);
        }
        finally {
            this.hub.inBytesLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLong(long tid, long startTime, WireKey replyId) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        this.hub.inBytesLock().lock();
        try {
            Wire wire = this.hub.proxyReply(timeoutTime, tid);
            this.checkIsData(wire);
            long l = this.readReply((WireIn)wire, replyId, ValueIn::int64);
            return l;
        }
        finally {
            this.hub.inBytesLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T readWire(long tid, long startTime, WireKey reply, Function<ValueIn, T> c) {
        assert (!this.hub.outBytesLock().isHeldByCurrentThread());
        long timeoutTime = startTime + this.hub.timeoutMs;
        this.hub.inBytesLock().lock();
        try {
            Wire wire = this.hub.proxyReply(timeoutTime, tid);
            this.checkIsData(wire);
            T t = this.readReply((WireIn)wire, reply, c);
            return t;
        }
        finally {
            this.hub.inBytesLock().unlock();
        }
    }

    public static <E extends ParameterizeWireKey> Consumer<ValueOut> toParameters(@NotNull E eventId, Object ... args) {
        return out -> {
            WireKey[] paramNames = eventId.params();
            assert (args != null);
            assert (args.length == paramNames.length) : "methodName=" + eventId + ", args.length=" + args.length + ", paramNames.length=" + paramNames.length;
            if (paramNames.length == 1) {
                out.object(args[0]);
                return;
            }
            out.marshallable(m -> {
                for (int i = 0; i < paramNames.length; ++i) {
                    ValueOut vo = m.write(paramNames[i]);
                    vo.object(args[i]);
                }
            });
        };
    }
}

