/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WireTcpHandler
implements TcpHandler {
    public static final int SIZE_OF_SIZE = 4;
    private static final Logger LOG = LoggerFactory.getLogger(WireTcpHandler.class);
    static final int SMALL_WRITE_BUFFER = 32768;
    @NotNull
    private final Function<Bytes, Wire> bytesToWire;
    protected Wire inWire;
    protected Wire outWire;
    private boolean recreateWire;
    protected final WireOutPublisher publisher = new WireOutPublisher();

    public WireTcpHandler(@NotNull Function<Bytes, Wire> bytesToWire) {
        this.bytesToWire = bytesToWire;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out, @NotNull SessionDetailsProvider sessionDetails) {
        this.checkWires(in, out);
        this.publisher.applyAction((WireOut)this.outWire, () -> {
            if (in.readRemaining() >= 4L && out.writePosition() < 32768L) {
                this.read(in, out, sessionDetails);
            }
        });
    }

    @Override
    public void onEndOfConnection(boolean heartbeatTimeOut) {
        this.publisher.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(@NotNull Bytes in, @NotNull Bytes out, @NotNull SessionDetailsProvider sessionDetails) {
        long header = in.readInt(in.readPosition());
        long length = Wires.lengthOf((long)header);
        assert (length >= 0L && length < 0x800000L) : "in=" + in + ", hex=" + in.toHexString();
        if (length == 0L && Wires.isData((long)header)) {
            in.readSkip(4L);
            return false;
        }
        if (in.readRemaining() < length) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("required length=%d but only got %d bytes, this is short by %d bytes", length, in.readRemaining(), length - in.readRemaining()));
            }
            return false;
        }
        long limit = in.readLimit();
        long end = in.readPosition() + length + 4L;
        assert (end <= limit);
        long outPos = out.writePosition();
        try {
            in.readLimit(end);
            long position = this.inWire.bytes().readPosition();
            try {
                this.process((WireIn)this.inWire, (WireOut)this.outWire, sessionDetails);
            }
            finally {
                try {
                    this.inWire.bytes().readPosition(position + length);
                }
                catch (BufferOverflowException e) {
                    throw new IllegalStateException("Unexpected error position: " + position + ", length: " + length + " limit(): " + this.inWire.bytes().readLimit(), e);
                }
            }
            long written = out.writePosition() - outPos;
            if (written > 0L) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            LOG.error("", e);
        }
        finally {
            in.readLimit(limit);
            try {
                in.readPosition(end);
            }
            catch (Exception e) {
                throw new IllegalStateException("position: " + end + ", limit:" + limit + ", readLimit: " + in.readLimit() + " " + in.toDebugString(), e);
            }
        }
        return true;
    }

    private void checkWires(Bytes in, Bytes out) {
        if (this.recreateWire) {
            this.recreateWire = false;
            this.inWire = this.bytesToWire.apply(in);
            this.outWire = this.bytesToWire.apply(out);
            return;
        }
        if (this.inWire == null || this.inWire.bytes() != in) {
            this.inWire = this.bytesToWire.apply(in);
            this.recreateWire = false;
        }
        if (this.outWire == null || this.outWire.bytes() != out) {
            this.outWire = this.bytesToWire.apply(out);
            this.recreateWire = false;
        }
    }

    protected abstract void process(@NotNull WireIn var1, @NotNull WireOut var2, @NotNull SessionDetailsProvider var3) throws StreamCorruptedException;
}

