/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.threads.api.InvalidEventHandlerException;
import org.jetbrains.annotations.NotNull;

public class TcpEventHandler
implements EventHandler {
    public static final int CAPACITY = 0x800000;
    @NotNull
    private final SocketChannel sc;
    private final TcpHandler handler;
    private final ByteBuffer inBB = ByteBuffer.allocateDirect(0x800000);
    private final Bytes inBBB;
    private final ByteBuffer outBB = ByteBuffer.allocateDirect(0x800000);
    private final Bytes outBBB;
    private final SessionDetailsProvider sessionDetails;
    private final long heartBeatIntervalTicks;
    private final long heartBeatTimeoutTicks;
    private long lastTickReadTime = Time.tickTime();
    private long lastHeartBeatTick = this.lastTickReadTime + 1000L;

    public TcpEventHandler(@NotNull SocketChannel sc, TcpHandler handler, SessionDetailsProvider sessionDetails, boolean unchecked, long heartBeatIntervalTicks, long heartBeatTimeoutTicks) throws IOException {
        this.heartBeatIntervalTicks = heartBeatIntervalTicks;
        this.heartBeatTimeoutTicks = heartBeatTimeoutTicks;
        assert (heartBeatIntervalTicks <= heartBeatTimeoutTicks / 2L);
        this.sc = sc;
        sc.configureBlocking(false);
        sc.socket().setTcpNoDelay(true);
        sc.socket().setReceiveBufferSize(0x800000);
        sc.socket().setSendBufferSize(0x800000);
        this.handler = handler;
        this.sessionDetails = sessionDetails;
        this.inBBB = Bytes.wrapForRead((ByteBuffer)this.inBB.slice()).unchecked(unchecked);
        this.outBBB = Bytes.wrapForWrite((ByteBuffer)this.outBB.slice()).unchecked(unchecked);
        this.outBB.limit(0);
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.HIGH;
    }

    public void eventLoop(@NotNull EventLoop eventLoop) {
        eventLoop.addHandler((EventHandler)new WriteEventHandler());
    }

    public boolean action() throws InvalidEventHandlerException {
        if (!this.sc.isOpen()) {
            this.handler.onEndOfConnection(false);
            throw new InvalidEventHandlerException();
        }
        try {
            int read;
            int n = read = this.inBB.remaining() > 0 ? this.sc.read(this.inBB) : 1;
            if (read < 0) {
                this.closeSC();
            } else {
                if (read > 0) {
                    this.lastTickReadTime = Time.tickTime();
                    return this.invokeHandler();
                }
                long tickTime = Time.tickTime();
                if (tickTime > this.lastTickReadTime + this.heartBeatTimeoutTicks) {
                    this.handler.onEndOfConnection(true);
                    this.closeSC();
                    throw new InvalidEventHandlerException();
                }
                if (tickTime > Math.max(this.lastHeartBeatTick, this.lastTickReadTime) + this.heartBeatIntervalTicks) {
                    this.lastHeartBeatTick = tickTime;
                    this.sendHeartBeat();
                }
            }
        }
        catch (IOException e) {
            this.handleIOE(e);
        }
        return false;
    }

    protected void sendHeartBeat() throws IOException {
        this.outBBB.writePosition((long)this.outBB.limit());
        this.handler.sendHeartBeat(this.outBBB, this.sessionDetails);
        if (this.outBBB.writePosition() > (long)this.outBB.limit() || this.outBBB.writePosition() >= 4L) {
            this.outBB.limit(Maths.toInt32((long)this.outBBB.writePosition()));
            this.tryWrite();
        }
    }

    boolean invokeHandler() throws IOException {
        boolean busy = false;
        this.inBBB.readLimit((long)this.inBB.position());
        this.outBBB.writePosition((long)this.outBB.limit());
        this.handler.process(this.inBBB, this.outBBB, this.sessionDetails);
        if (this.outBBB.writePosition() > (long)this.outBB.limit() || this.outBBB.writePosition() >= 4L) {
            this.outBB.limit(Maths.toInt32((long)this.outBBB.writePosition()));
            this.tryWrite();
            busy = true;
        }
        if (this.inBBB.readPosition() > 0L) {
            this.inBB.position((int)this.inBBB.readPosition());
            this.inBB.limit((int)this.inBBB.readLimit());
            this.inBB.compact();
            this.inBBB.readPosition(0L);
            this.inBBB.readLimit((long)this.inBB.position());
            busy = true;
        }
        return busy;
    }

    void handleIOE(@NotNull IOException e) {
        if (!(e instanceof ClosedByInterruptException)) {
            e.printStackTrace();
        }
        this.closeSC();
    }

    private void closeSC() {
        try {
            this.sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean tryWrite() throws IOException {
        int wrote = this.sc.write(this.outBB);
        if (wrote < 0) {
            this.closeSC();
        } else if (wrote > 0) {
            this.outBB.compact().flip();
            this.outBBB.writePosition((long)this.outBB.limit());
            this.outBBB.writeLimit((long)this.outBB.capacity());
            return true;
        }
        return false;
    }

    class WriteEventHandler
    implements EventHandler {
        WriteEventHandler() {
        }

        public boolean action() throws InvalidEventHandlerException {
            if (!TcpEventHandler.this.sc.isOpen()) {
                throw new InvalidEventHandlerException();
            }
            try {
                boolean busy;
                boolean bl = busy = TcpEventHandler.this.outBB.remaining() > 0;
                if (busy) {
                    TcpEventHandler.this.tryWrite();
                }
                if (TcpEventHandler.this.outBB.remaining() == 0) {
                    TcpEventHandler.this.invokeHandler();
                    if (!busy) {
                        TcpEventHandler.this.tryWrite();
                    }
                }
            }
            catch (ClosedChannelException cce) {
                TcpEventHandler.this.closeSC();
            }
            catch (IOException e) {
                TcpEventHandler.this.handleIOE(e);
            }
            return false;
        }
    }
}

