/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.openhft.chronicle.network.event.EventHandler;
import net.openhft.chronicle.network.event.EventLoop;
import net.openhft.chronicle.network.event.HotMethod;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;

public class MonitorEventLoop
implements EventLoop,
Runnable {
    final ExecutorService service = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("event-loop-monitor", Boolean.valueOf(true)));
    private final EventLoop parent;
    private final List<EventHandler> handlers = new ArrayList<EventHandler>();
    private final Pauser pauser;
    private volatile boolean running = true;

    public MonitorEventLoop(EventLoop parent, Pauser pauser) {
        this.parent = parent;
        this.pauser = pauser;
    }

    @Override
    public void start() {
        this.running = true;
        this.service.submit(this);
    }

    @Override
    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(EventHandler handler) {
        EventHandler eventHandler = handler;
        synchronized (eventHandler) {
            this.handlers.add(handler);
            handler.eventLoop(this.parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HotMethod
    public void run() {
        try {
            while (this.running) {
                boolean busy;
                List<EventHandler> list = this.handlers;
                synchronized (list) {
                    busy = this.runHandlers();
                }
                if (busy) {
                    this.pauser.reset();
                    continue;
                }
                this.pauser.pause();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @HotMethod
    private boolean runHandlers() {
        boolean busy = false;
        for (int i = 0; i < this.handlers.size(); ++i) {
            EventHandler handler = this.handlers.get(i);
            try {
                busy |= handler.runOnce();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!handler.isDead()) continue;
            this.handlers.remove(i--);
        }
        return busy;
    }
}

