/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.event;

import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.network.event.BlockingEventLoop;
import net.openhft.chronicle.network.event.EventHandler;
import net.openhft.chronicle.network.event.EventLoop;
import net.openhft.chronicle.network.event.HandlerPriority;
import net.openhft.chronicle.network.event.MonitorEventLoop;
import net.openhft.chronicle.network.event.References;
import net.openhft.chronicle.network.event.VanillaEventLoop;
import net.openhft.chronicle.threads.LightPauser;
import net.openhft.chronicle.threads.Pauser;

public class EventGroup
implements EventLoop {
    static final long MONITOR_INTERVAL = TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS);
    public static boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;
    final EventLoop monitor = new MonitorEventLoop(this, (Pauser)new LightPauser(-1L, TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS)));
    final VanillaEventLoop core = new VanillaEventLoop(this, "core", (Pauser)new LightPauser(TimeUnit.NANOSECONDS.convert(20L, TimeUnit.MICROSECONDS), TimeUnit.NANOSECONDS.convert(200L, TimeUnit.MICROSECONDS)), TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MICROSECONDS));
    final BlockingEventLoop blocking = new BlockingEventLoop(this, "blocking");

    @Override
    public void addHandler(EventHandler handler) {
        switch (References.or(handler.priority(), HandlerPriority.BLOCKING)) {
            case HIGH: 
            case MEDIUM: 
            case TIMER: 
            case DAEMON: {
                this.core.addHandler(handler);
                break;
            }
            case MONITOR: {
                this.monitor.addHandler(handler);
                break;
            }
            case BLOCKING: {
                this.blocking.addHandler(handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown priority " + (Object)((Object)handler.priority()));
            }
        }
    }

    @Override
    public void start() {
        this.core.start();
        this.monitor.start();
        this.monitor.addHandler(new LoopBlockMonitor());
    }

    @Override
    public void stop() {
        this.monitor.stop();
        this.core.stop();
    }

    class LoopBlockMonitor
    implements EventHandler {
        long lastInterval = 1L;

        LoopBlockMonitor() {
        }

        @Override
        public boolean runOnce() {
            long blockingTime = System.nanoTime() - EventGroup.this.core.loopStartNS();
            long blockingInterval = blockingTime / (MONITOR_INTERVAL / 2L);
            if (blockingInterval > this.lastInterval && !IS_DEBUG) {
                EventGroup.this.core.dumpRunningState(EventGroup.this.core.name() + " thread has blocked for " + TimeUnit.MILLISECONDS.convert(blockingTime, TimeUnit.NANOSECONDS) + " ms.");
            } else {
                this.lastInterval = Math.max(1L, blockingInterval);
            }
            return false;
        }
    }
}

