/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SetMarshaller<T>
implements BytesReader<Set<T>>,
BytesWriter<Set<T>>,
StatefulCopyable<SetMarshaller<T>> {
    private BytesReader<T> elementReader;
    private BytesWriter<? super T> elementWriter;
    private transient Deque<T> orderedElements;

    public static <T> SetMarshaller<T> of(BytesReader<T> elementReader, BytesWriter<? super T> elementWriter) {
        return new SetMarshaller<T>(elementReader, elementWriter);
    }

    public static <T, M extends BytesReader<T> & BytesWriter<? super T>> SetMarshaller<T> of(M elementMarshaller) {
        return SetMarshaller.of(elementMarshaller, elementMarshaller);
    }

    public SetMarshaller(BytesReader<T> elementReader, BytesWriter<? super T> elementWriter) {
        this.elementReader = elementReader;
        this.elementWriter = elementWriter;
        this.initTransients();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    private void initTransients() {
        this.orderedElements = new ArrayDeque<T>();
    }

    @Override
    @NotNull
    public Set<T> read(Bytes in, @Nullable Set<T> using) {
        int size = in.readInt();
        if (using == null) {
            using = new HashSet<T>((int)((double)size / 0.75));
            for (int i = 0; i < size; ++i) {
                using.add(this.elementReader.read(in, null));
            }
        } else {
            this.orderedElements.addAll(using);
            using.clear();
            for (int i = 0; i < size; ++i) {
                using.add(this.elementReader.read(in, this.orderedElements.pollFirst()));
            }
            this.orderedElements.clear();
        }
        return using;
    }

    @Override
    public void write(Bytes out, @NotNull Set<T> toWrite) {
        out.writeInt(toWrite.size());
        toWrite.forEach(e -> this.elementWriter.write(out, e));
    }

    @Override
    public SetMarshaller<T> copy() {
        return new SetMarshaller<T>(StatefulCopyable.copyIfNeeded(this.elementReader), StatefulCopyable.copyIfNeeded(this.elementWriter));
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.elementReader = (BytesReader)wireIn.read(() -> "elementReader").typedMarshallable();
        this.elementWriter = (BytesWriter)wireIn.read(() -> "elementWriter").typedMarshallable();
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "elementReader").typedMarshallable(this.elementReader);
        wireOut.write(() -> "elementWriter").typedMarshallable(this.elementWriter);
    }
}

