/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.query;

import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.HashLookupSearch;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class KeySearch<K> {
    @StageRef
    public SegmentStages s;
    @StageRef
    public HashLookupSearch hashLookupSearch;
    @StageRef
    public HashEntryStages<K> entry;
    public Data<K> inputKey = null;
    @Stage(value="KeySearch")
    protected SearchState searchState = null;

    public abstract boolean inputKeyInit();

    public void initInputKey(Data<K> inputKey) {
        this.inputKey = inputKey;
    }

    public abstract boolean keySearchInit();

    @Stage(value="KeySearch")
    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    public void initKeySearch() {
        long pos;
        while ((pos = this.hashLookupSearch.nextPos()) >= 0L) {
            if (!this.inputKeyInit()) continue;
            this.entry.readExistingEntry(pos);
            if (!this.keyEquals()) continue;
            this.hashLookupSearch.found();
            this.keyFound();
            return;
        }
        this.searchState = SearchState.ABSENT;
    }

    boolean keyEquals() {
        return this.inputKey.size() == this.entry.keySize && BytesUtil.bytesEqual((RandomDataInput)this.s.segmentBS, (long)this.entry.keyOffset, (RandomDataInput)this.inputKey.bytes(), (long)this.inputKey.offset(), (long)this.entry.keySize);
    }

    @Stage(value="KeySearch")
    void keyFound() {
        this.searchState = SearchState.PRESENT;
    }

    abstract void closeKeySearch();

    public boolean searchStatePresent() {
        return this.searchState == SearchState.PRESENT;
    }

    public boolean searchStateDeleted() {
        return this.searchState == SearchState.DELETED && !this.s.nestedContextsLockedOnSameSegment && this.s.innerUpdateLock.isHeldByCurrentThread();
    }

    public boolean searchStateAbsent() {
        return !this.searchStatePresent() && !this.searchStateDeleted();
    }

    public static enum SearchState {
        PRESENT,
        DELETED,
        ABSENT;

    }
}

