/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.input;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.LogHolder;
import net.openhft.chronicle.hash.impl.stage.query.KeySearch;
import net.openhft.chronicle.hash.replication.RemoteOperationContext;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.data.DummyValueZeroData;
import net.openhft.chronicle.map.impl.stage.data.bytes.ReplicatedInputKeyBytesData;
import net.openhft.chronicle.map.impl.stage.data.bytes.ReplicatedInputValueBytesData;
import net.openhft.chronicle.map.impl.stage.entry.ReplicatedMapEntryStages;
import net.openhft.chronicle.map.impl.stage.query.ReplicatedMapQuery;
import net.openhft.chronicle.map.impl.stage.replication.ReplicationUpdate;
import net.openhft.chronicle.map.replication.MapRemoteQueryContext;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public abstract class ReplicatedInput<K, V, R>
implements RemoteOperationContext<K>,
MapRemoteQueryContext<K, V, R> {
    @StageRef
    ReplicatedChronicleMapHolder<K, V, R> mh;
    @StageRef
    ReplicationUpdate<K> ru;
    @StageRef
    LogHolder lh;
    @StageRef
    ReplicatedInputKeyBytesData<K> replicatedInputKeyBytesValue;
    @StageRef
    ReplicatedInputValueBytesData<V> replicatedInputValueBytesValue;
    @StageRef
    KeySearch<?> ks;
    @StageRef
    ReplicatedMapQuery<K, V, ?> q;
    @StageRef
    SegmentStages s;
    @StageRef
    ReplicatedMapEntryStages<K, V> e;
    @StageRef
    DummyValueZeroData<V> dummyValue;
    public Bytes replicatedInputBytes = null;
    @Stage(value="ReplicationInput")
    public long bootstrapTimestamp;
    @Stage(value="ReplicationInput")
    public long riKeySize = -1L;
    @Stage(value="ReplicationInput")
    public long riValueSize;
    @Stage(value="ReplicationInput")
    public long riKeyOffset;
    @Stage(value="ReplicationInput")
    public long riValueOffset;
    @Stage(value="ReplicationInput")
    public long riTimestamp;
    @Stage(value="ReplicationInput")
    public byte riId;
    @Stage(value="ReplicationInput")
    public boolean isDeleted;

    @Override
    public Data<V> dummyZeroValue() {
        return this.dummyValue;
    }

    public void initReplicatedInputBytes(Bytes replicatedInputBytes) {
        this.replicatedInputBytes = replicatedInputBytes;
    }

    public void initReplicationInput(Bytes replicatedInputBytes) {
        this.initReplicatedInputBytes(replicatedInputBytes);
        this.bootstrapTimestamp = replicatedInputBytes.readLong();
        this.riKeySize = ((ReplicatedChronicleMap)this.mh.m()).keySizeMarshaller.readSize(replicatedInputBytes);
        this.riValueSize = ((ReplicatedChronicleMap)this.mh.m()).valueSizeMarshaller.readSize(replicatedInputBytes);
        this.riTimestamp = replicatedInputBytes.readStopBit();
        this.riId = replicatedInputBytes.readByte();
        this.ru.initReplicationUpdate(this.riTimestamp, this.riId);
        this.isDeleted = replicatedInputBytes.readBoolean();
        this.riKeyOffset = replicatedInputBytes.readPosition();
        this.riValueOffset = this.riKeyOffset + this.riKeySize;
    }

    public void processReplicatedEvent() {
        ((ReplicatedChronicleMap)this.mh.m()).setLastModificationTime(this.riId, this.bootstrapTimestamp);
        this.q.initInputKey(this.replicatedInputKeyBytesValue);
        this.s.innerUpdateLock.lock();
        if (this.isDeleted) {
            ((ReplicatedChronicleMap)this.mh.m()).remoteOperations.remove(this);
        } else {
            ((ReplicatedChronicleMap)this.mh.m()).remoteOperations.put(this, this.replicatedInputValueBytesValue);
        }
    }
}

