/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl.stage.entry;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.ReplicatedChronicleMap;
import net.openhft.chronicle.map.impl.ReplicatedChronicleMapHolder;
import net.openhft.chronicle.map.impl.stage.entry.MapEntryStages;
import net.openhft.chronicle.map.impl.stage.replication.ReplicationUpdate;
import net.openhft.chronicle.map.replication.MapReplicableEntry;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;
import org.jetbrains.annotations.NotNull;

@Staged
public abstract class ReplicatedMapEntryStages<K, V>
extends MapEntryStages<K, V>
implements MapReplicableEntry<K, V>,
MapAbsentEntry<K, V> {
    @StageRef
    ReplicatedChronicleMapHolder<?, ?, ?> mh;
    @StageRef
    ReplicationUpdate ru;
    @Stage(value="ReplicationState")
    long replicationBytesOffset = -1L;

    void initReplicationState() {
        this.replicationBytesOffset = this.keyEnd();
    }

    void updateReplicationState(long timestamp, byte identifier) {
        this.initDelayedUpdateChecksum(true);
        Bytes segmentBytes = this.s.segmentBytesForWrite();
        segmentBytes.writePosition(this.replicationBytesOffset);
        segmentBytes.writeLong(timestamp);
        segmentBytes.writeByte(identifier);
    }

    private long timestampOffset() {
        return this.replicationBytesOffset;
    }

    public long timestamp() {
        return this.s.segmentBS.readLong(this.replicationBytesOffset);
    }

    private long identifierOffset() {
        return this.replicationBytesOffset + 8L;
    }

    byte identifier() {
        return this.s.segmentBS.readByte(this.identifierOffset());
    }

    private long entryDeletedOffset() {
        return this.replicationBytesOffset + 9L;
    }

    public boolean entryDeleted() {
        return this.s.segmentBS.readBoolean(this.entryDeletedOffset());
    }

    public void writeEntryPresent() {
        this.s.segmentBS.writeBoolean(this.entryDeletedOffset(), false);
    }

    public void writeEntryDeleted() {
        this.s.segmentBS.writeBoolean(this.entryDeletedOffset(), true);
    }

    @Override
    public byte originIdentifier() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.identifier();
    }

    @Override
    public long originTimestamp() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.timestamp();
    }

    @Override
    long countValueSizeOffset() {
        return super.countValueSizeOffset() + 10L;
    }

    @Override
    public void updateOrigin(byte newIdentifier, long newTimestamp) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerWriteLock.lock();
        this.updateReplicationState(newTimestamp, newIdentifier);
    }

    @Override
    public void dropChanged() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerUpdateLock.lock();
        this.ru.dropChange();
    }

    @Override
    public void raiseChanged() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerUpdateLock.lock();
        this.ru.raiseChange();
    }

    @Override
    public boolean isChanged() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        this.s.innerReadLock.lock();
        return this.ru.changed();
    }

    public void updatedReplicationStateOnPresentEntry() {
        if (!this.ru.replicationUpdateInit()) {
            this.s.innerWriteLock.lock();
            long timestamp = this.identifier() != ((ReplicatedChronicleMap)this.mh.m()).identifier() ? Math.max(this.timestamp() + 1L, ((ReplicatedChronicleMap)this.mh.m()).timeProvider.currentTime()) : ((ReplicatedChronicleMap)this.mh.m()).timeProvider.currentTime();
            this.updateReplicationState(timestamp, ((ReplicatedChronicleMap)this.mh.m()).identifier());
        }
    }

    public void updatedReplicationStateOnAbsentEntry() {
        if (!this.ru.replicationUpdateInit()) {
            this.s.innerWriteLock.lock();
            this.updateReplicationState(((ReplicatedChronicleMap)this.mh.m()).timeProvider.currentTime(), ((ReplicatedChronicleMap)this.mh.m()).identifier());
        }
    }

    @Override
    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        long oldPos = this.pos;
        long oldTierIndex = this.s.tierIndex;
        super.relocation(newValue, newSizeOfEverythingBeforeValue);
        this.ru.moveChange(oldTierIndex, oldPos, this.pos);
    }

    @Override
    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return super.sizeOfEverythingBeforeValue(keySize, valueSize) + 10L;
    }

    @Override
    @NotNull
    public Data<K> absentKey() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.ks.inputKey;
    }
}

