/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapMarshaller<K, V>
implements BytesReader<Map<K, V>>,
BytesWriter<Map<K, V>>,
StatefulCopyable<MapMarshaller<K, V>> {
    private BytesReader<K> keyReader;
    private BytesWriter<? super K> keyWriter;
    private BytesReader<V> valueReader;
    private BytesWriter<? super V> valueWriter;
    private transient Deque<K> orderedKeys;
    private transient Deque<V> orderedValues;

    public MapMarshaller(BytesReader<K> keyReader, BytesWriter<? super K> keyWriter, BytesReader<V> valueReader, BytesWriter<? super V> valueWriter) {
        this.keyReader = keyReader;
        this.keyWriter = keyWriter;
        this.valueReader = valueReader;
        this.valueWriter = valueWriter;
        this.initTransients();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransients();
    }

    private void initTransients() {
        this.orderedKeys = new ArrayDeque<K>();
        this.orderedValues = new ArrayDeque<V>();
    }

    @Override
    @NotNull
    public Map<K, V> read(Bytes in, @Nullable Map<K, V> using) {
        int size = in.readInt();
        if (using == null) {
            using = new HashMap((int)((double)size / 0.75));
            for (int i = 0; i < size; ++i) {
                using.put(this.keyReader.read(in, null), this.valueReader.read(in, null));
            }
        } else {
            using.forEach((k, v) -> {
                this.orderedKeys.add(k);
                this.orderedValues.add(v);
            });
            using.clear();
            for (int i = 0; i < size; ++i) {
                using.put(this.keyReader.read(in, this.orderedKeys.pollFirst()), this.valueReader.read(in, this.orderedValues.pollFirst()));
            }
            this.orderedKeys.clear();
            this.orderedValues.clear();
        }
        return using;
    }

    @Override
    public void write(Bytes out, @NotNull Map<K, V> toWrite) {
        out.writeInt(toWrite.size());
        toWrite.forEach((k, v) -> {
            this.keyWriter.write(out, k);
            this.valueWriter.write(out, v);
        });
    }

    @Override
    public MapMarshaller<K, V> copy() {
        return new MapMarshaller<K, V>(StatefulCopyable.copyIfNeeded(this.keyReader), StatefulCopyable.copyIfNeeded(this.keyWriter), StatefulCopyable.copyIfNeeded(this.valueReader), StatefulCopyable.copyIfNeeded(this.valueWriter));
    }

    public void readMarshallable(@NotNull WireIn wireIn) throws IORuntimeException {
        this.keyReader = (BytesReader)wireIn.read(() -> "keyReader").typedMarshallable();
        this.keyWriter = (BytesWriter)wireIn.read(() -> "keyWriter").typedMarshallable();
        this.valueReader = (BytesReader)wireIn.read(() -> "valueReader").typedMarshallable();
        this.valueWriter = (BytesWriter)wireIn.read(() -> "valueWriter").typedMarshallable();
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "keyReader").typedMarshallable(this.keyReader);
        wireOut.write(() -> "keyWriter").typedMarshallable(this.keyWriter);
        wireOut.write(() -> "valueReader").typedMarshallable(this.valueReader);
        wireOut.write(() -> "valueWriter").typedMarshallable(this.valueWriter);
    }
}

