/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.analytics.AnalyticsFacade;
import net.openhft.chronicle.core.announcer.Announcer;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.hash.ChronicleHashClosedException;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.ExternalHashQueryContext;
import net.openhft.chronicle.hash.HashSegmentContext;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.ChronicleHashResources;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.ContextHolder;
import net.openhft.chronicle.hash.impl.HashSplitting;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.impl.util.Throwables;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.impl.SerializationBuilder;
import net.openhft.chronicle.map.AbstractChronicleMap;
import net.openhft.chronicle.map.ChronicleHashCorruptionImpl;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.DefaultSpi;
import net.openhft.chronicle.map.DefaultValueProvider;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapClosable;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.MapEntryOperations;
import net.openhft.chronicle.map.MapMethods;
import net.openhft.chronicle.map.MapQueryContext;
import net.openhft.chronicle.map.MapSegmentContext;
import net.openhft.chronicle.map.impl.CompiledMapIterationContext;
import net.openhft.chronicle.map.impl.CompiledMapQueryContext;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.NullReturnValue;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.ret.InstanceReturnValue;
import net.openhft.chronicle.map.internal.AnalyticsHolder;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class VanillaChronicleMap<K, V, R>
extends VanillaChronicleHash<K, MapEntry<K, V>, MapSegmentContext<K, V, ?>, ExternalMapQueryContext<K, V, ?>>
implements AbstractChronicleMap<K, V> {
    public SizeMarshaller valueSizeMarshaller;
    public SizedReader<V> valueReader;
    public DataAccess<V> valueDataAccess;
    public boolean constantlySizedEntry;
    public int alignment;
    public int worstAlignment;
    public transient boolean couldNotDetermineAlignmentBeforeAllocation;
    public transient ChronicleSet<K> chronicleSet;
    public transient MapEntryOperations<K, V, R> entryOperations;
    public transient MapMethods<K, V, R> methods;
    public transient DefaultValueProvider<K, V> defaultValueProvider;
    Type valueClass;
    transient boolean putReturnsNull;
    transient boolean putIfAbsentUsingValue;
    transient boolean removeReturnsNull;
    transient Set<Map.Entry<K, V>> entrySet;
    transient ThreadLocal<ContextHolder> cxt;
    private double maxBloatFactor;
    private transient String name;
    private transient String identityString;
    private transient boolean defaultEntryOperationsAndMethods;

    public VanillaChronicleMap(@NotNull ChronicleMapBuilder<K, V> builder) {
        super(builder);
        SerializationBuilder valueBuilder = builder.valueBuilder;
        this.valueClass = valueBuilder.tClass;
        this.valueSizeMarshaller = valueBuilder.sizeMarshaller();
        this.valueReader = valueBuilder.reader();
        this.valueDataAccess = valueBuilder.dataAccess();
        this.maxBloatFactor = builder.maxBloatFactor();
        this.constantlySizedEntry = builder.constantlySizedEntries();
        this.alignment = builder.valueAlignment();
        this.worstAlignment = builder.worstAlignment();
        this.initTransientsFromBuilder(builder);
        this.initTransients();
        Map additionalEventParameters = AnalyticsFacade.standardAdditionalProperties();
        additionalEventParameters.put("key_type", this.keyClass.getTypeName());
        additionalEventParameters.put("value_type", this.valueClass.getTypeName());
        try {
            additionalEventParameters.put("entries", Long.toString(builder.entries()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Announcer.announce((String)"net.openhft", (String)"chronicle-map", AnalyticsFacade.isEnabled() ? Collections.singletonMap("Analytics", "Chronicle Map reports usage statistics. Learn more or turn off: https://github.com/OpenHFT/Chronicle-Map/blob/master/DISCLAIMER.adoc") : Collections.emptyMap());
        AnalyticsHolder.instance().sendEvent("started", additionalEventParameters);
    }

    public static long alignAddr(long addr, long alignment) {
        return addr + alignment - 1L & (alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    protected void readMarshallableFields(@NotNull WireIn wireIn) {
        super.readMarshallableFields(wireIn);
        this.valueClass = wireIn.read(() -> "valueClass").lenientTypeLiteral();
        this.valueSizeMarshaller = (SizeMarshaller)wireIn.read(() -> "valueSizeMarshaller").object(SizeMarshaller.class);
        this.valueReader = (SizedReader)wireIn.read(() -> "valueReader").object(SizedReader.class);
        this.valueDataAccess = (DataAccess)wireIn.read(() -> "valueDataAccess").object(DataAccess.class);
        this.constantlySizedEntry = wireIn.read(() -> "constantlySizedEntry").bool();
        this.alignment = wireIn.read(() -> "alignment").int32();
        this.worstAlignment = wireIn.read(() -> "worstAlignment").int32();
        this.maxBloatFactor = wireIn.read(() -> "maxBloatFactor").float64();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
        super.writeMarshallable(wireOut);
        wireOut.write(() -> "valueClass").typeLiteral(this.valueClass);
        wireOut.write(() -> "valueSizeMarshaller").object((Object)this.valueSizeMarshaller);
        wireOut.write(() -> "valueReader").object(this.valueReader);
        wireOut.write(() -> "valueDataAccess").object(this.valueDataAccess);
        wireOut.write(() -> "constantlySizedEntry").bool(Boolean.valueOf(this.constantlySizedEntry));
        wireOut.write(() -> "alignment").int32(this.alignment);
        wireOut.write(() -> "worstAlignment").int32(this.worstAlignment);
        wireOut.write(() -> "maxBloatFactor").float64(this.maxBloatFactor);
    }

    void initTransientsFromBuilder(@NotNull ChronicleMapBuilder<K, V> builder) {
        this.name = builder.name();
        this.putReturnsNull = builder.putReturnsNull();
        this.putIfAbsentUsingValue = builder.putIfAbsentUsingValue();
        this.removeReturnsNull = builder.removeReturnsNull();
        this.entryOperations = builder.entryOperations;
        this.methods = builder.methods;
        this.defaultEntryOperationsAndMethods = this.entryOperations == DefaultSpi.mapEntryOperations() && this.methods == DefaultSpi.mapMethods();
        this.defaultValueProvider = builder.defaultValueProvider;
    }

    @Override
    public void initTransients() {
        this.throwExceptionIfClosed();
        super.initTransients();
        this.initOwnTransients();
    }

    public void recover(ChronicleHashResources resources, ChronicleHashCorruption.Listener corruptionListener, ChronicleHashCorruptionImpl corruption) throws IOException {
        this.throwExceptionIfClosed();
        this.basicRecover(resources, corruptionListener, corruption);
        try (IterationContext<K, V, R> iterationContext = this.iterationContext();){
            iterationContext.recoverSegments(corruptionListener, corruption);
        }
    }

    private void initOwnTransients() {
        this.couldNotDetermineAlignmentBeforeAllocation = ChronicleMapBuilder.greatestCommonDivisor((int)this.chunkSize, this.alignment) != this.alignment;
        this.cxt = new ThreadLocal();
    }

    @Override
    protected void cleanupOnClose() {
        super.cleanupOnClose();
        this.valueReader = null;
        this.valueDataAccess = null;
        this.cxt = null;
    }

    public final V checkValue(Object value) {
        Class<V> valueClass = this.valueClass();
        if (!valueClass.isInstance(value)) {
            throw new ClassCastException(this.toIdentityString() + ": Value must be a " + valueClass.getName() + " but was a " + value.getClass());
        }
        return (V)value;
    }

    @Override
    public final long longSize() {
        long result = 0L;
        try (IterationContext<K, V, R> c = this.iterationContext();){
            for (int segmentIndex = 0; segmentIndex < this.segments(); ++segmentIndex) {
                c.initSegmentIndex(segmentIndex);
                result += c.size();
            }
        }
        return result;
    }

    @Override
    public Class<K> keyClass() {
        this.throwExceptionIfClosed();
        return (Class)this.keyClass;
    }

    @Override
    public Type keyType() {
        this.throwExceptionIfClosed();
        return this.keyClass;
    }

    @Override
    public Class<V> valueClass() {
        this.throwExceptionIfClosed();
        return (Class)this.valueClass;
    }

    @Override
    public Type valueType() {
        this.throwExceptionIfClosed();
        return this.valueClass;
    }

    private long tiersUsed() {
        return this.globalMutableState().getExtraTiersInUse();
    }

    private long maxTiers() {
        return (long)(this.maxBloatFactor * (double)this.actualSegments);
    }

    @Override
    public int remainingAutoResizes() {
        this.throwExceptionIfClosed();
        return (int)(this.maxTiers() - this.tiersUsed());
    }

    @Override
    public double maxBloatFactor() {
        return this.maxBloatFactor;
    }

    @Override
    public short percentageFreeSpace() {
        this.throwExceptionIfClosed();
        double totalUsed = 0.0;
        double totalSize = 0.0;
        try (IterationContext<K, V, R> c = this.iterationContext();){
            for (int segmentIndex = 0; segmentIndex < this.segments(); ++segmentIndex) {
                c.initSegmentIndex(segmentIndex);
                if (!(c instanceof CompiledMapIterationContext)) continue;
                CompiledMapIterationContext c1 = (CompiledMapIterationContext)c;
                c1.goToFirstTier();
                ReusableBitSet freeList = c1.freeList();
                totalUsed += (double)freeList.cardinality();
                totalSize += (double)freeList.logicalSize();
                while (c1.hasNextTier()) {
                    c1.nextTier();
                    ReusableBitSet freeList0 = c1.freeList();
                    totalUsed += (double)freeList0.cardinality();
                    totalSize += (double)freeList.logicalSize();
                }
            }
        }
        return (short)(100 - (int)(100.0 * totalUsed / totalSize));
    }

    @Override
    public ChronicleMap.SegmentStats[] segmentStats() {
        this.throwExceptionIfClosed();
        ChronicleMap.SegmentStats[] ret = new ChronicleMap.SegmentStats[this.segments()];
        try (IterationContext<K, V, R> c = this.iterationContext();){
            for (int segmentIndex = 0; segmentIndex < this.segments(); ++segmentIndex) {
                c.initSegmentIndex(segmentIndex);
                if (!(c instanceof CompiledMapIterationContext)) continue;
                CompiledMapIterationContext c1 = (CompiledMapIterationContext)c;
                c1.goToFirstTier();
                ReusableBitSet freeList = c1.freeList();
                ChronicleMap.SegmentStats ss = ret[segmentIndex] = new ChronicleMap.SegmentStats();
                ss.usedBytes = freeList.cardinality() * this.chunkSize;
                ss.sizeInBytes = freeList.logicalSize() * this.chunkSize;
                ss.tiers = 1;
                while (c1.hasNextTier()) {
                    c1.nextTier();
                    ReusableBitSet freeList0 = c1.freeList();
                    ss.usedBytes += freeList0.cardinality() * this.chunkSize;
                    ss.sizeInBytes += freeList0.logicalSize() * this.chunkSize;
                    ++ss.tiers;
                }
            }
        }
        return ret;
    }

    @NotNull
    public final MapClosable acquireContext(@NotNull K key, @NotNull V usingValue) {
        ExternalHashQueryContext q = this.queryContext((Object)key);
        try {
            q.writeLock().lock();
            this.checkAcquiredUsing(this.acquireUsingBody((QueryContextInterface<K, V, R>)q, usingValue), usingValue);
            return q.acquireHandle();
        }
        catch (Throwable throwable) {
            try {
                q.close();
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            throw throwable;
        }
    }

    private void checkAcquiredUsing(V acquired, V using) {
        if (acquired != using) {
            throw new IllegalArgumentException(this.toIdentityString() + ": acquire*() MUST reuse the given value. Given value " + using + " cannot be reused to read " + acquired);
        }
    }

    @Override
    @NotNull
    public final Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = this.newEntrySet());
    }

    @Override
    public int hashCode() {
        this.throwExceptionIfClosed();
        return this.mapHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        this.throwExceptionIfClosed();
        return this.mapEquals(obj);
    }

    public String toString() {
        return this.mapToString();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public String toIdentityString() {
        this.throwExceptionIfClosed();
        if (this.identityString == null) {
            this.identityString = this.makeIdentityString();
        }
        return this.identityString;
    }

    private String makeIdentityString() {
        if (this.chronicleSet != null) {
            return this.chronicleSet.toIdentityString();
        }
        return "ChronicleMap{name=" + this.name() + ", file=" + this.file() + ", identityHashCode=" + System.identityHashCode(this) + "}";
    }

    @Override
    public void clear() {
        this.throwExceptionIfClosed();
        this.forEachEntry(c -> c.context().remove(c));
    }

    public final long readValueSize(Bytes<?> entry) {
        long valueSize = this.valueSizeMarshaller.readSize(entry);
        this.alignReadPosition(entry);
        return valueSize;
    }

    public void alignReadPosition(Bytes<?> entry) {
        this.throwExceptionIfClosed();
        long positionAddr = entry.addressForRead(entry.readPosition());
        long skip = VanillaChronicleMap.alignAddr(positionAddr, this.alignment) - positionAddr;
        if (skip > 0L) {
            entry.readSkip(skip);
        }
    }

    final ChainingInterface q() {
        ThreadLocal<ContextHolder> cxt = this.cxt;
        if (cxt == null) {
            throw new ChronicleHashClosedException(this);
        }
        ContextHolder contextHolder = cxt.get();
        if (contextHolder == null) {
            ChainingInterface queryContext = this.newQueryContext();
            try {
                contextHolder = new ContextHolder(queryContext);
                this.addContext(contextHolder);
                cxt.set(contextHolder);
                return queryContext;
            }
            catch (Throwable throwable) {
                try {
                    ((AutoCloseable)((Object)queryContext)).close();
                }
                catch (Throwable t) {
                    throwable.addSuppressed(t);
                }
                throw throwable;
            }
        }
        ChainingInterface queryContext = contextHolder.get();
        if (queryContext != null) {
            return queryContext;
        }
        throw new ChronicleHashClosedException(this);
    }

    ChainingInterface newQueryContext() {
        CompiledMapQueryContext context = new CompiledMapQueryContext(this);
        IOTools.unmonitor((Object)context.segmentBytes);
        return context;
    }

    public QueryContextInterface<K, V, R> mapContext() {
        return this.q().getContext(CompiledMapQueryContext.class, CompiledMapQueryContext::new, this);
    }

    final ChainingInterface i() {
        ThreadLocal<ContextHolder> cxt = this.cxt;
        if (cxt == null) {
            throw new ChronicleHashClosedException(this);
        }
        ContextHolder contextHolder = cxt.get();
        if (contextHolder == null) {
            ChainingInterface iterationContext = this.newIterationContext();
            try {
                contextHolder = new ContextHolder(iterationContext);
                this.addContext(contextHolder);
                cxt.set(contextHolder);
                return iterationContext;
            }
            catch (Throwable throwable) {
                try {
                    ((AutoCloseable)((Object)iterationContext)).close();
                }
                catch (Throwable t) {
                    throwable.addSuppressed(t);
                }
                throw throwable;
            }
        }
        ChainingInterface iterationContext = contextHolder.get();
        if (iterationContext != null) {
            return iterationContext;
        }
        throw new ChronicleHashClosedException(this);
    }

    ChainingInterface newIterationContext() {
        return new CompiledMapIterationContext(this);
    }

    public IterationContext<K, V, R> iterationContext() {
        return this.i().getContext(CompiledMapIterationContext.class, CompiledMapIterationContext::new, this);
    }

    @Override
    @NotNull
    public QueryContextInterface<K, V, R> queryContext(Object key) {
        assert (!(key instanceof Data));
        this.checkKey(key);
        QueryContextInterface<Object, V, R> c = this.mapContext();
        try {
            c.initInputKey(c.inputKeyDataAccess().getData(key));
            return c;
        }
        catch (Throwable throwable) {
            try {
                c.close();
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            throw throwable;
        }
    }

    @Override
    @NotNull
    public QueryContextInterface<K, V, R> queryContext(Data<K> key) {
        QueryContextInterface<K, V, R> c = this.mapContext();
        try {
            c.initInputKey(key);
            return c;
        }
        catch (Throwable throwable) {
            try {
                c.close();
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            throw throwable;
        }
    }

    @Override
    @NotNull
    public ExternalMapQueryContext<K, V, ?> queryContext(@NotNull BytesStore<?, ?> keyBytes, long offset, long size) {
        QueryContextInterface<K, V, R> c = this.mapContext();
        try {
            c.initInputKey(c.getInputKeyBytesAsData(keyBytes, offset, size));
            return c;
        }
        catch (Throwable throwable) {
            try {
                c.close();
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            throw throwable;
        }
    }

    @Override
    public MapSegmentContext<K, V, ?> segmentContext(int segmentIndex) {
        IterationContext<K, V, R> c = this.iterationContext();
        try {
            c.initSegmentIndex(segmentIndex);
            return c;
        }
        catch (Throwable throwable) {
            try {
                c.close();
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            throw throwable;
        }
    }

    @Override
    public V get(Object key) {
        this.throwExceptionIfClosed();
        return (V)(this.defaultEntryOperationsAndMethods ? this.optimizedGet(key, null) : this.defaultGet(key));
    }

    final V defaultGet(Object key) {
        try (ExternalHashQueryContext q = this.queryContext(key);){
            this.methods.get(q, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    private V optimizedGet(Object key, V using) {
        this.checkKey(key);
        CompiledMapQueryContext c = (CompiledMapQueryContext)this.mapContext();
        boolean needReadUnlock = false;
        Throwable primaryExc = null;
        long segmentHeaderAddress = 0L;
        try {
            Data<Object> inputKey = c.inputKeyDataAccess().getData(key);
            long inputKeySize = inputKey.size();
            long keyHash = inputKey.hash(LongHashFunction.xx_r39());
            HashSplitting hs = this.hashSplitting;
            int segmentIndex = hs.segmentIndex(keyHash);
            segmentHeaderAddress = this.segmentHeaderAddress(segmentIndex);
            CompactOffHeapLinearHashTable hl = this.hashLookup;
            long searchKey = hl.maskUnsetKey(hs.segmentHash(keyHash));
            long searchStartPos = hl.hlPos(searchKey);
            boolean needReadLock = true;
            int indexOfThisContext = c.indexInContextChain;
            int size = c.contextChain.size();
            for (int i = 0; i < size; ++i) {
                LocksInterface root;
                LocksInterface locks;
                if (i == indexOfThisContext || !(locks = (LocksInterface)((Object)c.contextChain.get(i))).segmentHeaderInit() || locks.segmentHeaderAddress() != segmentHeaderAddress || !locks.locksInit() || (root = locks.rootContextLockedOnThisSegment()).totalReadLockCount() <= 0 && root.totalUpdateLockCount() <= 0 && root.totalWriteLockCount() <= 0) continue;
                needReadLock = false;
                break;
            }
            if (needReadLock) {
                BigSegmentHeader.INSTANCE.readLock(segmentHeaderAddress);
                needReadUnlock = true;
            }
            V v = this.tieredValue(c, segmentHeaderAddress, segmentIndex, searchKey, searchStartPos, inputKeySize, inputKey, using);
            return v;
        }
        catch (Throwable t) {
            primaryExc = t;
            throw t;
        }
        finally {
            if (primaryExc != null) {
                try {
                    this.getClose(c, segmentHeaderAddress, needReadUnlock);
                }
                catch (Throwable suppressedExc) {
                    primaryExc.addSuppressed(suppressedExc);
                }
            } else {
                this.getClose(c, segmentHeaderAddress, needReadUnlock);
            }
        }
    }

    private void getClose(@NotNull CompiledMapQueryContext<K, V, R> c, long segmentHeaderAddress, boolean needReadUnlock) {
        Throwable thrown = null;
        try {
            if (needReadUnlock) {
                BigSegmentHeader.INSTANCE.readUnlock(segmentHeaderAddress);
            }
        }
        catch (Throwable t) {
            thrown = t;
        }
        try {
            c.doCloseUsed();
        }
        catch (Throwable t) {
            thrown = Throwables.returnOrSuppress(thrown, t);
        }
        try {
            c.doCloseInputValueDataAccess();
        }
        catch (Throwable t) {
            thrown = Throwables.returnOrSuppress(thrown, t);
        }
        if (thrown != null) {
            throw Jvm.rethrow((Throwable)thrown);
        }
    }

    private V tieredValue(CompiledMapQueryContext<K, V, R> q, long segmentHeaderAddress, int segmentIndex, long searchKey, long searchStartPos, long inputKeySize, Data<K> inputKey, V using) {
        int tier = 0;
        long tierBaseAddr = this.segmentBaseAddr(segmentIndex);
        V value;
        while ((value = this.searchValue(q, searchKey, searchStartPos, tierBaseAddr, inputKeySize, inputKey, using)) == null) {
            long nextTierIndex = tier == 0 ? BigSegmentHeader.INSTANCE.nextTierIndex(segmentHeaderAddress) : TierCountersArea.nextTierIndex(tierBaseAddr + this.tierHashLookupOuterSize);
            if (nextTierIndex == 0L) {
                return null;
            }
            ++tier;
            tierBaseAddr = this.tierIndexToBaseAddr(nextTierIndex);
        }
        return value;
    }

    private V searchValue(CompiledMapQueryContext<K, V, R> q, long searchKey, long searchStartPos, long tierBaseAddr, long inputKeySize, Data<K> inputKey, V using) {
        long entry;
        CompactOffHeapLinearHashTable hl = this.hashLookup;
        PointerBytesStore segmentBytesStore = q.segmentBS;
        segmentBytesStore.set(tierBaseAddr, this.tierSize);
        Bytes bs = q.segmentBytes;
        bs.clear();
        long freeListOffset = this.tierHashLookupOuterSize + 64L;
        long entrySpaceOffset = freeListOffset + this.tierFreeListOuterSize + (long)this.tierEntrySpaceInnerOffset;
        long hlPos = searchStartPos;
        while (!hl.empty(entry = hl.readEntryVolatile(tierBaseAddr, hlPos))) {
            if ((hlPos = hl.step(hlPos)) == searchStartPos) {
                throw new IllegalStateException(this.toIdentityString() + ": HashLookup overflow should never occur");
            }
            if (hl.key(entry) != searchKey) continue;
            long entryPos = hl.value(entry);
            long keySizeOffset = entrySpaceOffset + entryPos * this.chunkSize;
            bs.readLimitToCapacity();
            bs.readPosition(keySizeOffset);
            long keySize = this.keySizeMarshaller.readSize(bs);
            long keyOffset = bs.readPosition();
            if (inputKeySize != keySize || !inputKey.equivalent((RandomDataInput)segmentBytesStore, keyOffset)) continue;
            long valueSizeOffset = keyOffset + keySize;
            bs.readPosition(valueSizeOffset);
            long valueSize = this.readValueSize(bs);
            return q.valueReader.read(bs, valueSize, using);
        }
        return null;
    }

    @Override
    public V getUsing(K key, V usingValue) {
        Objects.requireNonNull(key);
        this.throwExceptionIfClosed();
        return this.defaultEntryOperationsAndMethods ? this.optimizedGet(key, usingValue) : this.defaultGetUsing(key, usingValue);
    }

    final V defaultGetUsing(K key, V usingValue) {
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            q.usingReturnValue().initUsingReturnValue(usingValue);
            this.methods.get(q, q.usingReturnValue());
            Object v = q.usingReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V acquireUsing(K key, V usingValue) {
        Objects.requireNonNull(key);
        this.throwExceptionIfClosed();
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            V v = this.acquireUsingBody((QueryContextInterface<K, V, R>)q, usingValue);
            return v;
        }
    }

    private V acquireUsingBody(@NotNull QueryContextInterface<K, V, R> q, V usingValue) {
        q.usingReturnValue().initUsingReturnValue(usingValue);
        this.methods.acquireUsing(q, q.usingReturnValue());
        return q.usingReturnValue().returnValue();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Objects.requireNonNull(key);
        this.throwExceptionIfClosed();
        this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            InstanceReturnValue returnValue = null;
            if (this.putIfAbsentUsingValue) {
                q.usingReturnValue().initUsingReturnValue(value);
                returnValue = q.usingReturnValue();
            } else {
                returnValue = q.defaultReturnValue();
            }
            this.methods.putIfAbsent(q, q.inputValueDataAccess().getData(value), returnValue);
            Object v = returnValue.returnValue();
            return v;
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        Objects.requireNonNull(key);
        this.throwExceptionIfClosed();
        if (value == null) {
            return false;
        }
        V v = this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext(key);){
            boolean bl = this.methods.remove(q, q.inputValueDataAccess().getData(v));
            return bl;
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Objects.requireNonNull(key);
        this.throwExceptionIfClosed();
        this.checkValue(oldValue);
        this.checkValue(newValue);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            boolean bl = this.methods.replace(q, q.inputValueDataAccess().getData(oldValue), q.wrapValueAsData(newValue));
            return bl;
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.throwExceptionIfClosed();
        Objects.requireNonNull(function);
        this.forEachEntry(entry -> {
            Object newValue = function.apply((Object)entry.key().get(), (Object)entry.value().get());
            entry.context().replaceValue(entry, entry.context().wrapValueAsData(newValue));
        });
    }

    @Override
    public V replace(K key, V value) {
        Objects.requireNonNull(key);
        this.throwExceptionIfClosed();
        this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.replace(q, q.inputValueDataAccess().getData(value), q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.throwExceptionIfClosed();
        try (ExternalHashQueryContext q = this.queryContext(key);){
            boolean bl = this.methods.containsKey((MapQueryContext<K, V, R>)((Object)q));
            return bl;
        }
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key);
        this.throwExceptionIfClosed();
        this.checkValue(value);
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            Data valueData = q.inputValueDataAccess().getData(value);
            InstanceReturnValue returnValue = this.putReturnsNull ? NullReturnValue.get() : q.defaultReturnValue();
            this.methods.put(q, valueData, returnValue);
            Object v = returnValue.returnValue();
            return v;
        }
    }

    @Override
    public V remove(Object key) {
        this.throwExceptionIfClosed();
        try (ExternalHashQueryContext q = this.queryContext(key);){
            InstanceReturnValue returnValue = this.removeReturnsNull ? NullReturnValue.get() : q.defaultReturnValue();
            this.methods.remove(q, returnValue);
            Object v = returnValue.returnValue();
            return v;
        }
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.throwExceptionIfClosed();
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.merge((MapQueryContext<K, ? extends V, R>)((Object)q), q.inputValueDataAccess().getData(value), (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.throwExceptionIfClosed();
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.compute((MapQueryContext<? super K, ? extends V, R>)((Object)q), (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.throwExceptionIfClosed();
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.computeIfAbsent((MapQueryContext<? super K, ? extends V, R>)((Object)q), mappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.throwExceptionIfClosed();
        try (ExternalHashQueryContext q = this.queryContext((Object)key);){
            this.methods.computeIfPresent((MapQueryContext<? super K, ? extends V, R>)((Object)q), (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, q.defaultReturnValue());
            Object v = q.defaultReturnValue().returnValue();
            return v;
        }
    }

    public void verifyTierCountersAreaData() {
        this.throwExceptionIfClosed();
        for (int i = 0; i < this.actualSegments; ++i) {
            try (HashSegmentContext c = this.segmentContext(i);){
                Method verifyTierCountersAreaData = c.getClass().getMethod("verifyTierCountersAreaData", new Class[0]);
                verifyTierCountersAreaData.invoke((Object)c, new Object[0]);
                continue;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

