/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.values.Copyable;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueDataAccess<T>
extends AbstractData<T>
implements DataAccess<T> {
    private Class<T> valueType;
    private transient Class<? extends T> nativeClass;
    private transient Class<? extends T> heapClass;
    private transient Byteable nativeInstance;
    private transient Copyable nativeInstanceAsCopyable;
    private transient Byteable instance;

    public ValueDataAccess(Class<T> valueType) {
        this.valueType = valueType;
        this.initTransients();
    }

    protected Class<T> valueType() {
        return this.valueType;
    }

    protected Class<? extends T> nativeClass() {
        return this.nativeClass;
    }

    protected Class<? extends T> heapClass() {
        return this.heapClass;
    }

    private void initTransients() {
        this.nativeInstance = (Byteable)Values.newNativeReference(this.valueType);
        this.nativeInstanceAsCopyable = (Copyable)this.nativeInstance;
        this.nativeClass = this.nativeInstance.getClass();
        this.heapClass = Values.heapClassFor(this.valueType);
        this.nativeInstance.bytesStore(this.allocateBytesStoreForInstance(), 0L, this.nativeInstance.maxSize());
    }

    private BytesStore<?, ?> allocateBytesStoreForInstance() {
        long instanceSize = this.nativeInstance.maxSize();
        if (instanceSize > 0x7FFFFFF0L) {
            return BytesStore.nativeStoreWithFixedCapacity((long)instanceSize);
        }
        return BytesStore.wrap((ByteBuffer)ByteBuffer.allocate(Maths.toUInt31((long)instanceSize)));
    }

    protected T createInstance() {
        try {
            return this.heapClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RandomDataInput bytes() {
        return this.instance.bytesStore();
    }

    @Override
    public long offset() {
        return this.instance.offset();
    }

    @Override
    public long size() {
        return this.instance.maxSize();
    }

    @Override
    public T get() {
        return (T)this.instance;
    }

    @Override
    public T getUsing(@Nullable T using) {
        if (using == null) {
            using = this.createInstance();
        }
        ((Copyable)using).copyFrom((Object)this.instance);
        return using;
    }

    @Override
    public Data<T> getData(@NotNull T instance) {
        if (instance.getClass() == this.nativeClass) {
            this.instance = (Byteable)instance;
        } else {
            this.nativeInstanceAsCopyable.copyFrom(instance);
            this.instance = this.nativeInstance;
        }
        return this;
    }

    @Override
    public void uninit() {
        this.instance = null;
    }

    @Override
    public DataAccess<T> copy() {
        return new ValueDataAccess<T>(this.valueType);
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.valueType = wireIn.read("valueType").typeLiteral();
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write((CharSequence)"valueType").typeLiteral(this.valueType);
    }
}

