/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DoubleDataAccess
extends AbstractData<Double>
implements DataAccess<Double>,
Data<Double> {
    private transient boolean bsInit;
    private transient BytesStore<?, ?> bs;
    private transient Double instance;

    public DoubleDataAccess() {
        this.initTransients();
    }

    private void initTransients() {
        this.bs = BytesStore.wrap((byte[])new byte[8]);
    }

    @Override
    public RandomDataInput bytes() {
        if (!this.bsInit) {
            this.bs.writeDouble(0L, this.instance.doubleValue());
            this.bsInit = true;
        }
        return this.bs;
    }

    @Override
    public long offset() {
        return 0L;
    }

    @Override
    public long size() {
        return 8L;
    }

    @Override
    public Double get() {
        return this.instance;
    }

    @Override
    public Double getUsing(@Nullable Double using) {
        return this.instance;
    }

    @Override
    public long hash(LongHashFunction f) {
        return f.hashLong(Double.doubleToRawLongBits(this.instance));
    }

    @Override
    public boolean equivalent(RandomDataInput source, long sourceOffset) {
        return source.readLong(sourceOffset) == Double.doubleToRawLongBits(this.instance);
    }

    @Override
    public void writeTo(RandomDataOutput target, long targetOffset) {
        target.writeDouble(targetOffset, this.instance.doubleValue());
    }

    @Override
    public Data<Double> getData(@NotNull Double instance) {
        this.instance = instance;
        this.bsInit = false;
        return this;
    }

    @Override
    public void uninit() {
        this.instance = null;
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
    }

    @Override
    public DataAccess<Double> copy() {
        return new DoubleDataAccess();
    }
}

