/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set;

import java.io.File;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.impl.util.Objects;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.DummyValue;
import net.openhft.chronicle.set.ExternalSetQueryContext;
import net.openhft.chronicle.set.SetEntry;
import net.openhft.chronicle.set.SetSegmentContext;
import org.jetbrains.annotations.NotNull;

class SetFromMap<E>
extends AbstractSet<E>
implements ChronicleSet<E> {
    private final ChronicleMap<E, DummyValue> m;
    private transient Set<E> s;

    SetFromMap(VanillaChronicleMap<E, DummyValue, ?> map) {
        this.m = map;
        map.chronicleSet = this;
        this.s = map.keySet();
    }

    @Override
    public void clear() {
        this.throwExceptionIfClosed();
        this.m.clear();
    }

    @Override
    public int size() {
        this.throwExceptionIfClosed();
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        this.throwExceptionIfClosed();
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.throwExceptionIfClosed();
        return this.m.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        this.throwExceptionIfClosed();
        return this.m.remove(o, (Object)DummyValue.DUMMY_VALUE);
    }

    @Override
    public boolean add(E e) {
        this.throwExceptionIfClosed();
        return this.m.putIfAbsent(e, DummyValue.DUMMY_VALUE) == null;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        this.throwExceptionIfClosed();
        return this.s.iterator();
    }

    @Override
    public Object[] toArray() {
        this.throwExceptionIfClosed();
        return this.s.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.s.toArray(a);
    }

    @Override
    public String toString() {
        return this.s.toString();
    }

    @Override
    @NotNull
    public String toIdentityString() {
        this.throwExceptionIfClosed();
        return "ChronicleSet{name=" + this.name() + ", file=" + this.file() + ", identityHashCode=" + System.identityHashCode(this) + "}";
    }

    @Override
    public int hashCode() {
        this.throwExceptionIfClosed();
        return this.s.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        this.throwExceptionIfClosed();
        return o == this || this.s.equals(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        this.throwExceptionIfClosed();
        return this.s.containsAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        this.throwExceptionIfClosed();
        return this.s.removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        this.throwExceptionIfClosed();
        return this.s.retainAll(c);
    }

    @Override
    public long longSize() {
        this.throwExceptionIfClosed();
        return this.m.longSize();
    }

    @Override
    public long offHeapMemoryUsed() {
        this.throwExceptionIfClosed();
        return this.m.offHeapMemoryUsed();
    }

    @Override
    public Class<E> keyClass() {
        this.throwExceptionIfClosed();
        return this.m.keyClass();
    }

    @Override
    public Type keyType() {
        this.throwExceptionIfClosed();
        return this.m.keyType();
    }

    @Override
    @NotNull
    public ExternalSetQueryContext<E, ?> queryContext(E key) {
        return (ExternalSetQueryContext)this.m.queryContext(key);
    }

    @Override
    @NotNull
    public ExternalSetQueryContext<E, ?> queryContext(Data<E> key) {
        return (ExternalSetQueryContext)this.m.queryContext(key);
    }

    @Override
    @NotNull
    public ExternalSetQueryContext<E, ?> queryContext(BytesStore keyBytes, long offset, long size) {
        return (ExternalSetQueryContext)this.m.queryContext(keyBytes, offset, size);
    }

    @Override
    public SetSegmentContext<E, ?> segmentContext(int segmentIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int segments() {
        this.throwExceptionIfClosed();
        return this.m.segments();
    }

    @Override
    public boolean forEachEntryWhile(Predicate<? super SetEntry<E>> predicate) {
        this.throwExceptionIfClosed();
        Objects.requireNonNull(predicate);
        return this.m.forEachEntryWhile((? super E e) -> predicate.test((Object)e));
    }

    @Override
    public void forEachEntry(Consumer<? super SetEntry<E>> action) {
        this.throwExceptionIfClosed();
        Objects.requireNonNull(action);
        this.m.forEachEntry((? super E e) -> action.accept((Object)e));
    }

    @Override
    public File file() {
        this.throwExceptionIfClosed();
        return this.m.file();
    }

    @Override
    public String name() {
        this.throwExceptionIfClosed();
        return this.m.name();
    }

    @Override
    public void close() {
        this.m.close();
    }

    @Override
    public boolean isOpen() {
        this.throwExceptionIfClosed();
        return this.m.isOpen();
    }
}

