/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.core.CleaningRandomAccessFile;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public final class CanonicalRandomAccessFiles {
    private static final ConcurrentHashMap<File, RafReference> CANONICAL_RAFS = new ConcurrentHashMap();

    private CanonicalRandomAccessFiles() {
    }

    public static RandomAccessFile acquire(@NotNull File file) throws FileNotFoundException {
        return CANONICAL_RAFS.compute(file, (f, ref) -> {
            if (ref == null) {
                try {
                    return new RafReference((RandomAccessFile)new CleaningRandomAccessFile(f, "rw"));
                }
                catch (FileNotFoundException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
            }
            ((RafReference)ref).refCount++;
            return ref;
        }).raf;
    }

    public static void release(@NotNull File file) throws IOException {
        CANONICAL_RAFS.computeIfPresent(file, (f, ref) -> {
            if (--((RafReference)ref).refCount == 0) {
                try {
                    ((RafReference)ref).raf.close();
                }
                catch (IOException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
                return null;
            }
            return ref;
        });
    }

    private static final class RafReference {
        private final RandomAccessFile raf;
        private int refCount;

        RafReference(@NotNull RandomAccessFile raf) {
            this.raf = raf;
            this.refCount = 1;
        }
    }
}

