/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringSizedReader
implements SizedReader<String>,
StatefulCopyable<StringSizedReader> {
    private transient StringBuilder sb;

    public StringSizedReader() {
        this.initTransients();
    }

    private void initTransients() {
        this.sb = new StringBuilder();
    }

    @Override
    @NotNull
    public String read(@NotNull Bytes in, long size, @Nullable String using) {
        if (0L > size || size > Integer.MAX_VALUE) {
            throw new IllegalStateException("positive int size expected, " + size + " given");
        }
        this.sb.setLength(0);
        BytesUtil.parseUtf8((StreamingDataInput)in, (Appendable)this.sb, (int)((int)size));
        return this.sb.toString();
    }

    @Override
    public StringSizedReader copy() {
        return new StringSizedReader();
    }

    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients();
    }

    public void writeMarshallable(@NotNull WireOut wireOut) {
    }
}

