/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.set;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.set.ChronicleSet;
import net.openhft.chronicle.set.DummyValue;
import net.openhft.chronicle.set.ExternalSetQueryContext;
import net.openhft.chronicle.set.SetEntry;
import net.openhft.chronicle.set.SetSegmentContext;
import org.jetbrains.annotations.NotNull;

class SetFromMap<E>
extends AbstractSet<E>
implements ChronicleSet<E>,
Serializable {
    private final ChronicleMap<E, DummyValue> m;
    private transient Set<E> s;
    private static final long serialVersionUID = 2454657854757543876L;

    SetFromMap(ChronicleMap<E, DummyValue> map) {
        this.m = map;
        this.s = map.keySet();
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.m.remove(o, (Object)DummyValue.DUMMY_VALUE);
    }

    @Override
    public boolean add(E e) {
        return this.m.putIfAbsent(e, DummyValue.DUMMY_VALUE) == null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.s.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.s.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.s.toArray(a);
    }

    @Override
    public String toString() {
        return this.s.toString();
    }

    @Override
    public int hashCode() {
        return this.s.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || this.s.equals(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.s.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.s.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.s.retainAll(c);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.s = this.m.keySet();
    }

    @Override
    public long longSize() {
        return this.m.longSize();
    }

    @Override
    public Class<E> keyClass() {
        return this.m.keyClass();
    }

    @Override
    @NotNull
    public ExternalSetQueryContext<E, ?> queryContext(E key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ExternalSetQueryContext<E, ?> queryContext(Data<E> key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SetSegmentContext<E, ?> segmentContext(int segmentIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int segments() {
        return this.m.segments();
    }

    @Override
    public boolean forEachEntryWhile(Predicate<? super SetEntry<E>> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEachEntry(Consumer<? super SetEntry<E>> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public File file() {
        return this.m.file();
    }

    @Override
    public void close() {
        this.m.close();
    }

    @Override
    public boolean isOpen() {
        return this.m.isOpen();
    }
}

