/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.ReusableBitSet;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.ChecksumEntry;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.HashEntry;
import net.openhft.chronicle.hash.SegmentLock;
import net.openhft.chronicle.hash.impl.BigSegmentHeader;
import net.openhft.chronicle.hash.impl.CompactOffHeapLinearHashTable;
import net.openhft.chronicle.hash.impl.LocalLockState;
import net.openhft.chronicle.hash.impl.SegmentHeader;
import net.openhft.chronicle.hash.impl.TierCountersArea;
import net.openhft.chronicle.hash.impl.VanillaChronicleHash;
import net.openhft.chronicle.hash.impl.stage.entry.Alloc;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumHashing;
import net.openhft.chronicle.hash.impl.stage.entry.ChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.entry.Crc32;
import net.openhft.chronicle.hash.impl.stage.entry.KeyHashCode;
import net.openhft.chronicle.hash.impl.stage.entry.LocksInterface;
import net.openhft.chronicle.hash.impl.stage.entry.NoChecksumStrategy;
import net.openhft.chronicle.hash.impl.stage.hash.ChainingInterface;
import net.openhft.chronicle.hash.locks.InterProcessLock;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.StatefulCopyable;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ExternalMapQueryContext;
import net.openhft.chronicle.map.MapAbsentEntry;
import net.openhft.chronicle.map.MapContext;
import net.openhft.chronicle.map.MapEntry;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.IterationContext;
import net.openhft.chronicle.map.impl.MapAbsentEntryHolder;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.impl.VanillaChronicleMapHolder;
import net.openhft.chronicle.map.impl.ret.InstanceReturnValue;
import net.openhft.chronicle.map.impl.ret.UsableReturnValue;
import net.openhft.chronicle.map.impl.stage.data.ZeroBytesStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledMapQueryContext<K, V, R>
extends ChainingInterface
implements AutoCloseable,
ChecksumEntry,
HashEntry<K>,
SegmentLock,
Alloc,
KeyHashCode,
LocksInterface,
ExternalMapQueryContext<K, V, R>,
MapAbsentEntry<K, V>,
MapContext<K, V, R>,
MapEntry<K, V>,
MapAbsentEntryHolder<K, V>,
QueryContextInterface<K, V, R>,
VanillaChronicleMapHolder<K, V, R> {
    final Thread owner;
    public final int indexInContextChain;
    final DataAccess<V> innerInputValueDataAccess;
    final DataAccess<K> innerInputKeyDataAccess;
    public final ReadLock innerReadLock;
    public static final Logger LOG = LoggerFactory.getLogger(CompiledMapQueryContext.class);
    public final WriteLock innerWriteLock;
    public final SizedReader<K> keyReader;
    public final UpdateLock innerUpdateLock;
    public final SizedReader<V> valueReader;
    public final ChainingInterface rootContextInThisThread;
    final EntryKeyBytesData entryKey;
    final DummyValueZeroData zeroValueData;
    final WrappedValueInstanceDataHolder wrappedValueInstanceValueHolder;
    public final List<ChainingInterface> contextChain;
    public final AcquireHandle acquireHandle;
    public final UsingReturnValue usingReturnValue;
    public final DefaultReturnValue defaultReturnValue;
    public final EntryValueBytesData entryValue;
    private final VanillaChronicleMap<K, V, R> m;
    public final ReusableBitSet freeList;
    final HashKeyCrc32PayloadChecksumStrategy hashKeyCrc32PayloadChecksumStrategy;
    public final PointerBytesStore segmentBS;
    public final ChecksumStrategy checksumStrategy;
    public final Bytes segmentBytes;
    long searchKey = 0L;
    public long searchStartPos;
    private boolean inputKeyDataAccessInitialized = false;
    public int allocatedChunks = 0;
    public long keyOffset = -1L;
    public long keySize = -1L;
    public long valueSizeOffset = -1L;
    private boolean inputValueDataAccessInitialized = false;
    public int segmentIndex = -1;
    public int tier = -1;
    public long tierIndex;
    public long tierBaseAddr;
    long entrySpaceOffset = 0L;
    public long valueSize = -1L;
    public long valueOffset;
    long segmentHeaderAddress;
    SegmentHeader segmentHeader = null;
    boolean used;
    public Data<K> inputKey = null;
    int totalReadLockCount;
    int totalUpdateLockCount;
    int totalWriteLockCount;
    public int latestSameThreadSegmentModCount;
    public int contextModCount;
    public boolean nestedContextsLockedOnSameSegment;
    LocksInterface nextNode;
    LocalLockState localLockState;
    public LocksInterface rootContextLockedOnThisSegment = null;
    public long hashLookupPos = -1L;
    public long keyHash = 0L;
    public long pos = -1L;
    public long keySizeOffset = -1L;
    public int entrySizeInChunks = 0;
    protected SearchState searchState = null;
    private EntryPresence entryPresence = null;

    public boolean readZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.readZero();
    }

    public boolean updateZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.updateZero();
    }

    public boolean writeZeroGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.writeZero();
    }

    public int decrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementUpdate();
    }

    public int decrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.decrementWrite();
    }

    public String debugContextsAndLocksGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.debugContextsAndLocks();
    }

    public Bytes segmentBytesForReadGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForRead();
    }

    public Bytes segmentBytesForWriteGuarded() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBytesForWrite();
    }

    @Override
    public void close() {
        this.closeSegment();
        this.closeLocks();
        this.closePos();
        this.wrappedValueInstanceValueHolder.closeNext();
        this.closeEntrySizeInChunks();
        this.closeInputKey();
        this.closeEntryOffset();
        this.closeKeySearch();
        this.closeSearchKey();
        this.entryKey.closeCachedEntryKey();
        this.closeKeyHash();
        this.closeSegmentHeader();
        this.wrappedValueInstanceValueHolder.closeWrappedData();
        this.closeUsed();
        this.entryValue.closeCachedEntryValue();
        this.usingReturnValue.closeUsingReturnValue();
        this.closeHashLookupPos();
        this.closePresenceOfEntry();
        this.closeValueSize();
        this.closeSegmentTier();
        this.closeSegmentIndex();
        this.closeInputValueDataAccess();
        this.closeKeySize();
        this.wrappedValueInstanceValueHolder.closeValue();
        this.defaultReturnValue.closeDefaultReturnedValue();
        this.closeKeyOffset();
        this.closeAllocatedChunks();
        this.closeValueSizeOffset();
        this.usingReturnValue.closeReturnedValue();
        this.closeInputKeyDataAccess();
        this.closeQuerySegmentStagesDeregisterIterationContextLockedInThisThreadDependants();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
        this.closeQueryHashLookupSearchFoundDependants();
        this.closeQueryHashLookupSearchHlDependants();
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
        this.closeQueryMapEntryStagesKeyEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
        this.closeQuerySegmentStagesRegisterIterationContextLockedInThisThreadDependants();
        this.closeQuerySegmentStagesNextTierDependants();
        this.closeKeySearchSearchStatePresentDependants();
        this.closeQueryMapEntryStagesCountValueSizeOffsetDependants();
        this.closeMapQueryTieredEntryPresentDependants();
        this.closeQuerySegmentStagesHasNextTierDependants();
        this.closeQueryHashLookupSearchAddrDependants();
        this.closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeQueryMapEntryStagesReadExistingEntryDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
        this.closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeQueryMapEntryStagesEntryEndDependants();
        this.closeQuerySegmentStagesTierCountersAreaAddrDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQuerySegmentStagesPrevTierIndexDependants();
        this.innerReadLock.closeReadLockLockDependants();
        this.closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants();
        this.closeQueryMapEntryStagesEntrySizeDependants();
    }

    public void incrementModCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementModCount();
    }

    public void incrementReadGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementRead();
    }

    public void incrementUpdateGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementUpdate();
    }

    public void incrementWriteGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.incrementWrite();
    }

    public void readUnlockAndDecrementCountGuarded() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.readUnlockAndDecrementCount();
    }

    public void setHashLookupPosGuarded(long hashLookupPos) {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        this.setHashLookupPos(hashLookupPos);
    }

    public void setLocalLockStateGuarded(LocalLockState newState) {
        if (!this.locksInit()) {
            this.initLocks();
        }
        this.setLocalLockState(newState);
    }

    public void setSearchStateGuarded(SearchState newSearchState) {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        this.setSearchState(newSearchState);
    }

    void keyFound() {
        this.searchState = SearchState.PRESENT;
    }

    public CompiledMapQueryContext(ChainingInterface c, VanillaChronicleMap<K, V, R> m) {
        this.contextChain = c.getContextChain();
        this.indexInContextChain = this.contextChain.size();
        this.contextChain.add(this);
        this.rootContextInThisThread = c;
        this.m = m;
        this.innerInputValueDataAccess = (DataAccess)this.m().valueDataAccess.copy();
        this.defaultReturnValue = new DefaultReturnValue();
        this.owner = Thread.currentThread();
        this.wrappedValueInstanceValueHolder = new WrappedValueInstanceDataHolder();
        this.zeroValueData = new DummyValueZeroData();
        this.entryKey = new EntryKeyBytesData();
        this.usingReturnValue = new UsingReturnValue();
        this.valueReader = StatefulCopyable.copyIfNeeded(this.m().valueReader);
        this.acquireHandle = new AcquireHandle();
        this.entryValue = new EntryValueBytesData();
        this.hashKeyCrc32PayloadChecksumStrategy = new HashKeyCrc32PayloadChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashKeyCrc32PayloadChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerReadLock = new ReadLock();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.innerInputKeyDataAccess = (DataAccess)this.h().keyDataAccess.copy();
        this.innerWriteLock = new WriteLock();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes((BytesStore)this.segmentBS);
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegment, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.innerUpdateLock = new UpdateLock();
    }

    public CompiledMapQueryContext(VanillaChronicleMap<K, V, R> m) {
        this.contextChain = new ArrayList<ChainingInterface>();
        this.contextChain.add(this);
        this.indexInContextChain = 0;
        this.rootContextInThisThread = this;
        this.m = m;
        this.innerInputValueDataAccess = (DataAccess)this.m().valueDataAccess.copy();
        this.defaultReturnValue = new DefaultReturnValue();
        this.owner = Thread.currentThread();
        this.wrappedValueInstanceValueHolder = new WrappedValueInstanceDataHolder();
        this.zeroValueData = new DummyValueZeroData();
        this.entryKey = new EntryKeyBytesData();
        this.usingReturnValue = new UsingReturnValue();
        this.valueReader = StatefulCopyable.copyIfNeeded(this.m().valueReader);
        this.acquireHandle = new AcquireHandle();
        this.entryValue = new EntryValueBytesData();
        this.hashKeyCrc32PayloadChecksumStrategy = new HashKeyCrc32PayloadChecksumStrategy();
        this.checksumStrategy = this.h().checksumEntries ? this.hashKeyCrc32PayloadChecksumStrategy : NoChecksumStrategy.INSTANCE;
        this.innerReadLock = new ReadLock();
        this.keyReader = StatefulCopyable.copyIfNeeded(this.h().keyReader);
        this.innerInputKeyDataAccess = (DataAccess)this.h().keyDataAccess.copy();
        this.innerWriteLock = new WriteLock();
        this.segmentBS = new PointerBytesStore();
        this.segmentBytes = new VanillaBytes((BytesStore)this.segmentBS);
        this.freeList = new ReusableBitSet((BitSetFrame)new SingleThreadedFlatBitSetFrame(MemoryUnit.LONGS.align(this.h().actualChunksPerSegment, MemoryUnit.BITS)), Access.nativeAccess(), null, 0L);
        this.innerUpdateLock = new UpdateLock();
    }

    boolean tryFindInitLocksOfThisSegment(int index) {
        LocksInterface c = (LocksInterface)this.contextAtIndexInChain(index);
        if (c.segmentHeaderInit() && c.segmentHeaderAddress() == this.segmentHeaderAddress() && c.locksInit()) {
            LocksInterface root;
            this.rootContextLockedOnThisSegment = root = c.rootContextLockedOnThisSegment();
            root.setNestedContextsLockedOnSameSegment(true);
            this.nestedContextsLockedOnSameSegment = true;
            this.contextModCount = root.latestSameThreadSegmentModCount();
            this.linkToSegmentContextsChain();
            return true;
        }
        return false;
    }

    @Override
    public int changeAndGetLatestSameThreadSegmentModCount(int change) {
        return this.latestSameThreadSegmentModCount += change;
    }

    @Override
    public int changeAndGetTotalReadLockCount(int change) {
        return this.totalReadLockCount += change;
    }

    @Override
    public int changeAndGetTotalUpdateLockCount(int change) {
        return this.totalUpdateLockCount += change;
    }

    @Override
    public int changeAndGetTotalWriteLockCount(int change) {
        return this.totalWriteLockCount += change;
    }

    public int decrementRead() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(-1);
    }

    public int decrementUpdate() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(-1);
    }

    public int decrementWrite() {
        return this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(-1);
    }

    private void _AllocatedChunks_incrementSegmentEntriesIfNeeded() {
    }

    private void _CheckOnEachPublicOperation_checkOnEachPublicOperation() {
        this.checkAccessingFromOwnerThread();
        if (!this.h().isOpen()) {
            throw new IllegalStateException("Access to Chronicle Hash after close()");
        }
    }

    private void _MapEntryStages_putValueDeletedEntry(Data<V> newValue) {
        throw new AssertionError((Object)"putValueDeletedEntry() might be called only from non-Replicated Map query context");
    }

    public void incrementModCount() {
        this.contextModCount = this.rootContextLockedOnThisSegment.changeAndGetLatestSameThreadSegmentModCount(1);
    }

    public void incrementRead() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalReadLockCount(1);
    }

    public void incrementUpdate() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalUpdateLockCount(1);
    }

    public void incrementWrite() {
        this.rootContextLockedOnThisSegment.changeAndGetTotalWriteLockCount(1);
    }

    public void readUnlockAndDecrementCount() {
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                int newTotalReadLockCount = this.decrementRead();
                if (newTotalReadLockCount == 0) {
                    if (this.updateZero() && this.writeZero()) {
                        this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                    }
                } else assert (newTotalReadLockCount > 0) : "read underflow";
                return;
            }
            case UPDATE_LOCKED: {
                int newTotalUpdateLockCount = this.decrementUpdate();
                if (newTotalUpdateLockCount == 0) {
                    if (this.writeZero()) {
                        if (this.readZero()) {
                            this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                        } else {
                            this.segmentHeader().downgradeUpdateToReadLock(this.segmentHeaderAddress());
                        }
                    }
                } else assert (newTotalUpdateLockCount > 0) : "update underflow";
                return;
            }
            case WRITE_LOCKED: {
                int newTotalWriteLockCount = this.decrementWrite();
                if (newTotalWriteLockCount == 0) {
                    if (!this.updateZero()) {
                        this.segmentHeader().downgradeWriteToUpdateLock(this.segmentHeaderAddress());
                        break;
                    }
                    if (!this.readZero()) {
                        this.segmentHeader().downgradeWriteToReadLock(this.segmentHeaderAddress());
                        break;
                    }
                    this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
                    break;
                }
                assert (newTotalWriteLockCount > 0) : "write underflow";
                break;
            }
        }
    }

    public void setHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
    }

    public void setLocalLockState(LocalLockState newState) {
        boolean goingToLock;
        boolean isLocked = this.localLockState != LocalLockState.UNLOCKED && this.localLockState != null;
        boolean bl = goingToLock = newState != LocalLockState.UNLOCKED && newState != null;
        if (isLocked) {
            if (!goingToLock) {
                this.deregisterIterationContextLockedInThisThread();
            }
        } else if (goingToLock) {
            this.registerIterationContextLockedInThisThread();
        }
        this.localLockState = newState;
    }

    @Override
    public void setNestedContextsLockedOnSameSegment(boolean nestedContextsLockedOnSameSegment) {
        this.nestedContextsLockedOnSameSegment = nestedContextsLockedOnSameSegment;
    }

    @Override
    public void setNextNode(LocksInterface nextNode) {
        this.nextNode = nextNode;
    }

    public void setSearchState(SearchState newSearchState) {
        this.searchState = newSearchState;
    }

    public Thread owner() {
        return this.owner;
    }

    public Bytes segmentBytesForRead() {
        this.segmentBytes.readLimit(this.segmentBytes.capacity());
        return this.segmentBytes;
    }

    public Bytes segmentBytesForWrite() {
        this.segmentBytes.readPosition(0L);
        return this.segmentBytes;
    }

    private void closeNestedLocks() {
        this.unlinkFromSegmentContextsChain();
        this.readUnlockAndDecrementCount();
    }

    private void closeRootLocks() {
        this.verifyInnermostContext();
        switch (this.localLockState) {
            case UNLOCKED: {
                return;
            }
            case READ_LOCKED: {
                this.segmentHeader().readUnlock(this.segmentHeaderAddress());
                return;
            }
            case UPDATE_LOCKED: {
                this.segmentHeader().updateUnlock(this.segmentHeaderAddress());
                return;
            }
            case WRITE_LOCKED: {
                this.segmentHeader().writeUnlock(this.segmentHeaderAddress());
            }
        }
    }

    private void linkToSegmentContextsChain() {
        LocksInterface innermostContextOnThisSegment = this.rootContextLockedOnThisSegment;
        while (true) {
            this.checkNestedContextsQueryDifferentKeys(innermostContextOnThisSegment);
            if (innermostContextOnThisSegment.nextNode() == null) break;
            innermostContextOnThisSegment = innermostContextOnThisSegment.nextNode();
        }
        innermostContextOnThisSegment.setNextNode(this);
    }

    private void unlinkFromSegmentContextsChain() {
        LocksInterface prevContext = this.rootContextLockedOnThisSegment;
        while (true) {
            assert (prevContext.nextNode() != null);
            if (prevContext.nextNode() == this) break;
            prevContext = prevContext.nextNode();
        }
        this.verifyInnermostContext();
        prevContext.setNextNode(null);
    }

    private void verifyInnermostContext() {
        if (this.nextNode != null) {
            throw new IllegalStateException("Attempt to close contexts not structurally");
        }
    }

    public String debugContextsAndLocks() {
        String message = "";
        message = message + "Contexts locked on this segment:\n";
        for (LocksInterface cxt = this.rootContextLockedOnThisSegment; cxt != null; cxt = cxt.nextNode()) {
            message = message + cxt.debugLocksState() + "\n";
        }
        message = message + "Current thread contexts:\n";
        int size = this.contextChain.size();
        for (int i = 0; i < size; ++i) {
            LocksInterface cxt = (LocksInterface)this.contextAtIndexInChain(i);
            message = message + cxt.debugLocksState() + "\n";
        }
        return message;
    }

    public boolean readZero() {
        return this.rootContextLockedOnThisSegment.totalReadLockCount() == 0;
    }

    public boolean updateZero() {
        return this.rootContextLockedOnThisSegment.totalUpdateLockCount() == 0;
    }

    public boolean writeZero() {
        return this.rootContextLockedOnThisSegment.totalWriteLockCount() == 0;
    }

    private long _HashEntryStages_entryEnd() {
        return this.keyEnd();
    }

    public int indexInContextChain() {
        return this.indexInContextChain;
    }

    public DataAccess<K> innerInputKeyDataAccess() {
        return this.innerInputKeyDataAccess;
    }

    public DataAccess<V> innerInputValueDataAccess() {
        return this.innerInputValueDataAccess;
    }

    public ReadLock innerReadLock() {
        return this.innerReadLock;
    }

    public WriteLock innerWriteLock() {
        return this.innerWriteLock;
    }

    public Logger LOG() {
        return LOG;
    }

    public SizedReader<V> valueReader() {
        return this.valueReader;
    }

    public UpdateLock innerUpdateLock() {
        return this.innerUpdateLock;
    }

    public SizedReader<K> keyReader() {
        return this.keyReader;
    }

    public EntryKeyBytesData entryKey() {
        return this.entryKey;
    }

    public ChainingInterface rootContextInThisThread() {
        return this.rootContextInThisThread;
    }

    public DummyValueZeroData zeroValueData() {
        return this.zeroValueData;
    }

    public WrappedValueInstanceDataHolder wrappedValueInstanceValueHolder() {
        return this.wrappedValueInstanceValueHolder;
    }

    public UsingReturnValue usingReturnValue() {
        return this.usingReturnValue;
    }

    @Override
    public AcquireHandle acquireHandle() {
        return this.acquireHandle;
    }

    public List<ChainingInterface> contextChain() {
        return this.contextChain;
    }

    public DefaultReturnValue defaultReturnValue() {
        return this.defaultReturnValue;
    }

    public EntryValueBytesData entryValue() {
        return this.entryValue;
    }

    public HashKeyCrc32PayloadChecksumStrategy hashKeyCrc32PayloadChecksumStrategy() {
        return this.hashKeyCrc32PayloadChecksumStrategy;
    }

    public ChecksumStrategy checksumStrategy() {
        return this.checksumStrategy;
    }

    public Bytes segmentBytes() {
        return this.segmentBytes;
    }

    @Override
    public boolean checkSum() {
        return this.checksumStrategy.checkSum();
    }

    public <T> T contextAtIndexInChain(int index) {
        return (T)this.contextChain.get(index);
    }

    public void closeVanillaChronicleMapHolderImplContextAtIndexInChainDependants() {
        this.closeLocks();
    }

    @Override
    public <T extends ChainingInterface> T getContext(Class<? extends T> contextClass, Function<ChainingInterface, T> createChaining) {
        ChainingInterface context2;
        for (ChainingInterface context2 : this.contextChain) {
            if (context2.getClass() != contextClass || context2.usedInit()) continue;
            context2.initUsed(true);
            return (T)context2;
        }
        int maxNestedContexts = 1024;
        if (this.contextChain.size() > maxNestedContexts) {
            throw new IllegalStateException("More than " + maxNestedContexts + " nested ChronicleHash contexts are not supported. Very probable that " + "you simply forgot to close context somewhere (recommended to use " + "try-with-resources statement). " + "Otherwise this is a bug, please report with this " + "stack trace on https://github.com/OpenHFT/Chronicle-Map/issues");
        }
        context2 = (ChainingInterface)createChaining.apply(this);
        context2.initUsed(true);
        return (T)context2;
    }

    @Override
    public DataAccess<K> inputKeyDataAccess() {
        this.initInputKeyDataAccess();
        return this.innerInputKeyDataAccess;
    }

    public void checkIterationContextNotLockedInThisThread() {
        if (this.rootContextInThisThread.iterationContextLockedInThisThread) {
            throw new IllegalStateException("Update or Write locking is forbidden in the contextof locked iteration context");
        }
    }

    public void checkAccessingFromOwnerThread() {
        if (this.owner != Thread.currentThread()) {
            throw new ConcurrentModificationException("Context shouldn't be accessed from multiple threads");
        }
    }

    public void closeOwnerThreadHolderCheckAccessingFromOwnerThreadDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    @Override
    public MapAbsentEntry<K, V> absent() {
        return this;
    }

    @Override
    public VanillaChronicleMap<K, V, R> m() {
        return this.m;
    }

    @Override
    public ChronicleMap<K, V> map() {
        return this.m();
    }

    @Override
    public DataAccess<V> inputValueDataAccess() {
        this.initInputValueDataAccess();
        return this.innerInputValueDataAccess;
    }

    public long newEntrySize(Data<V> newValue, long entryStartOffset, long newValueOffset) {
        return this.checksumStrategy.extraEntryBytes() + newValueOffset + newValue.size() - entryStartOffset;
    }

    private void registerIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = true;
        }
    }

    public void closeQuerySegmentStagesRegisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public CompactOffHeapLinearHashTable hl() {
        return this.h().hashLookup;
    }

    public void closeQueryHashLookupSearchHlDependants() {
        this.closeSearchKey();
        this.closeQueryHashLookupSearchFoundDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public boolean searchKeyInit() {
        return this.searchKey != 0L;
    }

    void initSearchKey() {
        this.initSearchKey(this.hl().maskUnsetKey(this.h().hashSplitting.segmentHash(this.keyHashCode())));
        this.closeSearchKeyDependants();
    }

    public void initSearchKey(long searchKey) {
        this.searchKey = searchKey;
        this.searchStartPos = this.hl().hlPos(searchKey);
        this.closeSearchKeyDependants();
    }

    public long searchKey() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchKey;
    }

    public long searchStartPos() {
        if (!this.searchKeyInit()) {
            this.initSearchKey();
        }
        return this.searchStartPos;
    }

    public void closeSearchKey() {
        if (!this.searchKeyInit()) {
            return;
        }
        this.closeSearchKeyDependants();
        this.searchKey = 0L;
    }

    public void closeSearchKeyDependants() {
        this.closeHashLookupPos();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    long sizeOfEverythingBeforeValue(long keySize, long valueSize) {
        return (long)this.m().keySizeMarshaller.storingLength(keySize) + keySize + (long)this.m().valueSizeMarshaller.storingLength(valueSize);
    }

    public long innerEntrySize(long sizeOfEverythingBeforeValue, long valueSize) {
        long sizeWithoutChecksum = this.m().constantlySizedEntry ? VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue + valueSize, this.m().alignment) : (this.m().couldNotDetermineAlignmentBeforeAllocation ? sizeOfEverythingBeforeValue + (long)this.m().worstAlignment + valueSize : VanillaChronicleMap.alignAddr(sizeOfEverythingBeforeValue, this.m().alignment) + valueSize);
        return sizeWithoutChecksum + this.checksumStrategy.extraEntryBytes();
    }

    public final long entrySize(long keySize, long valueSize) {
        long sizeOfEverythingBeforeValue = this.sizeOfEverythingBeforeValue(keySize, valueSize);
        return this.innerEntrySize(sizeOfEverythingBeforeValue, valueSize);
    }

    @Override
    public List<ChainingInterface> getContextChain() {
        return this.contextChain;
    }

    @Override
    public void updateChecksum() {
        this.checksumStrategy.updateChecksum();
    }

    private void deregisterIterationContextLockedInThisThread() {
        if (this instanceof IterationContext) {
            this.rootContextInThisThread.iterationContextLockedInThisThread = false;
        }
    }

    public void closeQuerySegmentStagesDeregisterIterationContextLockedInThisThreadDependants() {
        this.closeLocks();
    }

    public boolean inputKeyDataAccessInit() {
        return this.inputKeyDataAccessInitialized;
    }

    void initInputKeyDataAccess() {
        this.inputKeyDataAccessInitialized = true;
    }

    void closeInputKeyDataAccess() {
        if (!this.inputKeyDataAccessInit()) {
            return;
        }
        this.innerInputKeyDataAccess.uninit();
        this.inputKeyDataAccessInitialized = false;
    }

    public boolean allocatedChunksInit() {
        return this.allocatedChunks != 0;
    }

    public void initAllocatedChunks(int allocatedChunks) {
        this.allocatedChunks = allocatedChunks;
    }

    public int allocatedChunks() {
        assert (this.allocatedChunksInit()) : "AllocatedChunks should be init";
        return this.allocatedChunks;
    }

    public void closeAllocatedChunks() {
        if (!this.allocatedChunksInit()) {
            return;
        }
        this.allocatedChunks = 0;
    }

    public boolean keyOffsetInit() {
        return this.keyOffset != -1L;
    }

    public void initKeyOffset(long keyOffset) {
        this.keyOffset = keyOffset;
        this.closeKeyOffsetDependants();
    }

    public long keyOffset() {
        assert (this.keyOffsetInit()) : "KeyOffset should be init";
        return this.keyOffset;
    }

    public void closeKeyOffset() {
        if (!this.keyOffsetInit()) {
            return;
        }
        this.closeKeyOffsetDependants();
        this.keyOffset = -1L;
    }

    public void closeKeyOffsetDependants() {
        this.closeQueryMapEntryStagesKeyEndDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public boolean keySizeInit() {
        return this.keySize != -1L;
    }

    public void initKeySize(long keySize) {
        this.keySize = keySize;
        this.closeKeySizeDependants();
    }

    public long keySize() {
        assert (this.keySizeInit()) : "KeySize should be init";
        return this.keySize;
    }

    public void closeKeySize() {
        if (!this.keySizeInit()) {
            return;
        }
        this.closeKeySizeDependants();
        this.keySize = -1L;
    }

    public void closeKeySizeDependants() {
        this.closeQueryMapEntryStagesKeyEndDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    public long keyEnd() {
        return this.keyOffset() + this.keySize();
    }

    public void closeQueryMapEntryStagesKeyEndDependants() {
        this.closeQueryMapEntryStagesCountValueSizeOffsetDependants();
        this.closeQueryMapEntryStagesEntryEndDependants();
    }

    long countValueSizeOffset() {
        return this.keyEnd();
    }

    public void closeQueryMapEntryStagesCountValueSizeOffsetDependants() {
        this.closeValueSizeOffset();
    }

    public boolean valueSizeOffsetInit() {
        return this.valueSizeOffset != -1L;
    }

    void initValueSizeOffset() {
        this.valueSizeOffset = this.countValueSizeOffset();
        this.closeValueSizeOffsetDependants();
    }

    public long valueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            this.initValueSizeOffset();
        }
        return this.valueSizeOffset;
    }

    public void closeValueSizeOffset() {
        if (!this.valueSizeOffsetInit()) {
            return;
        }
        this.closeValueSizeOffsetDependants();
        this.valueSizeOffset = -1L;
    }

    public void closeValueSizeOffsetDependants() {
        this.closeValueSize();
    }

    public boolean inputValueDataAccessInit() {
        return this.inputValueDataAccessInitialized;
    }

    void initInputValueDataAccess() {
        this.inputValueDataAccessInitialized = true;
    }

    void closeInputValueDataAccess() {
        if (!this.inputValueDataAccessInit()) {
            return;
        }
        this.innerInputValueDataAccess.uninit();
        this.inputValueDataAccessInitialized = false;
    }

    @Override
    public boolean segmentIndexInit() {
        return this.segmentIndex >= 0;
    }

    void initSegmentIndex() {
        this.segmentIndex = this.h().hashSplitting.segmentIndex(this.keyHashCode());
        this.closeSegmentIndexDependants();
    }

    @Override
    public void initSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
        this.closeSegmentIndexDependants();
    }

    @Override
    public int segmentIndex() {
        if (!this.segmentIndexInit()) {
            this.initSegmentIndex();
        }
        return this.segmentIndex;
    }

    public void closeSegmentIndex() {
        if (!this.segmentIndexInit()) {
            return;
        }
        this.closeSegmentIndexDependants();
        this.segmentIndex = -1;
    }

    public void closeSegmentIndexDependants() {
        this.closeSegmentTier();
        this.closeQuerySegmentStagesNextTierDependants();
        this.closeSegmentHeader();
    }

    public boolean segmentTierInit() {
        return this.tier >= 0;
    }

    public void initSegmentTier() {
        this.tierIndex = this.segmentIndex() + 1;
        this.tierBaseAddr = this.h().segmentBaseAddr(this.segmentIndex());
        this.tier = 0;
        this.closeSegmentTierDependants();
    }

    public void initSegmentTier(int tier, long tierIndex, long tierBaseAddr) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        this.tierBaseAddr = tierBaseAddr;
        this.closeSegmentTierDependants();
    }

    private void initSegmentTier(int tier, long tierIndex) {
        this.tier = tier;
        this.tierIndex = tierIndex;
        assert (tierIndex > 0L);
        this.tierBaseAddr = this.h().tierIndexToBaseAddr(tierIndex);
        this.closeSegmentTierDependants();
    }

    public int tier() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tier;
    }

    public long tierBaseAddr() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierBaseAddr;
    }

    public long tierIndex() {
        if (!this.segmentTierInit()) {
            this.initSegmentTier();
        }
        return this.tierIndex;
    }

    public void closeSegmentTier() {
        if (!this.segmentTierInit()) {
            return;
        }
        this.closeSegmentTierDependants();
        this.tier = -1;
    }

    public void closeSegmentTierDependants() {
        this.closeQueryHashLookupSearchAddrDependants();
        this.closeQuerySegmentStagesTierCountersAreaAddrDependants();
        this.closeQuerySegmentStagesNextTierDependants();
        this.closeHashLookupPos();
        this.closeSegment();
        this.closeMapQueryTieredEntryPresentDependants();
    }

    private long addr() {
        return this.tierBaseAddr();
    }

    public void closeQueryHashLookupSearchAddrDependants() {
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public long tierCountersAreaAddr() {
        return this.tierBaseAddr() + this.h().tierHashLookupOuterSize;
    }

    public void closeQuerySegmentStagesTierCountersAreaAddrDependants() {
        this.closeQuerySegmentStagesPrevTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
        this.closeQuerySegmentStagesNextTierIndexDependants();
    }

    public long prevTierIndex() {
        return TierCountersArea.prevTierIndex(this.tierCountersAreaAddr());
    }

    public void prevTierIndex(long prevTierIndex) {
        TierCountersArea.prevTierIndex(this.tierCountersAreaAddr(), prevTierIndex);
    }

    public void closeQuerySegmentStagesPrevTierIndexDependants() {
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public long nextPosToSearchFromTiered() {
        return TierCountersArea.nextPosToSearchFromTiered(this.tierCountersAreaAddr());
    }

    public void nextPosToSearchFromTiered(long nextPosToSearchFrom) {
        TierCountersArea.nextPosToSearchFromTiered(this.tierCountersAreaAddr(), nextPosToSearchFrom);
    }

    public long nextTierIndex() {
        return TierCountersArea.nextTierIndex(this.tierCountersAreaAddr());
    }

    public void closeQuerySegmentStagesNextTierIndexDependants() {
        this.closeQuerySegmentStagesHasNextTierDependants();
        this.closeQuerySegmentStagesNextTierDependants();
    }

    public boolean hasNextTier() {
        return this.nextTierIndex() != 0L;
    }

    public void closeQuerySegmentStagesHasNextTierDependants() {
        this.closeMapQueryTieredEntryPresentDependants();
    }

    public void nextTierIndex(long nextTierIndex) {
        TierCountersArea.nextTierIndex(this.tierCountersAreaAddr(), nextTierIndex);
    }

    public void nextTier() {
        VanillaChronicleHash h = this.h();
        long nextTierIndex = this.nextTierIndex();
        if (nextTierIndex == 0L) {
            nextTierIndex = h.allocateTier(this.segmentIndex(), this.tier() + 1);
            this.nextTierIndex(nextTierIndex);
            long currentTierIndex = this.tierIndex();
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
            this.prevTierIndex(currentTierIndex);
        } else {
            this.initSegmentTier(this.tier() + 1, nextTierIndex);
        }
    }

    public void closeQuerySegmentStagesNextTierDependants() {
        this.closeMapQueryTieredEntryPresentDependants();
    }

    public void goToLastTier() {
        while (this.hasNextTier()) {
            this.nextTier();
        }
    }

    boolean segmentInit() {
        return this.entrySpaceOffset > 0L;
    }

    void initSegment() {
        VanillaChronicleHash h = this.h();
        long segmentBaseAddr = this.tierBaseAddr();
        this.segmentBS.set(segmentBaseAddr, h.tierSize);
        this.segmentBytes.clear();
        long freeListOffset = h.tierHashLookupOuterSize + 64L;
        this.freeList.setOffset(segmentBaseAddr + freeListOffset);
        this.entrySpaceOffset = freeListOffset + h.tierFreeListOuterSize + (long)h.tierEntrySpaceInnerOffset;
        this.closeSegmentDependants();
    }

    public long entrySpaceOffset() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.entrySpaceOffset;
    }

    public ReusableBitSet freeList() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.freeList;
    }

    public PointerBytesStore segmentBS() {
        if (!this.segmentInit()) {
            this.initSegment();
        }
        return this.segmentBS;
    }

    void closeSegment() {
        if (!this.segmentInit()) {
            return;
        }
        this.closeSegmentDependants();
        this.entrySpaceOffset = 0L;
    }

    public void closeSegmentDependants() {
        this.closeValueSize();
        this.closeKeySearchKeyEqualsDependants();
        this.closeEntryOffset();
        this.closeQueryMapEntryStagesReadExistingEntryDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
        this.entryKey.closeEntryKeyBytesDataInnerGetUsingDependants();
    }

    public boolean valueSizeInit() {
        return this.valueSize != -1L;
    }

    void initValueSize() {
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.valueSizeOffset());
        this.valueSize = this.m().readValueSize(segmentBytes);
        long currentPosition = segmentBytes.readPosition();
        long currentAddr = segmentBytes.address(currentPosition);
        long skip = VanillaChronicleMap.alignAddr(currentAddr, this.m().alignment) - currentAddr;
        if (skip > 0L) {
            segmentBytes.readSkip(skip);
        }
        this.valueOffset = segmentBytes.readPosition();
        this.closeValueSizeDependants();
    }

    void initValueSize(long valueSize) {
        this.valueSize = valueSize;
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.valueSizeOffset());
        this.m().valueSizeMarshaller.writeSize(segmentBytes, valueSize);
        long currentPosition = segmentBytes.writePosition();
        long currentAddr = segmentBytes.address(currentPosition);
        long skip = VanillaChronicleMap.alignAddr(currentAddr, this.m().alignment) - currentAddr;
        if (skip > 0L) {
            segmentBytes.writeSkip(skip);
        }
        this.valueOffset = segmentBytes.writePosition();
        this.closeValueSizeDependants();
    }

    void initValueSize_EqualToOld(long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        this.valueSize = oldValueSize;
        this.valueOffset = this.valueSizeOffset() + (oldValueOffset - oldValueSizeOffset);
        this.closeValueSizeDependants();
    }

    public long valueOffset() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueOffset;
    }

    public long valueSize() {
        if (!this.valueSizeInit()) {
            this.initValueSize();
        }
        return this.valueSize;
    }

    public void closeValueSize() {
        if (!this.valueSizeInit()) {
            return;
        }
        this.closeValueSizeDependants();
        this.valueSize = -1L;
    }

    public void closeValueSizeDependants() {
        this.closeQueryMapEntryStagesEntryEndDependants();
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryValue.closeEntryValueBytesDataInnerGetUsingDependants();
    }

    protected long entryEnd() {
        return this.valueOffset() + this.valueSize();
    }

    public void closeQueryMapEntryStagesEntryEndDependants() {
        this.closeQueryMapEntryStagesEntrySizeDependants();
    }

    public void writeValue(Data<?> value) {
        RandomDataInput valueBytes = value.bytes();
        if (valueBytes instanceof NativeBytesStore && valueBytes.address(value.offset()) == this.segmentBS().address(this.valueOffset())) {
            return;
        }
        value.writeTo((RandomDataOutput)this.segmentBS(), this.valueOffset());
    }

    public void initValue_WithoutSize(Data<?> value, long oldValueSizeOffset, long oldValueSize, long oldValueOffset) {
        assert (oldValueSize == value.size());
        this.initValueSize_EqualToOld(oldValueSizeOffset, oldValueSize, oldValueOffset);
        this.writeValue(value);
    }

    public void initValue(Data<?> value) {
        this.initValueSize(value.size());
        this.writeValue(value);
    }

    public void prevTier() {
        if (this.tier() == 0) {
            throw new IllegalStateException("first tier doesn't have previous");
        }
        this.initSegmentTier(this.tier() - 1, this.prevTierIndex());
    }

    public void goToFirstTier() {
        while (this.tier() != 0) {
            this.prevTier();
        }
    }

    @Override
    public boolean segmentHeaderInit() {
        return this.segmentHeader != null;
    }

    private void initSegmentHeader() {
        this.segmentHeaderAddress = this.h().segmentHeaderAddress(this.segmentIndex());
        this.segmentHeader = BigSegmentHeader.INSTANCE;
        this.closeSegmentHeaderDependants();
    }

    @Override
    public long segmentHeaderAddress() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeaderAddress;
    }

    public SegmentHeader segmentHeader() {
        if (!this.segmentHeaderInit()) {
            this.initSegmentHeader();
        }
        return this.segmentHeader;
    }

    public void closeSegmentHeader() {
        if (!this.segmentHeaderInit()) {
            return;
        }
        this.closeSegmentHeaderDependants();
        this.segmentHeader = null;
    }

    public void closeSegmentHeaderDependants() {
        this.closeLocks();
        this.innerReadLock.closeReadLockLockDependants();
    }

    long nextPosToSearchFrom() {
        if (this.tier() == 0) {
            return this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress());
        }
        return this.nextPosToSearchFromTiered();
    }

    public void nextPosToSearchFrom(long nextPosToSearchFrom) {
        if (this.tier() == 0) {
            this.segmentHeader().nextPosToSearchFrom(this.segmentHeaderAddress(), nextPosToSearchFrom);
        } else {
            this.nextPosToSearchFromTiered(nextPosToSearchFrom);
        }
    }

    public void updateNextPosToSearchFrom(long allocated, int chunks) {
        long nextPosToSearchFrom = allocated + (long)chunks;
        if (nextPosToSearchFrom >= this.h().actualChunksPerSegment) {
            nextPosToSearchFrom = 0L;
        }
        this.nextPosToSearchFrom(nextPosToSearchFrom);
    }

    public long allocReturnCode(int chunks) {
        VanillaChronicleHash h = this.h();
        if (chunks > h.maxChunksPerEntry) {
            throw new IllegalArgumentException("Entry is too large: requires " + chunks + " chucks, " + h.maxChunksPerEntry + " is maximum.");
        }
        long ret = this.freeList().setNextNContinuousClearBits(this.nextPosToSearchFrom(), chunks);
        if (ret == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
            if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                this.freeList().clearRange(ret, h.actualChunksPerSegment);
            }
            if ((ret = this.freeList().setNextNContinuousClearBits(0L, chunks)) == -1L || ret + (long)chunks > h.actualChunksPerSegment) {
                if (ret != -1L && ret + (long)chunks > h.actualChunksPerSegment && ret < h.actualChunksPerSegment) {
                    this.freeList().clearRange(ret, h.actualChunksPerSegment);
                }
                return -1L;
            }
            this.updateNextPosToSearchFrom(ret, chunks);
        } else if (chunks == 1 || this.freeList().isSet(this.nextPosToSearchFrom())) {
            this.updateNextPosToSearchFrom(ret, chunks);
        }
        return ret;
    }

    public void free(long fromPos, int chunks) {
        this.freeList().clearRange(fromPos, fromPos + (long)chunks);
        if (fromPos < this.nextPosToSearchFrom()) {
            this.nextPosToSearchFrom(fromPos);
        }
    }

    @Override
    public long alloc(int chunks, long prevPos, int prevChunks) {
        long ret = this.allocReturnCode(chunks);
        if (prevPos >= 0L) {
            this.free(prevPos, prevChunks);
        }
        if (ret >= 0L) {
            return ret;
        }
        int alreadyAttemptedTier = this.tier();
        this.goToFirstTier();
        while (this.tier() == alreadyAttemptedTier || (ret = this.allocReturnCode(chunks)) < 0L) {
            this.nextTier();
        }
        return ret;
    }

    public void entries(long size) {
        this.segmentHeader().size(this.segmentHeaderAddress(), size);
    }

    public long entries() {
        return this.segmentHeader().size(this.segmentHeaderAddress());
    }

    public void deleted(long deleted) {
        this.segmentHeader().deleted(this.segmentHeaderAddress(), deleted);
    }

    public long deleted() {
        return this.segmentHeader().deleted(this.segmentHeaderAddress());
    }

    public long size() {
        return this.entries() - this.deleted();
    }

    @Override
    public boolean usedInit() {
        return this.used;
    }

    @Override
    public void initUsed(boolean used) {
        this.used = used;
    }

    void closeUsed() {
        if (!this.usedInit()) {
            return;
        }
        this.used = false;
    }

    boolean inputKeyInit() {
        return this.inputKey != null;
    }

    @Override
    public void initInputKey(Data<K> inputKey) {
        this.inputKey = inputKey;
        this.closeInputKeyDependants();
    }

    public Data<K> inputKey() {
        assert (this.inputKeyInit()) : "InputKey should be init";
        return this.inputKey;
    }

    public void closeInputKey() {
        if (!this.inputKeyInit()) {
            return;
        }
        this.closeInputKeyDependants();
        this.inputKey = null;
    }

    public void closeInputKeyDependants() {
        this.closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants();
        this.closeKeySearchKeyEqualsDependants();
        this.closeKeyHash();
    }

    public void checkNestedContextsQueryDifferentKeys(LocksInterface innermostContextOnThisSegment) {
        Data<K> key;
        if (innermostContextOnThisSegment.getClass() == this.getClass() && Objects.equals(key = ((CompiledMapQueryContext)innermostContextOnThisSegment).inputKey(), this.inputKey())) {
            throw new IllegalStateException("Nested same-thread contexts cannot access the same key " + key);
        }
    }

    public void closeQuerySegmentStagesCheckNestedContextsQueryDifferentKeysDependants() {
        this.closeLocks();
    }

    @Override
    public boolean locksInit() {
        return this.rootContextLockedOnThisSegment != null;
    }

    void initLocks() {
        int i;
        this.localLockState = LocalLockState.UNLOCKED;
        int indexOfThisContext = this.indexInContextChain;
        for (i = indexOfThisContext - 1; i >= 0; --i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        int size = this.contextChain.size();
        for (i = indexOfThisContext + 1; i < size; ++i) {
            if (!this.tryFindInitLocksOfThisSegment(i)) continue;
            return;
        }
        this.rootContextLockedOnThisSegment = this;
        this.nestedContextsLockedOnSameSegment = false;
        this.latestSameThreadSegmentModCount = 0;
        this.contextModCount = 0;
        this.totalReadLockCount = 0;
        this.totalUpdateLockCount = 0;
        this.totalWriteLockCount = 0;
        this.closeLocksDependants();
    }

    public boolean nestedContextsLockedOnSameSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nestedContextsLockedOnSameSegment;
    }

    public int contextModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.contextModCount;
    }

    @Override
    public int latestSameThreadSegmentModCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.latestSameThreadSegmentModCount;
    }

    @Override
    public int totalReadLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalReadLockCount;
    }

    @Override
    public int totalUpdateLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalUpdateLockCount;
    }

    @Override
    public int totalWriteLockCount() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.totalWriteLockCount;
    }

    public LocalLockState localLockState() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.localLockState;
    }

    @Override
    public LocksInterface nextNode() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.nextNode;
    }

    @Override
    public LocksInterface rootContextLockedOnThisSegment() {
        if (!this.locksInit()) {
            this.initLocks();
        }
        return this.rootContextLockedOnThisSegment;
    }

    void closeLocks() {
        if (!this.locksInit()) {
            return;
        }
        this.closeLocksDependants();
        if (this.rootContextLockedOnThisSegment == this) {
            this.closeRootLocks();
        } else {
            this.closeNestedLocks();
        }
        this.deregisterIterationContextLockedInThisThread();
        this.localLockState = null;
        this.rootContextLockedOnThisSegment = null;
    }

    public void closeLocksDependants() {
        this.innerReadLock.closeReadLockLockDependants();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    @Override
    public String debugLocksState() {
        String s = this + ": ";
        if (!this.usedInit()) {
            s = s + "unused";
            return s;
        }
        s = s + "used, ";
        if (!this.segmentIndexInit()) {
            s = s + "segment uninitialized";
            return s;
        }
        s = s + "segment " + this.segmentIndex() + ", ";
        if (!this.locksInit()) {
            s = s + "locks uninitialized";
            return s;
        }
        s = s + "local state: " + (Object)((Object)this.localLockState()) + ", ";
        s = s + "read lock count: " + this.rootContextLockedOnThisSegment().totalReadLockCount() + ", ";
        s = s + "update lock count: " + this.rootContextLockedOnThisSegment().totalUpdateLockCount() + ", ";
        s = s + "write lock count: " + this.rootContextLockedOnThisSegment().totalWriteLockCount();
        return s;
    }

    public boolean hashLookupPosInit() {
        return this.hashLookupPos != -1L;
    }

    public void initHashLookupPos() {
        assert (this.tier() >= 0);
        this.innerReadLock.lock();
        this.hashLookupPos = this.searchStartPos();
        this.closeHashLookupPosDependants();
    }

    public void initHashLookupPos(long hashLookupPos) {
        this.hashLookupPos = hashLookupPos;
        this.closeHashLookupPosDependants();
    }

    public long hashLookupPos() {
        if (!this.hashLookupPosInit()) {
            this.initHashLookupPos();
        }
        return this.hashLookupPos;
    }

    public void closeHashLookupPos() {
        if (!this.hashLookupPosInit()) {
            return;
        }
        this.closeHashLookupPosDependants();
        this.hashLookupPos = -1L;
    }

    public void closeHashLookupPosDependants() {
        this.closeQueryHashLookupSearchFoundDependants();
        this.closeQueryHashLookupSearchNextPosDependants();
        this.closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants();
    }

    public void found() {
        this.setHashLookupPosGuarded(this.hl().stepBack(this.hashLookupPos()));
    }

    public void closeQueryHashLookupSearchFoundDependants() {
        this.closeKeySearch();
    }

    public long nextPos() {
        block2: {
            long entry;
            long pos = this.hashLookupPos();
            do {
                entry = this.hl().readEntry(this.addr(), pos);
                if (this.hl().empty(entry)) {
                    this.setHashLookupPosGuarded(pos);
                    return -1L;
                }
                pos = this.hl().step(pos);
                if (pos == this.searchStartPos()) break block2;
            } while (this.hl().key(entry) != this.searchKey());
            this.setHashLookupPosGuarded(pos);
            return this.hl().value(entry);
        }
        throw new IllegalStateException("MultiMap is full, that most likely means you misconfigured entrySize/chunkSize, and entries tend to take less chunks than expected");
    }

    public void closeQueryHashLookupSearchNextPosDependants() {
        this.closeKeySearch();
    }

    public boolean checkSlotContainsExpectedKeyAndValue(long value) {
        long entry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        return this.hl().key(entry) == this.searchKey() && this.hl().value(entry) == value;
    }

    public void closeQueryHashLookupSearchCheckSlotContainsExpectedKeyAndValueDependants() {
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void putValueVolatile(long newValue) {
        CompactOffHeapLinearHashTable hashLookup = this.h().hashLookup;
        hashLookup.checkValueForPut(newValue);
        hashLookup.putValueVolatile(this.tierBaseAddr(), this.hashLookupPos(), newValue);
    }

    public void remove() {
        this.setHashLookupPosGuarded(this.hl().remove(this.addr(), this.hashLookupPos()));
    }

    boolean keyEquals() {
        return this.inputKey().size() == this.keySize() && BytesUtil.bytesEqual((RandomDataInput)this.segmentBS(), (long)this.keyOffset(), (RandomDataInput)this.inputKey().bytes(), (long)this.inputKey().offset(), (long)this.keySize());
    }

    public void closeKeySearchKeyEqualsDependants() {
        this.closeKeySearch();
    }

    public boolean keyHashInit() {
        return this.keyHash != 0L;
    }

    void initKeyHash() {
        this.keyHash = this.inputKey().hash(LongHashFunction.city_1_1());
    }

    public long keyHash() {
        if (!this.keyHashInit()) {
            this.initKeyHash();
        }
        return this.keyHash;
    }

    public void closeKeyHash() {
        if (!this.keyHashInit()) {
            return;
        }
        this.keyHash = 0L;
    }

    @Override
    public long keyHashCode() {
        return this.keyHash();
    }

    public boolean posInit() {
        return this.pos != -1L;
    }

    public void initPos(long pos) {
        this.pos = pos;
        this.closePosDependants();
    }

    public long pos() {
        assert (this.posInit()) : "Pos should be init";
        return this.pos;
    }

    public void closePos() {
        if (!this.posInit()) {
            return;
        }
        this.closePosDependants();
        this.pos = -1L;
    }

    public void closePosDependants() {
        this.closeEntryOffset();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public boolean entryOffsetInit() {
        return this.keySizeOffset != -1L;
    }

    public void initEntryOffset() {
        this.keySizeOffset = this.entrySpaceOffset() + this.pos() * this.h().chunkSize;
        this.closeEntryOffsetDependants();
    }

    public long keySizeOffset() {
        if (!this.entryOffsetInit()) {
            this.initEntryOffset();
        }
        return this.keySizeOffset;
    }

    public void closeEntryOffset() {
        if (!this.entryOffsetInit()) {
            return;
        }
        this.closeEntryOffsetDependants();
        this.keySizeOffset = -1L;
    }

    public void closeEntryOffsetDependants() {
        this.closeQueryMapEntryStagesEntrySizeDependants();
        this.closeQueryMapEntryStagesReadExistingEntryDependants();
    }

    long entrySize() {
        return this.checksumStrategy.extraEntryBytes() + this.entryEnd() - this.keySizeOffset();
    }

    public void closeQueryMapEntryStagesEntrySizeDependants() {
        this.closeEntrySizeInChunks();
    }

    public boolean entrySizeInChunksInit() {
        return this.entrySizeInChunks != 0;
    }

    void initEntrySizeInChunks() {
        this.entrySizeInChunks = this.h().inChunks(this.entrySize());
    }

    public void initEntrySizeInChunks(int actuallyUsedChunks) {
        this.entrySizeInChunks = actuallyUsedChunks;
    }

    public int entrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            this.initEntrySizeInChunks();
        }
        return this.entrySizeInChunks;
    }

    public void closeEntrySizeInChunks() {
        if (!this.entrySizeInChunksInit()) {
            return;
        }
        this.entrySizeInChunks = 0;
    }

    public void writeNewEntry(long pos, Data<?> key) {
        this.initPos(pos);
        this.initKeySize(key.size());
        Bytes segmentBytes = this.segmentBytesForWriteGuarded();
        segmentBytes.writePosition(this.keySizeOffset());
        this.h().keySizeMarshaller.writeSize(segmentBytes, this.keySize());
        this.initKeyOffset(segmentBytes.writePosition());
        key.writeTo((RandomDataOutput)this.segmentBS(), this.keyOffset());
    }

    public long newSizeOfEverythingBeforeValue(Data<V> newValue) {
        return this.valueSizeOffset() + (long)this.m().valueSizeMarshaller.storingLength(newValue.size()) - this.keySizeOffset();
    }

    public void copyExistingEntry(long newPos, long bytesToCopy, long oldKeyAddr, long oldKeySizeAddr) {
        this.initPos(newPos);
        this.initKeyOffset(this.keySizeOffset() + (oldKeyAddr - oldKeySizeAddr));
        Access.copy((ReadAccess)Access.nativeAccess(), null, (long)oldKeySizeAddr, (WriteAccess)Access.checkedBytesStoreAccess(), (Object)this.segmentBS(), (long)this.keySizeOffset(), (long)bytesToCopy);
    }

    public void readExistingEntry(long pos) {
        this.initPos(pos);
        Bytes segmentBytes = this.segmentBytesForReadGuarded();
        segmentBytes.readPosition(this.keySizeOffset());
        this.initKeySize(this.h().keySizeMarshaller.readSize(segmentBytes));
        this.initKeyOffset(segmentBytes.readPosition());
    }

    public void closeQueryMapEntryStagesReadExistingEntryDependants() {
        this.closeKeySearch();
    }

    boolean keySearchInit() {
        return this.searchState != null;
    }

    public void initKeySearch() {
        long pos;
        while ((pos = this.nextPos()) >= 0L) {
            if (!this.inputKeyInit()) continue;
            this.readExistingEntry(pos);
            if (!this.keyEquals()) continue;
            this.found();
            this.keyFound();
            return;
        }
        this.searchState = SearchState.ABSENT;
        this.closeKeySearchDependants();
    }

    public SearchState searchState() {
        if (!this.keySearchInit()) {
            this.initKeySearch();
        }
        return this.searchState;
    }

    void closeKeySearch() {
        if (!this.keySearchInit()) {
            return;
        }
        this.closeKeySearchDependants();
        this.searchState = null;
    }

    public void closeKeySearchDependants() {
        this.closeKeySearchSearchStatePresentDependants();
        this.closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants();
    }

    public void incrementSegmentEntriesIfNeeded() {
        if (this.searchState() != SearchState.PRESENT) {
            this.entries(this.entries() + 1L);
        }
    }

    public boolean initEntryAndKeyCopying(long entrySize, long bytesToCopy, long prevPos, int prevChunks) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.incrementSegmentEntriesIfNeeded();
        long oldSegmentTierBaseAddr = this.tierBaseAddr();
        long oldKeySizeAddr = oldSegmentTierBaseAddr + this.keySizeOffset();
        long oldKeyAddr = oldSegmentTierBaseAddr + this.keyOffset();
        int tierBeforeAllocation = this.tier();
        long pos = this.alloc(this.allocatedChunks(), prevPos, prevChunks);
        this.copyExistingEntry(pos, bytesToCopy, oldKeyAddr, oldKeySizeAddr);
        return this.tier() != tierBeforeAllocation;
    }

    public boolean initEntryAndKey(long entrySize) {
        this.initAllocatedChunks(this.h().inChunks(entrySize));
        this.incrementSegmentEntriesIfNeeded();
        int tierBeforeAllocation = this.tier();
        long pos = this.alloc(this.allocatedChunks(), -1L, 0);
        this.writeNewEntry(pos, this.inputKey());
        return this.tier() != tierBeforeAllocation;
    }

    public boolean searchStateDeleted() {
        return this.searchState() == SearchState.DELETED && !this.nestedContextsLockedOnSameSegment() && this.innerUpdateLock.isHeldByCurrentThread();
    }

    public boolean searchStatePresent() {
        return this.searchState() == SearchState.PRESENT;
    }

    public void closeKeySearchSearchStatePresentDependants() {
        this.closeMapQueryTieredEntryPresentDependants();
        this.closePresenceOfEntry();
    }

    public boolean searchStateAbsent() {
        return !this.searchStatePresent() && !this.searchStateDeleted();
    }

    private boolean tieredEntryPresent() {
        int firstTier;
        block5: {
            firstTier = this.tier();
            long firstTierBaseAddr = this.tierBaseAddr();
            do {
                if (this.hasNextTier()) {
                    this.nextTier();
                } else if (this.tier() != 0) {
                    this.initSegmentTier();
                }
                if (this.tierBaseAddr() == firstTierBaseAddr) break block5;
            } while (!this.searchStatePresent());
            return true;
        }
        if (firstTier != 0) {
            this.initSegmentTier();
        }
        return false;
    }

    public void closeMapQueryTieredEntryPresentDependants() {
        this.closePresenceOfEntry();
    }

    public void putNewVolatile(long value) {
        assert (!this.searchStatePresent());
        this.hl().checkValueForPut(value);
        long currentEntry = this.hl().readEntry(this.addr(), this.hashLookupPos());
        this.hl().writeEntryVolatile(this.addr(), this.hashLookupPos(), currentEntry, this.searchKey(), value);
    }

    public boolean presenceOfEntryInit() {
        return this.entryPresence != null;
    }

    public void initPresenceOfEntry(EntryPresence entryPresence) {
        this.entryPresence = entryPresence;
    }

    private void initPresenceOfEntry() {
        this.entryPresence = this.searchStatePresent() || this.tieredEntryPresent() ? EntryPresence.PRESENT : EntryPresence.ABSENT;
    }

    public EntryPresence entryPresence() {
        if (!this.presenceOfEntryInit()) {
            this.initPresenceOfEntry();
        }
        return this.entryPresence;
    }

    public void closePresenceOfEntry() {
        if (!this.presenceOfEntryInit()) {
            return;
        }
        this.entryPresence = null;
    }

    public boolean entryPresent() {
        return this.entryPresence() == EntryPresence.PRESENT;
    }

    public final void freeExtraAllocatedChunks() {
        if (!this.m().constantlySizedEntry && this.m().couldNotDetermineAlignmentBeforeAllocation && this.entrySizeInChunks() < this.allocatedChunks()) {
            this.free(this.pos() + (long)this.entrySizeInChunks(), this.allocatedChunks() - this.entrySizeInChunks());
        } else {
            this.initEntrySizeInChunks(this.allocatedChunks());
        }
    }

    protected void relocation(Data<V> newValue, long newSizeOfEverythingBeforeValue) {
        this.innerWriteLock.lock();
        long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
        long oldHashLookupPos = this.hashLookupPos();
        long oldHashLookupAddr = this.tierBaseAddr();
        boolean tierHasChanged = this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - this.keySizeOffset(), this.pos(), this.entrySizeInChunks());
        if (tierHasChanged && !this.searchStateAbsent()) {
            throw new AssertionError();
        }
        this.initValue(newValue);
        this.freeExtraAllocatedChunks();
        CompactOffHeapLinearHashTable hl = this.h().hashLookup;
        long oldEntry = hl.readEntry(oldHashLookupAddr, oldHashLookupPos);
        hl.checkValueForPut(this.pos());
        hl.writeEntryVolatile(this.tierBaseAddr(), this.hashLookupPos(), oldEntry, hl.key(oldEntry), this.pos());
        if (tierHasChanged) {
            hl.remove(oldHashLookupAddr, oldHashLookupPos);
        }
    }

    void putEntry(Data<V> value) {
        assert (this.searchStateAbsent());
        long entrySize = this.entrySize(this.inputKey().size(), value.size());
        this.initEntryAndKey(entrySize);
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putNewVolatile(this.pos());
    }

    public void innerRemoveEntryExceptHashLookupUpdate() {
        this.free(this.pos(), this.entrySizeInChunks());
        this.entries(this.entries() - 1L);
        this.incrementModCountGuarded();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void innerDefaultReplaceValue(Data<V> newValue) {
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            long newValueOffset;
            long newEntrySize;
            long newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long entryStartOffset = this.keySizeOffset();
            VanillaChronicleMap<K, V, R> m = this.m();
            int newSizeInChunks = m.inChunks(newEntrySize = this.newEntrySize(newValue, entryStartOffset, newValueOffset = VanillaChronicleMap.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue, this.m().alignment)));
            if (newSizeInChunks > this.entrySizeInChunks()) {
                if (newSizeInChunks > m.maxChunksPerEntry) {
                    throw new IllegalArgumentException("Value too large: entry takes " + newSizeInChunks + " chunks, " + m.maxChunksPerEntry + " is maximum.");
                }
                if (!this.freeList().isRangeClear(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks)) {
                    this.relocation(newValue, newSizeOfEverythingBeforeValue);
                    return;
                }
                this.freeList().setRange(this.pos() + (long)this.entrySizeInChunks(), this.pos() + (long)newSizeInChunks);
            } else if (newSizeInChunks < this.entrySizeInChunks()) {
                this.freeList().clearRange(this.pos() + (long)newSizeInChunks, this.pos() + (long)this.entrySizeInChunks());
            }
        }
        this.innerWriteLock.lock();
        if (newValueSizeIsDifferent) {
            this.initValue(newValue);
            return;
        }
        this.writeValue(newValue);
    }

    public void putValueDeletedEntry(Data<V> newValue) {
        int newSizeInChunks;
        boolean newValueSizeIsDifferent;
        assert (this.innerUpdateLock.isHeldByCurrentThread());
        long entryStartOffset = this.keySizeOffset();
        long newSizeOfEverythingBeforeValue = -1L;
        boolean bl = newValueSizeIsDifferent = newValue.size() != this.valueSize();
        if (newValueSizeIsDifferent) {
            newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            long newValueOffset = VanillaChronicleMap.alignAddr(entryStartOffset + newSizeOfEverythingBeforeValue, this.m().alignment);
            long newEntrySize = this.newEntrySize(newValue, entryStartOffset, newValueOffset);
            newSizeInChunks = this.m().inChunks(newEntrySize);
        } else {
            newSizeInChunks = this.entrySizeInChunks();
        }
        if (this.pos() + (long)newSizeInChunks < this.freeList().logicalSize() && this.freeList().isRangeClear(this.pos(), this.pos() + (long)newSizeInChunks)) {
            this.freeList().setRange(this.pos(), this.pos() + (long)newSizeInChunks);
            this.innerWriteLock.lock();
            this.incrementSegmentEntriesIfNeeded();
            if (newValueSizeIsDifferent) {
                this.initValue(newValue);
            } else {
                this.writeValue(newValue);
            }
        } else {
            if (newValueSizeIsDifferent) {
                assert (newSizeOfEverythingBeforeValue >= 0L);
            } else {
                newSizeOfEverythingBeforeValue = this.newSizeOfEverythingBeforeValue(newValue);
            }
            long entrySize = this.innerEntrySize(newSizeOfEverythingBeforeValue, newValue.size());
            if (newValueSizeIsDifferent) {
                this.initEntryAndKeyCopying(entrySize, this.valueSizeOffset() - entryStartOffset, -1L, 0);
                this.initValue(newValue);
            } else {
                long oldValueSizeOffset = this.valueSizeOffset();
                long oldValueSize = this.valueSize();
                long oldValueOffset = this.valueOffset();
                this.initEntryAndKeyCopying(entrySize, this.valueOffset() - entryStartOffset, -1L, 0);
                this.initValue_WithoutSize(newValue, oldValueSizeOffset, oldValueSize, oldValueOffset);
            }
            this.freeExtraAllocatedChunks();
        }
        this.putNewVolatile(this.pos());
    }

    public void dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed() {
        if (this.locksInit() && this.nestedContextsLockedOnSameSegment() && this.rootContextLockedOnThisSegment().latestSameThreadSegmentModCount() != this.contextModCount() && this.keySearchInit() && this.searchState() == SearchState.PRESENT && !this.checkSlotContainsExpectedKeyAndValue(this.pos())) {
            this.closeHashLookupPos();
        }
    }

    public void closeMapQueryDropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailedDependants() {
        this.closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants();
    }

    public void checkOnEachPublicOperation() {
        this._CheckOnEachPublicOperation_checkOnEachPublicOperation();
        this.dropSearchIfNestedContextsAndPresentHashLookupSlotCheckFailed();
    }

    public void closeQueryCheckOnEachPublicOperationCheckOnEachPublicOperationDependants() {
        this.entryValue.closeEntryValueBytesDataSizeDependants();
        this.entryKey.closeEntryKeyBytesDataSizeDependants();
    }

    @Override
    public R replaceValue(@NotNull MapEntry<K, V> entry, Data<V> newValue) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.replaceValue(entry, newValue);
    }

    @Override
    @NotNull
    public InterProcessLock updateLock() {
        this.checkOnEachPublicOperation();
        return this.innerUpdateLock;
    }

    @Override
    public void doRemove() {
        this.checkOnEachPublicOperation();
        this.innerUpdateLock.lock();
        if (!this.searchStatePresent()) {
            throw new IllegalStateException("Entry is absent when doRemove() is called");
        }
        this.innerWriteLock.lock();
        this.remove();
        this.innerRemoveEntryExceptHashLookupUpdate();
        this.setSearchStateGuarded(SearchState.DELETED);
        this.initPresenceOfEntry(EntryPresence.ABSENT);
    }

    @Override
    @NotNull
    public InterProcessLock readLock() {
        this.checkOnEachPublicOperation();
        return this.innerReadLock;
    }

    @Override
    public Data<V> wrapValueAsData(V value) {
        this.checkOnEachPublicOperation();
        WrappedValueInstanceDataHolder wrapped = this.wrappedValueInstanceValueHolder;
        wrapped = wrapped.getUnusedWrappedValueHolderGuarded();
        wrapped.initValue(value);
        return wrapped.wrappedData();
    }

    @Override
    @NotNull
    public Data<V> value() {
        this.checkOnEachPublicOperation();
        return this.entryValue;
    }

    @Override
    public Data<K> queriedKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    public Data<V> defaultValue(@NotNull MapAbsentEntry<K, V> absentEntry) {
        this.checkOnEachPublicOperation();
        return this.m().defaultValueProvider.defaultValue(absentEntry);
    }

    @Override
    @NotNull
    public Data<K> absentKey() {
        this.checkOnEachPublicOperation();
        return this.inputKey();
    }

    @Override
    @Nullable
    public MapAbsentEntry<K, V> absentEntry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? null : this.absent();
    }

    protected void putPrefix() {
        boolean searchResultsNotTrusted;
        boolean underUpdatedLockIsHeld;
        this.checkOnEachPublicOperation();
        boolean bl = underUpdatedLockIsHeld = !this.innerUpdateLock.isHeldByCurrentThread();
        if (underUpdatedLockIsHeld) {
            this.innerUpdateLock.lock();
        }
        boolean bl2 = searchResultsNotTrusted = underUpdatedLockIsHeld || this.nestedContextsLockedOnSameSegment();
        if (this.hashLookupPosInit() && this.searchStateAbsent() && searchResultsNotTrusted) {
            this.closeHashLookupPos();
        }
    }

    @Override
    public void doInsert(Data<V> value) {
        this.putPrefix();
        if (!this.entryPresent()) {
            if (this.searchStateDeleted()) {
                this.putValueDeletedEntry(value);
            } else {
                this.putEntry(value);
            }
        } else {
            throw new IllegalStateException("Entry is present in the map when doInsert() is called");
        }
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
        this.initPresenceOfEntry(EntryPresence.PRESENT);
        this.checksumStrategy.computeAndStoreChecksum();
    }

    public void doReplaceValueWithoutChecksum(Data<V> newValue) {
        this.putPrefix();
        if (!this.entryPresent()) {
            throw new IllegalStateException("Entry is absent in the map when doReplaceValue() is called");
        }
        this.innerDefaultReplaceValue(newValue);
        this.incrementModCountGuarded();
        this.setSearchStateGuarded(SearchState.PRESENT);
        this.initPresenceOfEntry(EntryPresence.PRESENT);
    }

    @Override
    public void doReplaceValue(Data<V> newValue) {
        this.doReplaceValueWithoutChecksum(newValue);
        this.checksumStrategy.computeAndStoreChecksum();
    }

    @Override
    @NotNull
    public Data<K> key() {
        this.checkOnEachPublicOperation();
        return this.entryKey;
    }

    @Override
    public R remove(@NotNull MapEntry<K, V> entry) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.remove(entry);
    }

    @Override
    @NotNull
    public InterProcessLock writeLock() {
        this.checkOnEachPublicOperation();
        return this.innerWriteLock;
    }

    @Override
    public MapEntry<K, V> entry() {
        this.checkOnEachPublicOperation();
        return this.entryPresent() ? this : null;
    }

    @Override
    @NotNull
    public MapContext<K, V, ?> context() {
        this.checkOnEachPublicOperation();
        return this;
    }

    @Override
    @NotNull
    public Data<V> defaultValue() {
        this.checkOnEachPublicOperation();
        return this.zeroValueData;
    }

    @Override
    public R insert(@NotNull MapAbsentEntry<K, V> absentEntry, Data<V> value) {
        this.checkOnEachPublicOperation();
        return this.m().entryOperations.insert(absentEntry, value);
    }

    public void writeValueAndPutPos(Data<V> value) {
        this.initValue(value);
        this.freeExtraAllocatedChunks();
        this.putValueVolatile(this.pos());
    }

    public class UsingReturnValue
    implements UsableReturnValue<V> {
        private V usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINIT;
        private V returnedValue = null;

        @Override
        public void returnValue(@NotNull Data<V> value) {
            this.initReturnedValue(value);
        }

        public boolean usingReturnValueInit() {
            return this.usingReturnValue != UsableReturnValue.USING_RETURN_VALUE_UNINIT;
        }

        @Override
        public void initUsingReturnValue(V usingReturnValue) {
            this.usingReturnValue = usingReturnValue;
            this.closeUsingReturnValueDependants();
        }

        public V usingReturnValue() {
            assert (this.usingReturnValueInit()) : "UsingReturnValue should be init";
            return this.usingReturnValue;
        }

        public void closeUsingReturnValue() {
            if (!this.usingReturnValueInit()) {
                return;
            }
            this.closeUsingReturnValueDependants();
            this.usingReturnValue = UsableReturnValue.USING_RETURN_VALUE_UNINIT;
        }

        public void closeUsingReturnValueDependants() {
            this.closeReturnedValue();
        }

        boolean returnedValueInit() {
            return this.returnedValue != null;
        }

        private void initReturnedValue(@NotNull Data<V> value) {
            this.returnedValue = value.getUsing(this.usingReturnValue());
        }

        public V returnedValue() {
            assert (this.returnedValueInit()) : "ReturnedValue should be init";
            return this.returnedValue;
        }

        public void closeReturnedValue() {
            if (!this.returnedValueInit()) {
                return;
            }
            this.returnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.returnedValueInit()) {
                return this.returnedValue();
            }
            return null;
        }
    }

    public class DefaultReturnValue
    implements InstanceReturnValue<V> {
        private V defaultReturnedValue = null;

        @Override
        public void returnValue(@NotNull Data<V> value) {
            this.initDefaultReturnedValue(value);
        }

        boolean defaultReturnedValueInit() {
            return this.defaultReturnedValue != null;
        }

        private void initDefaultReturnedValue(@NotNull Data<V> value) {
            this.defaultReturnedValue = value.getUsing(null);
        }

        public V defaultReturnedValue() {
            assert (this.defaultReturnedValueInit()) : "DefaultReturnedValue should be init";
            return this.defaultReturnedValue;
        }

        public void closeDefaultReturnedValue() {
            if (!this.defaultReturnedValueInit()) {
                return;
            }
            this.defaultReturnedValue = null;
        }

        @Override
        public V returnValue() {
            if (this.defaultReturnedValueInit()) {
                return this.defaultReturnedValue();
            }
            return null;
        }
    }

    public static enum SearchState {
        PRESENT,
        DELETED,
        ABSENT;

    }

    public static enum EntryPresence {
        PRESENT,
        ABSENT;

    }

    public class WriteLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to write lock");
        }

        @NotNull
        private IllegalStateException forbiddenWriteLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire write lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                            if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                                CompiledMapQueryContext.this.incrementWriteGuarded();
                                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapQueryContext.this.segmentHeader().tryWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledMapQueryContext.this.incrementWriteGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapQueryContext.this.updateZeroGuarded());
                        if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledMapQueryContext.this.decrementUpdateGuarded();
                            CompiledMapQueryContext.this.incrementWriteGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.decrementUpdateGuarded();
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                            if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                                CompiledMapQueryContext.this.incrementWriteGuarded();
                                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                                return true;
                            }
                            return false;
                        }
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapQueryContext.this.segmentHeader().tryWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapQueryContext.this.incrementWriteGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapQueryContext.this.updateZeroGuarded());
                        if (CompiledMapQueryContext.this.segmentHeader().tryUpgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapQueryContext.this.decrementUpdateGuarded();
                            CompiledMapQueryContext.this.incrementWriteGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.decrementUpdateGuarded();
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return true;
                }
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapQueryContext.this.localLockState().write;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                            CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledMapQueryContext.this.segmentHeader().writeLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapQueryContext.this.updateZeroGuarded());
                        CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                    }
                    CompiledMapQueryContext.this.decrementUpdateGuarded();
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: 
                case UPDATE_LOCKED: {
                    return;
                }
                case WRITE_LOCKED: {
                    int newTotalWriteLockCount = CompiledMapQueryContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        CompiledMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalWriteLockCount > 0) : "write underflow";
                    break;
                }
            }
            CompiledMapQueryContext.this.incrementUpdateGuarded();
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                            CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        } else {
                            if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                                throw this.forbiddenWriteLockWhenOuterContextReadLocked();
                            }
                            CompiledMapQueryContext.this.segmentHeader().writeLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        }
                    }
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: {
                    if (CompiledMapQueryContext.this.writeZeroGuarded()) {
                        assert (!CompiledMapQueryContext.this.updateZeroGuarded());
                        CompiledMapQueryContext.this.segmentHeader().upgradeUpdateToWriteLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                    }
                    CompiledMapQueryContext.this.decrementUpdateGuarded();
                    CompiledMapQueryContext.this.incrementWriteGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.WRITE_LOCKED);
                }
            }
        }
    }

    public class WrappedValueInstanceDataHolder {
        private final DataAccess<V> wrappedValueDataAccess;
        private V value;
        public Data<V> wrappedData = null;
        private WrappedValueInstanceDataHolder next;

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolderGuarded() {
            assert (this.nextInit()) : "Next should be init";
            return this.getUnusedWrappedValueHolder();
        }

        public WrappedValueInstanceDataHolder() {
            this.wrappedValueDataAccess = (DataAccess)CompiledMapQueryContext.this.m().valueDataAccess.copy();
        }

        public DataAccess<V> wrappedValueDataAccess() {
            return this.wrappedValueDataAccess;
        }

        public WrappedValueInstanceDataHolder getUnusedWrappedValueHolder() {
            if (!this.valueInit()) {
                return this;
            }
            if (this.next == null) {
                this.next = new WrappedValueInstanceDataHolder();
            }
            return this.next.getUnusedWrappedValueHolder();
        }

        public boolean valueInit() {
            return this.value != null;
        }

        public void initValue(V value) {
            CompiledMapQueryContext.this.m().checkValue(value);
            this.value = value;
            this.closeValueDependants();
        }

        public V value() {
            assert (this.valueInit()) : "Value should be init";
            return this.value;
        }

        public void closeValue() {
            if (!this.valueInit()) {
                return;
            }
            this.closeValueDependants();
            this.value = null;
            if (this.next != null) {
                this.next.closeValue();
            }
        }

        public void closeValueDependants() {
            this.closeWrappedData();
        }

        public boolean wrappedDataInit() {
            return this.wrappedData != null;
        }

        private void initWrappedData() {
            this.wrappedData = this.wrappedValueDataAccess.getData(this.value());
        }

        public Data<V> wrappedData() {
            if (!this.wrappedDataInit()) {
                this.initWrappedData();
            }
            return this.wrappedData;
        }

        private void closeWrappedData() {
            if (!this.wrappedDataInit()) {
                return;
            }
            this.wrappedData = null;
            this.wrappedValueDataAccess.uninit();
        }

        boolean nextInit() {
            return true;
        }

        void closeNext() {
            if (!this.nextInit()) {
                return;
            }
        }
    }

    public class UpdateLock
    implements InterProcessLock {
        @NotNull
        private IllegalMonitorStateException forbiddenUpgrade() {
            return new IllegalMonitorStateException("Cannot upgrade from read to update lock");
        }

        @NotNull
        private IllegalStateException forbiddenUpdateLockWhenOuterContextReadLocked() {
            return new IllegalStateException("Cannot acquire update lock, because outer context holds read lock. In this case you should acquire update lock in the outer context up front");
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapQueryContext.this.localLockState().update;
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                            CompiledMapQueryContext.this.incrementUpdateGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.incrementUpdateGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public boolean tryLock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        if (CompiledMapQueryContext.this.segmentHeader().tryUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                            CompiledMapQueryContext.this.incrementUpdateGuarded();
                            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                            return true;
                        }
                        return false;
                    }
                    CompiledMapQueryContext.this.incrementUpdateGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return true;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
                case UPDATE_LOCKED: 
                case WRITE_LOCKED: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        CompiledMapQueryContext.this.segmentHeader().updateLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                    }
                    CompiledMapQueryContext.this.incrementUpdateGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }

        @Override
        public void unlock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: 
                case READ_LOCKED: {
                    return;
                }
                case UPDATE_LOCKED: {
                    int newTotalUpdateLockCount = CompiledMapQueryContext.this.decrementUpdateGuarded();
                    if (newTotalUpdateLockCount == 0) {
                        if (!CompiledMapQueryContext.this.writeZeroGuarded()) break;
                        CompiledMapQueryContext.this.segmentHeader().downgradeUpdateToReadLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalUpdateLockCount > 0) : "update underflow";
                    break;
                }
                case WRITE_LOCKED: {
                    int newTotalWriteLockCount = CompiledMapQueryContext.this.decrementWriteGuarded();
                    if (newTotalWriteLockCount == 0) {
                        if (!CompiledMapQueryContext.this.updateZeroGuarded()) {
                            CompiledMapQueryContext.this.segmentHeader().downgradeWriteToUpdateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                            break;
                        }
                        CompiledMapQueryContext.this.segmentHeader().downgradeWriteToReadLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        break;
                    }
                    assert (newTotalWriteLockCount > 0) : "write underflow";
                    break;
                }
            }
            CompiledMapQueryContext.this.incrementReadGuarded();
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
        }

        @Override
        public void lock() {
            switch (CompiledMapQueryContext.this.localLockState()) {
                case UNLOCKED: {
                    CompiledMapQueryContext.this.checkIterationContextNotLockedInThisThread();
                    if (CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                        if (!CompiledMapQueryContext.this.readZeroGuarded()) {
                            throw this.forbiddenUpdateLockWhenOuterContextReadLocked();
                        }
                        try {
                            CompiledMapQueryContext.this.segmentHeader().updateLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                        }
                        catch (RuntimeException e) {
                            LOG.error(CompiledMapQueryContext.this.debugContextsAndLocksGuarded());
                            throw e;
                        }
                    }
                    CompiledMapQueryContext.this.incrementUpdateGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UPDATE_LOCKED);
                    return;
                }
                case READ_LOCKED: {
                    throw this.forbiddenUpgrade();
                }
            }
        }
    }

    public class ReadLock
    implements InterProcessLock {
        @Override
        public boolean isHeldByCurrentThread() {
            return CompiledMapQueryContext.this.localLockState().read;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapQueryContext.this.readZeroGuarded() && CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                    CompiledMapQueryContext.this.segmentHeader().readLockInterruptibly(CompiledMapQueryContext.this.segmentHeaderAddress());
                }
                CompiledMapQueryContext.this.incrementReadGuarded();
                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        @Override
        public void lock() {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (CompiledMapQueryContext.this.readZeroGuarded() && CompiledMapQueryContext.this.updateZeroGuarded() && CompiledMapQueryContext.this.writeZeroGuarded()) {
                    CompiledMapQueryContext.this.segmentHeader().readLock(CompiledMapQueryContext.this.segmentHeaderAddress());
                }
                CompiledMapQueryContext.this.incrementReadGuarded();
                CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
            }
        }

        public void closeReadLockLockDependants() {
            CompiledMapQueryContext.this.closeHashLookupPos();
        }

        @Override
        public void unlock() {
            CompiledMapQueryContext.this.readUnlockAndDecrementCountGuarded();
            CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.UNLOCKED);
            CompiledMapQueryContext.this.closeHashLookupPos();
            CompiledMapQueryContext.this.closePos();
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledMapQueryContext.this.readZeroGuarded() || !CompiledMapQueryContext.this.updateZeroGuarded() || !CompiledMapQueryContext.this.writeZeroGuarded() || CompiledMapQueryContext.this.segmentHeader().tryReadLock(CompiledMapQueryContext.this.segmentHeaderAddress(), time, unit)) {
                    CompiledMapQueryContext.this.incrementReadGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean tryLock() {
            if (CompiledMapQueryContext.this.localLockState() == LocalLockState.UNLOCKED) {
                if (!CompiledMapQueryContext.this.readZeroGuarded() || !CompiledMapQueryContext.this.updateZeroGuarded() || !CompiledMapQueryContext.this.writeZeroGuarded() || CompiledMapQueryContext.this.segmentHeader().tryReadLock(CompiledMapQueryContext.this.segmentHeaderAddress())) {
                    CompiledMapQueryContext.this.incrementReadGuarded();
                    CompiledMapQueryContext.this.setLocalLockStateGuarded(LocalLockState.READ_LOCKED);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    public class HashKeyCrc32PayloadChecksumStrategy
    implements ChecksumStrategy {
        @Override
        public long extraEntryBytes() {
            return 4L;
        }

        private int computeChecksum() {
            long checksum;
            long keyHashCode = CompiledMapQueryContext.this.keyHashCode();
            long keyEnd = CompiledMapQueryContext.this.keyEnd();
            long len = CompiledMapQueryContext.this.entryEnd() - keyEnd;
            if (len > 0L) {
                long addr = CompiledMapQueryContext.this.tierBaseAddr() + keyEnd;
                int payloadCrc = Crc32.compute(addr, len);
                checksum = ChecksumHashing.hash8To16Bytes(CompiledMapQueryContext.this.keySize(), keyHashCode, payloadCrc);
            } else {
                checksum = ChecksumHashing.hash8To16Bytes(CompiledMapQueryContext.this.keySize(), keyHashCode, keyHashCode);
            }
            return (int)(checksum >>> 32 ^ checksum);
        }

        @Override
        public void computeAndStoreChecksum() {
            int crc = this.computeChecksum();
            CompiledMapQueryContext.this.segmentBS().writeInt(CompiledMapQueryContext.this.entryEnd(), crc);
        }

        @Override
        public boolean innerCheckSum() {
            int crc;
            int oldChecksum = CompiledMapQueryContext.this.segmentBS().readInt(CompiledMapQueryContext.this.entryEnd());
            return oldChecksum == (crc = this.computeChecksum());
        }

        @Override
        public boolean checkSum() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerCheckSum();
        }

        @Override
        public void updateChecksum() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.computeAndStoreChecksum();
        }
    }

    public class EntryValueBytesData
    extends AbstractData<V> {
        private V cachedEntryValue;
        private boolean cachedEntryValueRead;

        public EntryValueBytesData() {
            this.cachedEntryValue = CompiledMapQueryContext.this.m().valueClass() == CharSequence.class ? new StringBuilder() : null;
            this.cachedEntryValueRead = false;
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueOffset();
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.valueSize();
        }

        public void closeEntryValueBytesDataSizeDependants() {
            this.closeEntryValueBytesDataInnerGetUsingDependants();
        }

        private V innerGetUsing(V usingValue) {
            Bytes segmentBytes = CompiledMapQueryContext.this.segmentBytesForReadGuarded();
            segmentBytes.readPosition(CompiledMapQueryContext.this.valueOffset());
            return CompiledMapQueryContext.this.valueReader.read(segmentBytes, this.size(), usingValue);
        }

        public void closeEntryValueBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryValue();
        }

        @Override
        public V getUsing(V using) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }

        public boolean cachedEntryValueInit() {
            return this.cachedEntryValueRead;
        }

        private void initCachedEntryValue() {
            this.cachedEntryValue = this.innerGetUsing(this.cachedEntryValue);
            this.cachedEntryValueRead = true;
        }

        public V cachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                this.initCachedEntryValue();
            }
            return this.cachedEntryValue;
        }

        public void closeCachedEntryValue() {
            if (!this.cachedEntryValueInit()) {
                return;
            }
            this.cachedEntryValueRead = false;
        }

        @Override
        public V get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryValue();
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.segmentBS();
        }
    }

    public class EntryKeyBytesData
    extends AbstractData<K> {
        private K cachedEntryKey;
        private boolean cachedEntryKeyRead = false;

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.segmentBS();
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keyOffset();
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return CompiledMapQueryContext.this.keySize();
        }

        public void closeEntryKeyBytesDataSizeDependants() {
            this.closeEntryKeyBytesDataInnerGetUsingDependants();
        }

        private K innerGetUsing(K usingKey) {
            Bytes bytes = CompiledMapQueryContext.this.segmentBytesForReadGuarded();
            bytes.readPosition(CompiledMapQueryContext.this.keyOffset());
            return CompiledMapQueryContext.this.keyReader.read(bytes, this.size(), usingKey);
        }

        public void closeEntryKeyBytesDataInnerGetUsingDependants() {
            this.closeCachedEntryKey();
        }

        public boolean cachedEntryKeyInit() {
            return this.cachedEntryKeyRead;
        }

        private void initCachedEntryKey() {
            this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
            this.cachedEntryKeyRead = true;
        }

        public K cachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                this.initCachedEntryKey();
            }
            return this.cachedEntryKey;
        }

        public void closeCachedEntryKey() {
            if (!this.cachedEntryKeyInit()) {
                return;
            }
            this.cachedEntryKeyRead = false;
        }

        @Override
        public K get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.cachedEntryKey();
        }

        @Override
        public K getUsing(K using) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return this.innerGetUsing(using);
        }
    }

    public class DummyValueZeroData
    extends AbstractData<V> {
        private final Bytes zeroBytes = ZeroBytesStore.INSTANCE.bytesForRead();

        public Bytes zeroBytes() {
            return this.zeroBytes;
        }

        private IllegalStateException zeroReadException(Exception cause) {
            return new IllegalStateException("Most probable cause of this exception - zero bytes of\nthe minimum positive encoding length, supported by the specified or default\nvalueSizeMarshaller() is not correct serialized form of any value. You should\nconfigure defaultValueProvider() in ChronicleMapBuilder");
        }

        @Override
        public long size() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return Math.max(0L, CompiledMapQueryContext.this.m().valueSizeMarshaller.minStorableSize());
        }

        @Override
        public V getUsing(V using) {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            this.zeroBytes.readPosition(0L);
            try {
                return CompiledMapQueryContext.this.valueReader.read(this.zeroBytes, this.size(), using);
            }
            catch (Exception e) {
                throw this.zeroReadException(e);
            }
        }

        @Override
        public V get() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            try {
                return this.getUsing(null);
            }
            catch (Exception e) {
                throw this.zeroReadException(e);
            }
        }

        @Override
        public RandomDataInput bytes() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return ZeroBytesStore.INSTANCE;
        }

        @Override
        public long offset() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            return 0L;
        }
    }

    public class AcquireHandle
    implements Closeable {
        public void close() {
            CompiledMapQueryContext.this.checkOnEachPublicOperation();
            CompiledMapQueryContext.this.replaceValue(CompiledMapQueryContext.this.entry(), CompiledMapQueryContext.this.wrapValueAsData(CompiledMapQueryContext.this.usingReturnValue.returnValue()));
            CompiledMapQueryContext.this.close();
        }
    }
}

